/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.utils;

import android.content.Context;
import com.tune.ma.utils.TuneFileUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneJSONPlayer {
    private int counter;
    private List<JSONObject> files;
    private Context context;

    public TuneJSONPlayer(Context context) {
        this.context = context;
        this.counter = -1;
    }

    public JSONObject getNext() {
        this.incrementDownload();
        return this.files.get(this.counter);
    }

    public void setFiles(List<String> filenames) {
        this.files = this.buildListWithFilenames(filenames);
    }

    private void incrementDownload() {
        if (this.files.size() > 0 && this.counter + 1 < this.files.size()) {
            ++this.counter;
        }
    }

    private List<JSONObject> buildListWithFilenames(List<String> filenames) {
        ArrayList<JSONObject> fileArray = new ArrayList<JSONObject>();
        for (String filename : filenames) {
            try {
                fileArray.add(TuneFileUtils.readFileFromAssetsIntoJsonObject(this.context, filename));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return fileArray;
    }
}

