/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.utils;

import android.content.Context;
import com.tune.ma.utils.TuneDebugLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneFileUtils {
    private static final String TAG = "FileUtils";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String content, String fileName, Object lock, Context context) {
        Object object = lock;
        synchronized (object) {
            FileOutputStream outputStream = null;
            File file = new File(context.getFilesDir(), fileName);
            try {
                outputStream = new FileOutputStream(file, false);
                outputStream.write(content.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                TuneDebugLog.e(TAG, "Error writing file with fileName: " + fileName);
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static JSONObject readJsonFile(String fileName, Object lock, Context context) {
        JSONObject result = null;
        String fileContent = TuneFileUtils.readFile(fileName, lock, context);
        if (fileContent != null) {
            try {
                result = new JSONObject(fileContent);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String fileName, Object lock, Context context) {
        Object object = lock;
        synchronized (object) {
            String result = null;
            File file = new File(context.getFilesDir(), fileName);
            if (file.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(file);
                    int size = fis.available();
                    byte[] buffer = new byte[size];
                    fis.read(buffer);
                    fis.close();
                    result = new String(buffer, "UTF-8");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return result;
        }
    }

    public static JSONObject readFileFromAssetsIntoJsonObject(Context context, String fileName) throws JSONException {
        String json = null;
        try {
            InputStream is = context.getAssets().open(fileName);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            json = new String(buffer, "UTF-8");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return new JSONObject(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String fileName, Object lock, Context context) {
        Object object = lock;
        synchronized (object) {
            File fileToDelete = new File(context.getFilesDir(), fileName);
            if (fileToDelete != null && fileToDelete.exists()) {
                fileToDelete.delete();
            }
        }
    }
}

