/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.utils;

import android.util.Log;
import com.tune.Tune;
import com.tune.ma.TuneIAMConfigurationException;

public class TuneDebugLog {
    public static final int VERBOSE = 0;
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    private static boolean enableLog = true;
    private static final String STARS = "*******";
    public static int logLevel = 4;
    private static final int ENTRY_MAX_LEN = 4000;

    public static void important(String msg) {
        TuneDebugLog.d(TuneDebugLog.getTag(), "******* " + msg + " " + STARS);
    }

    public static void i(String msg) {
        TuneDebugLog.i(TuneDebugLog.getTag(), msg);
    }

    public static void i(String msg, Throwable tr) {
        TuneDebugLog.i(TuneDebugLog.getTag(), msg, tr);
    }

    public static void i(String tag, String msg) {
        if (!enableLog || logLevel > 2) {
            return;
        }
        tag = tag + TuneDebugLog.getTag();
        Log.i((String)tag, (String)msg);
    }

    public static void i(String tag, String msg, Throwable tr) {
        if (!enableLog || logLevel > 2) {
            return;
        }
        tag = tag + TuneDebugLog.getTag();
        Log.i((String)tag, (String)msg, (Throwable)tr);
    }

    public static void v(String msg) {
        TuneDebugLog.v(TuneDebugLog.getTag(), msg);
    }

    public static void v(String msg, Throwable tr) {
        TuneDebugLog.v(TuneDebugLog.getTag(), msg, tr);
    }

    public static void v(String tag, String msg) {
        if (!enableLog || logLevel > 0) {
            return;
        }
        tag = tag + TuneDebugLog.getTag();
        Log.v((String)tag, (String)msg);
    }

    public static void v(String tag, String msg, Throwable tr) {
        if (!enableLog || logLevel > 0) {
            return;
        }
        tag = tag + TuneDebugLog.getTag();
        Log.v((String)tag, (String)msg, (Throwable)tr);
    }

    public static void d(String msg) {
        TuneDebugLog.d(TuneDebugLog.getTag(), msg);
    }

    public static void d(String msg, Throwable tr) {
        TuneDebugLog.d(TuneDebugLog.getTag(), msg, tr);
    }

    public static void d(String tag, String msg) {
        if (!enableLog || logLevel > 1) {
            return;
        }
        tag = tag + TuneDebugLog.getTag();
        Log.d((String)tag, (String)msg);
    }

    public static void d(String tag, String msg, Throwable tr) {
        if (!enableLog || logLevel > 1) {
            return;
        }
        tag = tag + TuneDebugLog.getTag();
        Log.d((String)tag, (String)msg, (Throwable)tr);
    }

    public static void w(String msg) {
        TuneDebugLog.w(TuneDebugLog.getTag(), msg);
    }

    public static void w(String msg, Throwable tr) {
        TuneDebugLog.w(TuneDebugLog.getTag(), msg, tr);
    }

    public static void w(String tag, String msg) {
        if (!enableLog || logLevel > 3) {
            return;
        }
        tag = tag + TuneDebugLog.getTag();
        Log.w((String)tag, (String)msg);
    }

    public static void w(String tag, String msg, Throwable tr) {
        if (!enableLog || logLevel > 3) {
            return;
        }
        tag = tag + TuneDebugLog.getTag();
        Log.w((String)tag, (String)msg, (Throwable)tr);
    }

    public static void e(String msg) {
        TuneDebugLog.e(TuneDebugLog.getTag(), msg);
    }

    public static void e(String msg, Throwable tr) {
        TuneDebugLog.e(TuneDebugLog.getTag(), msg, tr);
    }

    public static void e(String tag, String msg) {
        if (!enableLog || logLevel > 4) {
            return;
        }
        tag = tag + TuneDebugLog.getTag();
        Log.e((String)tag, (String)msg);
    }

    public static void e(String tag, String msg, Throwable tr) {
        if (!enableLog || logLevel > 4) {
            return;
        }
        tag = tag + TuneDebugLog.getTag();
        Log.e((String)tag, (String)msg, (Throwable)tr);
    }

    public static void alwaysLog(String msg) {
        while (!msg.isEmpty()) {
            int lastNewLine = msg.lastIndexOf(10, 4000);
            int nextEnd = lastNewLine != -1 ? lastNewLine : Math.min(4000, msg.length());
            String next = msg.substring(0, nextEnd);
            Log.i((String)TuneDebugLog.getTag(), (String)next);
            if (lastNewLine != -1) {
                msg = msg.substring(nextEnd + 1);
                continue;
            }
            msg = msg.substring(nextEnd);
        }
    }

    static String getTag() {
        return TuneDebugLog.getTag(5);
    }

    static String getTag(int level) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        String fullClassName = trace[level].getClassName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        String methodName = trace[level].getMethodName();
        int lineNumber = trace[level].getLineNumber();
        if (className.equals("TuneDebugLog")) {
            return "";
        }
        if (trace[level].toString().contains("EventHandler_")) {
            return className + " @ line: " + lineNumber;
        }
        return className + "#" + methodName + "():" + lineNumber;
    }

    public static boolean isEnableLog() {
        return enableLog;
    }

    public static void enableLog() {
        enableLog = true;
    }

    public static void disableLog() {
        enableLog = false;
    }

    public static void setLogLevel(int level) {
        logLevel = level;
    }

    public static void IAMConfigError(String message) {
        if (Tune.getInstance() != null && Tune.getInstance().isInDebugMode()) {
            throw new TuneIAMConfigurationException(message);
        }
        TuneDebugLog.e(TuneDebugLog.getTag(5), message);
    }
}

