/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.utils;

import com.tune.ma.utils.TuneDebugLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TuneDateUtils {
    public static SimpleDateFormat getTuneDateFormatter() {
        SimpleDateFormat tuneDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        tuneDateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return tuneDateFormatter;
    }

    public static Date getNowUTC() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        return cal.getTime();
    }

    public static boolean doesNowFallBetweenDates(Date startDate, Date endDate) {
        Date now = TuneDateUtils.getNowUTC();
        return now.equals(startDate) || now.equals(endDate) || now.after(startDate) && now.before(endDate);
    }

    public static Date parseIso8601(String iso8601String) {
        if (iso8601String == null) {
            return null;
        }
        String utcString = iso8601String.replace("Z", "+00:00");
        try {
            utcString = utcString.substring(0, 22) + utcString.substring(23);
        }
        catch (IndexOutOfBoundsException e) {
            TuneDebugLog.e("TuneDateUtils", "Error building Date String: " + iso8601String);
            return null;
        }
        try {
            return TuneDateUtils.getTuneDateFormatter().parse(utcString);
        }
        catch (ParseException e) {
            TuneDebugLog.e("TuneDateUtils", "Error parsing Date: " + iso8601String);
            return null;
        }
    }
}

