/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.session;

import android.app.Activity;
import android.content.Context;
import com.tune.ma.eventbus.TuneEventBus;
import com.tune.ma.eventbus.event.TuneActivityConnected;
import com.tune.ma.eventbus.event.TuneActivityDisconnected;
import com.tune.ma.eventbus.event.TuneAppBackgrounded;
import com.tune.ma.eventbus.event.TuneAppForegrounded;
import com.tune.ma.session.TuneSession;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class TuneSessionManager {
    public static final int SESSION_TIMEOUT = 1000;
    protected Context context;
    private Timer sessionEndTimer;
    private TuneSession session;
    private ArrayList<Activity> connectedActivities = new ArrayList();
    private boolean hasActivityVisible;
    private static TuneSessionManager instance = null;

    protected TuneSessionManager() {
    }

    public static TuneSessionManager getInstance() {
        if (instance == null) {
            instance = new TuneSessionManager();
        }
        return instance;
    }

    public static void clearInstance() {
        if (TuneSessionManager.instance.sessionEndTimer != null) {
            TuneSessionManager.instance.sessionEndTimer.cancel();
            TuneSessionManager.instance.sessionEndTimer = null;
        }
        instance = null;
    }

    public static TuneSessionManager init(Context context) {
        if (instance == null) {
            instance = new TuneSessionManager();
        }
        TuneSessionManager.instance.context = context;
        return instance;
    }

    public void onEvent(TuneActivityConnected event) {
        this.connectActivity(event.getActivity());
    }

    public void onEvent(TuneActivityDisconnected event) {
        this.disconnectActivity(event.getActivity());
    }

    private synchronized void startSession() {
        if (this.sessionEndTimer != null) {
            this.sessionEndTimer.cancel();
            this.sessionEndTimer = null;
            return;
        }
        this.session = new TuneSession();
        long currentTime = System.currentTimeMillis();
        String sessionId = "t" + currentTime / 1000L + "-" + UUID.randomUUID().toString();
        TuneEventBus.post(new TuneAppForegrounded(sessionId, currentTime));
    }

    private synchronized void endSession() {
        this.sessionEndTimer = new Timer();
        this.sessionEndTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (TuneSessionManager.this.session != null) {
                    TuneSessionManager.this.session.setSessionLength(System.currentTimeMillis() - TuneSessionManager.this.session.getCreatedDate());
                }
                TuneEventBus.post(new TuneAppBackgrounded());
                TuneSessionManager.this.sessionEndTimer = null;
            }
        }, 1000L);
    }

    private synchronized void connectActivity(Activity activity) {
        this.connectedActivities.add(activity);
        if (this.connectedActivities.size() == 1) {
            this.hasActivityVisible = true;
            this.startSession();
        }
    }

    private synchronized void disconnectActivity(Activity activity) {
        this.connectedActivities.remove(activity);
        if (this.connectedActivities.size() == 0) {
            this.hasActivityVisible = false;
            this.endSession();
        }
    }

    public ArrayList<Activity> getConnectedActivities() {
        return this.connectedActivities;
    }

    public TuneSession getSession() {
        return this.session;
    }

    public synchronized double getSecondsSinceSessionStart() {
        if (this.session == null) {
            return -1.0;
        }
        return (double)(System.currentTimeMillis() - this.session.getCreatedDate()) / 1000.0;
    }

    public synchronized boolean hasActivityVisible() {
        return this.hasActivityVisible;
    }

    public synchronized void setActivityVisible(boolean hasActivityVisible) {
        this.hasActivityVisible = hasActivityVisible;
    }
}

