/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.push.settings;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import com.tune.ma.utils.TuneDebugLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneNotificationBuilder {
    private int smallIconId;
    private int largeIconId;
    private String sortKey;
    private String groupKey;
    private int colorARGB;
    private int visibility;
    private Uri sound;
    private long[] vibratePattern;
    private boolean onlyAlertOnce;
    private boolean isSmallIconSet = true;
    private boolean isLargeIconSet;
    private boolean isSortKeySet;
    private boolean isGroupKeySet;
    private boolean isColorSet;
    private boolean isVisibilitySet;
    private boolean isSoundSet;
    private boolean isVibrateSet;
    private boolean isOnlyAlertOnceSet;
    private boolean isNoSoundSet;
    private boolean isNoVibrateSet;
    private static final String JSON_SMALL_ICON_ID = "smallIconId";
    private static final String JSON_LARGE_ICON_ID = "largeIconId";
    private static final String JSON_AUTO_CANCEL = "autoCancel";
    private static final String JSON_SORT_KEY = "sortKey";
    private static final String JSON_GROUP_KEY = "groupKey";
    private static final String JSON_COLOR_ARGB = "colorARGB";
    private static final String JSON_VISIBILITY = "visibility";
    private static final String JSON_SOUND = "sound";
    private static final String JSON_VIBRATE = "vibrate";
    private static final String JSON_NO_SOUND = "noSound";
    private static final String JSON_NO_VIBRATE = "noVibrate";
    private static final String JSON_ONLY_ALERT_ONCE = "onlyAlertOnce";

    public TuneNotificationBuilder(int smallIconId) {
        this.smallIconId = smallIconId;
    }

    public TuneNotificationBuilder setLargeIcon(int largeIconId) {
        this.isLargeIconSet = true;
        this.largeIconId = largeIconId;
        return this;
    }

    public TuneNotificationBuilder setSortKey(String sortKey) {
        this.isSortKeySet = true;
        this.sortKey = sortKey;
        return this;
    }

    public TuneNotificationBuilder setGroup(String groupKey) {
        this.isGroupKeySet = true;
        this.groupKey = groupKey;
        return this;
    }

    public TuneNotificationBuilder setColor(int argb) {
        this.isColorSet = true;
        this.colorARGB = argb;
        return this;
    }

    public TuneNotificationBuilder setVisibility(int visibility) {
        this.isVisibilitySet = true;
        this.visibility = visibility;
        return this;
    }

    public TuneNotificationBuilder setSound(Uri sound) {
        this.isSoundSet = true;
        this.isNoSoundSet = false;
        this.sound = sound;
        return this;
    }

    public TuneNotificationBuilder setVibrate(long[] pattern) {
        this.isVibrateSet = true;
        this.isNoVibrateSet = false;
        this.vibratePattern = pattern;
        return this;
    }

    public TuneNotificationBuilder setOnlyAlertOnce(boolean onlyAlertOnce) {
        this.isOnlyAlertOnceSet = true;
        this.onlyAlertOnce = onlyAlertOnce;
        return this;
    }

    public TuneNotificationBuilder setNoSound() {
        this.isNoSoundSet = true;
        this.isSoundSet = false;
        this.sound = null;
        return this;
    }

    public TuneNotificationBuilder setNoVibrate() {
        this.isNoVibrateSet = true;
        this.isVibrateSet = false;
        this.vibratePattern = null;
        return this;
    }

    public NotificationCompat.Builder build(Context context) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context.getApplicationContext());
        if (this.isSmallIconSet) {
            builder.setSmallIcon(this.smallIconId);
        }
        if (this.isLargeIconSet) {
            Bitmap bm = BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.largeIconId);
            builder.setLargeIcon(bm);
        }
        if (this.isSortKeySet) {
            builder.setSortKey(this.sortKey);
        }
        if (this.isGroupKeySet) {
            builder.setGroup(this.groupKey);
        }
        if (this.isColorSet) {
            try {
                builder.setColor(this.colorARGB);
            }
            catch (Exception e) {
                TuneDebugLog.e("Cannot set color on notification builder. Make sure you have the latest revision of the Android Support Library v4 (22.+)", e);
            }
        }
        if (this.isVisibilitySet) {
            try {
                builder.setVisibility(this.visibility);
            }
            catch (Exception e) {
                TuneDebugLog.e("Cannot set visibility on notification builder. Make sure you have the latest revision of the Android Support Library v4 (22.+)", e);
            }
        }
        if (this.isSoundSet) {
            builder.setSound(this.sound);
        }
        if (this.isVibrateSet) {
            builder.setVibrate(this.vibratePattern);
        }
        if (this.isOnlyAlertOnceSet) {
            builder.setOnlyAlertOnce(this.onlyAlertOnce);
        }
        return builder;
    }

    public boolean hasCustomization() {
        return this.isColorSet || this.isGroupKeySet || this.isLargeIconSet || this.isSmallIconSet || this.isSortKeySet || this.isVisibilitySet || this.isSoundSet || this.isVibrateSet || this.isOnlyAlertOnceSet || this.isNoSoundSet || this.isNoVibrateSet;
    }

    public boolean isSoundSet() {
        return this.isSoundSet;
    }

    public boolean isVibrateSet() {
        return this.isVibrateSet;
    }

    public boolean isNoSoundSet() {
        return this.isNoSoundSet;
    }

    public boolean isNoVibrateSet() {
        return this.isNoVibrateSet;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject result = new JSONObject();
        if (this.isSmallIconSet) {
            result.put(JSON_SMALL_ICON_ID, this.smallIconId);
        }
        if (this.isLargeIconSet) {
            result.put(JSON_LARGE_ICON_ID, this.largeIconId);
        }
        if (this.isSortKeySet) {
            result.put(JSON_SORT_KEY, (Object)this.sortKey);
        }
        if (this.isGroupKeySet) {
            result.put(JSON_GROUP_KEY, (Object)this.groupKey);
        }
        if (this.isColorSet) {
            result.put(JSON_COLOR_ARGB, this.colorARGB);
        }
        if (this.isVisibilitySet) {
            result.put(JSON_VISIBILITY, this.visibility);
        }
        if (this.isSoundSet) {
            result.put(JSON_SOUND, (Object)this.sound.toString());
        }
        if (this.isVibrateSet) {
            result.put(JSON_VIBRATE, (Object)new JSONArray((Object)this.vibratePattern));
        }
        if (this.isOnlyAlertOnceSet) {
            result.put(JSON_ONLY_ALERT_ONCE, this.onlyAlertOnce);
        }
        if (this.isNoSoundSet) {
            result.put(JSON_NO_SOUND, this.isNoSoundSet);
        }
        if (this.isNoVibrateSet) {
            result.put(JSON_NO_VIBRATE, this.isNoVibrateSet);
        }
        return result;
    }

    public static TuneNotificationBuilder fromJson(String json) throws JSONException {
        JSONObject j = new JSONObject(json);
        TuneNotificationBuilder result = new TuneNotificationBuilder(j.getInt(JSON_SMALL_ICON_ID));
        if (j.has(JSON_LARGE_ICON_ID)) {
            result.setLargeIcon(j.getInt(JSON_LARGE_ICON_ID));
        }
        if (j.has(JSON_SORT_KEY)) {
            result.setSortKey(j.getString(JSON_SORT_KEY));
        }
        if (j.has(JSON_GROUP_KEY)) {
            result.setGroup(j.getString(JSON_GROUP_KEY));
        }
        if (j.has(JSON_COLOR_ARGB)) {
            result.setColor(j.getInt(JSON_COLOR_ARGB));
        }
        if (j.has(JSON_VISIBILITY)) {
            result.setVisibility(j.getInt(JSON_VISIBILITY));
        }
        if (j.has(JSON_SOUND)) {
            result.setSound(Uri.parse((String)j.getString(JSON_SOUND)));
        }
        if (j.has(JSON_VIBRATE)) {
            JSONArray patternJson = j.getJSONArray(JSON_VIBRATE);
            long[] pattern = new long[patternJson.length()];
            for (int i = 0; i < patternJson.length(); ++i) {
                pattern[i] = patternJson.getLong(i);
            }
            result.setVibrate(pattern);
        }
        if (j.has(JSON_ONLY_ALERT_ONCE)) {
            result.setOnlyAlertOnce(j.getBoolean(JSON_ONLY_ALERT_ONCE));
        }
        if (j.has(JSON_NO_SOUND)) {
            result.setNoSound();
        }
        if (j.has(JSON_NO_VIBRATE)) {
            result.setNoVibrate();
        }
        return result;
    }
}

