/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.push.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.tune.ma.TuneManager;
import com.tune.ma.push.TuneGooglePlayServicesDelegate;
import com.tune.ma.push.model.TunePushMessage;
import com.tune.ma.push.service.TuneNotificationManagerDelegate;
import com.tune.ma.push.service.TunePushReceiver;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneSharedPrefsDelegate;
import com.tune.ma.utils.TuneStringUtils;
import java.util.Set;

public class TunePushService
extends IntentService {
    public TunePushService() {
        super("TunePushService");
    }

    protected void onHandleIntent(Intent intent) {
        TuneDebugLog.d("PushService received intent");
        this.handleIntent(intent);
        TunePushReceiver.completeWakefulIntent((Intent)intent);
    }

    private void handleIntent(Intent intent) {
        if (intent == null) {
            TuneDebugLog.w("PushService received null intent.");
            return;
        }
        Bundle extras = intent.getExtras();
        TuneSharedPrefsDelegate prefs = new TuneSharedPrefsDelegate(this.getApplicationContext(), "com.mobileapptracking");
        if (prefs.getBooleanFromSharedPreferences("disabled") || prefs.getBooleanFromSharedPreferences("permanently_disabled")) {
            TuneDebugLog.d("Not creating push message because IAM is disabled");
            return;
        }
        if (extras.isEmpty()) {
            TuneDebugLog.w("The received intent did not have any extras, so there is nothing to process.");
            return;
        }
        try {
            Object gcm = TuneGooglePlayServicesDelegate.getGCMInstance((Context)this);
            String gcmMessageType = TuneGooglePlayServicesDelegate.getMessageType(gcm, intent);
            String messageType = TuneGooglePlayServicesDelegate.getGoogleCloudMessagingMessageTypeMessageField();
            if (gcmMessageType != null && gcmMessageType.equals(messageType)) {
                this.tryEchoPush(extras);
                this.buildAndSendMessage(extras);
            } else {
                TuneDebugLog.w(TuneStringUtils.format("Tune doesn't handle messageType \"%s\" expected \"%s\"", gcmMessageType, messageType));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildAndSendMessage(Bundle extras) {
        String appName = this.getApplicationInfo().loadLabel(this.getPackageManager()).toString();
        try {
            TunePushMessage message = new TunePushMessage(extras, appName);
            TuneDebugLog.i("Tune pushing notification w/ msg: " + message.getAlertMessage());
            TuneNotificationManagerDelegate notificationManager = new TuneNotificationManagerDelegate((Context)this);
            notificationManager.postPushNotification(message);
        }
        catch (Exception e) {
            TuneDebugLog.e("Failed to build push message: " + e);
        }
    }

    private void tryEchoPush(Bundle extras) {
        try {
            if (TuneManager.getInstance() != null && TuneManager.getInstance().getConfigurationManager().echoPushes()) {
                Set keys = extras.keySet();
                StringBuilder result = new StringBuilder();
                result.append("Received push message:\n");
                for (String key : keys) {
                    Object value = extras.get(key);
                    result.append(TuneStringUtils.format("  \"%s\" => %s\n", key, value instanceof String ? TuneStringUtils.format("\"%s\"", value) : value));
                }
                TuneDebugLog.alwaysLog(result.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

