/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.push.service;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.tune.ma.push.model.TunePushMessage;
import com.tune.ma.push.settings.TuneNotificationBuilder;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneSharedPrefsDelegate;
import org.json.JSONException;

public class TuneNotificationManagerDelegate {
    public static final int DEFAULT_ICON = 17301611;
    private NotificationManager notificationManager;
    private Context context;
    private TuneSharedPrefsDelegate sharedPrefs;

    public TuneNotificationManagerDelegate(Context context) {
        this.context = context;
        this.sharedPrefs = new TuneSharedPrefsDelegate(context, "com.tune.ma.push");
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
    }

    public void postPushNotification(TunePushMessage message) {
        NotificationCompat.Builder builder;
        String messageJson = message.toJson();
        PendingIntent tapIntent = this.buildTapIntentForMessage(message, messageJson);
        int iconId = this.context.getApplicationInfo().icon;
        if (iconId == 0) {
            iconId = 17301611;
        }
        boolean autoCancel = message.isAutoCancelNotification();
        TuneNotificationBuilder ourBuilder = null;
        if (this.sharedPrefs.contains("notificationBuilder")) {
            try {
                ourBuilder = TuneNotificationBuilder.fromJson(this.sharedPrefs.getStringFromSharedPreferences("notificationBuilder"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (ourBuilder != null) {
            builder = ourBuilder.build(this.context);
        } else {
            builder = new NotificationCompat.Builder(this.context.getApplicationContext());
            builder.setSmallIcon(iconId);
        }
        builder.setTicker((CharSequence)message.getTicker());
        builder.setContentTitle((CharSequence)message.getTitle());
        builder.setContentText((CharSequence)message.getAlertMessage());
        builder.setContentIntent(tapIntent);
        this.setNotificationBuilderStyle(builder, message);
        Notification notification = builder.build();
        if (autoCancel) {
            notification.flags |= 0x10;
        }
        notification.flags |= 1;
        notification.defaults |= 4;
        if (ourBuilder != null) {
            if (!ourBuilder.isSoundSet() && !ourBuilder.isNoSoundSet()) {
                notification.defaults |= 1;
            }
            if (!ourBuilder.isVibrateSet() && !ourBuilder.isNoVibrateSet()) {
                notification.defaults |= 2;
            }
        } else {
            notification.defaults |= 1;
            notification.defaults |= 2;
        }
        TuneDebugLog.d("Posting push notification now");
        this.notificationManager.notify(message.getTunePushIdAsInt(), notification);
    }

    private PendingIntent buildTapIntentForMessage(TunePushMessage message, String messageJson) {
        Intent intent;
        if (message.isOpenActionDeepLink()) {
            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)message.getPayload().getOnOpenAction().getDeepLinkURL()));
        } else {
            String packageName = this.context.getPackageName();
            intent = this.context.getPackageManager().getLaunchIntentForPackage(packageName);
            intent.addFlags(0x10000000);
        }
        intent.putExtra("com.tune.ma.EXTRA_MESSAGE", messageJson);
        return PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)0x10000000);
    }

    private void setNotificationBuilderStyle(NotificationCompat.Builder builder, TunePushMessage message) {
        String style = message.getStyle();
        if (!TextUtils.isEmpty((CharSequence)style)) {
            switch (style) {
                case "image": {
                    this.setPictureStyle(builder, message);
                    break;
                }
                case "big_text": {
                    this.setTextStyle(builder, message);
                    break;
                }
            }
        }
    }

    private void setPictureStyle(NotificationCompat.Builder builder, TunePushMessage message) {
        if (message.getImage() == null) {
            return;
        }
        NotificationCompat.BigPictureStyle style = new NotificationCompat.BigPictureStyle();
        style.setBigContentTitle((CharSequence)message.getTitle());
        style.setSummaryText((CharSequence)message.getAlertMessage());
        style.bigPicture(message.getImage());
        if (!TextUtils.isEmpty((CharSequence)message.getExpandedTitle())) {
            style.setBigContentTitle((CharSequence)message.getExpandedTitle());
        }
        if (!TextUtils.isEmpty((CharSequence)message.getSummary())) {
            style.setSummaryText((CharSequence)message.getSummary());
        }
        builder.setStyle((NotificationCompat.Style)style);
    }

    private void setTextStyle(NotificationCompat.Builder builder, TunePushMessage message) {
        NotificationCompat.BigTextStyle style = new NotificationCompat.BigTextStyle();
        style.setBigContentTitle((CharSequence)message.getTitle());
        style.setSummaryText((CharSequence)message.getAlertMessage());
        style.bigText((CharSequence)message.getExpandedText());
        if (!TextUtils.isEmpty((CharSequence)message.getExpandedTitle())) {
            style.setBigContentTitle((CharSequence)message.getExpandedTitle());
        }
        if (!TextUtils.isEmpty((CharSequence)message.getSummary())) {
            style.setSummaryText((CharSequence)message.getSummary());
        }
        builder.setStyle((NotificationCompat.Style)style);
    }
}

