/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.push.model;

import com.tune.ma.push.model.TunePushOpenAction;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class TunePushPayload {
    private static final String JSON_OPEN_ACTION = "ANA";
    private TunePushOpenAction onOpenAction;
    private JSONObject userExtraPayloadParams;

    public TunePushPayload(String json) throws JSONException {
        JSONObject object = new JSONObject(json);
        if (object.has(JSON_OPEN_ACTION)) {
            this.onOpenAction = new TunePushOpenAction(object.getJSONObject(JSON_OPEN_ACTION));
            object.remove(JSON_OPEN_ACTION);
        }
        this.userExtraPayloadParams = object;
    }

    public TunePushOpenAction getOnOpenAction() {
        return this.onOpenAction;
    }

    public JSONObject getUserExtraPayloadParams() {
        return this.userExtraPayloadParams;
    }

    public boolean isOpenActionDeepAction() {
        return this.getOnOpenAction() != null && this.getOnOpenAction().getDeepActionId() != null;
    }

    public boolean isOpenActionDeepLink() {
        return this.getOnOpenAction() != null && this.getOnOpenAction().getDeepLinkURL() != null;
    }

    public boolean isNeitherDeepActionOrDeepLink() {
        return this.getOnOpenAction() == null || this.getOnOpenAction().isNeitherPowerHookNorDeepLink();
    }

    public String toString() {
        return this.toJson().toString();
    }

    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        try {
            if (this.onOpenAction != null) {
                object.put(JSON_OPEN_ACTION, (Object)this.onOpenAction.toJson());
            }
            Iterator userParams = this.userExtraPayloadParams.keys();
            while (userParams.hasNext()) {
                String keyName = (String)userParams.next();
                object.put(keyName, this.userExtraPayloadParams.get(keyName));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }
}

