/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.push.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class TunePushOpenAction {
    private static final String JSON_AUTO_CANCEL = "D";
    private static final String JSON_CAMPAIGN_STEP_ID = "CS";
    private static final String JSON_DEEP_LINK = "URL";
    private static final String JSON_DEEP_ACTION_ID = "DA";
    private static final String JSON_DEEP_ACTION_PARAMS = "DAD";
    private String autoCancelFlag;
    private String campaignStepId;
    private String deepActionId;
    private Map<String, String> deepActionParameters;
    private String deepLinkURL;

    public TunePushOpenAction(JSONObject object) throws JSONException {
        if (object.has(JSON_AUTO_CANCEL)) {
            this.autoCancelFlag = object.getString(JSON_AUTO_CANCEL);
        }
        if (object.has(JSON_CAMPAIGN_STEP_ID)) {
            this.campaignStepId = object.getString(JSON_CAMPAIGN_STEP_ID);
        }
        boolean hasDeepLink = object.has(JSON_DEEP_LINK);
        boolean hasDeepAction = object.has(JSON_DEEP_ACTION_ID);
        if (hasDeepLink && hasDeepAction) {
            throw new JSONException("Push action was not formatted correctly: " + object.toString());
        }
        if (hasDeepLink) {
            this.deepLinkURL = object.getString(JSON_DEEP_LINK);
        } else if (hasDeepAction) {
            this.deepActionId = object.getString(JSON_DEEP_ACTION_ID);
            if (object.has(JSON_DEEP_ACTION_PARAMS)) {
                this.deepActionParameters = new HashMap<String, String>();
                JSONObject p = object.getJSONObject(JSON_DEEP_ACTION_PARAMS);
                Iterator keys = p.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.deepActionParameters.put(key, p.getString(key));
                }
            }
        }
    }

    public String getDeepActionId() {
        return this.deepActionId;
    }

    public Map<String, String> getDeepActionParameters() {
        return this.deepActionParameters;
    }

    public String getDeepLinkURL() {
        return this.deepLinkURL;
    }

    public boolean isAutoCancelNotification() {
        return this.autoCancelFlag == null || "1".equals(this.autoCancelFlag);
    }

    public boolean isNeitherPowerHookNorDeepLink() {
        return this.deepActionId == null && this.deepLinkURL == null;
    }

    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        try {
            object.put(JSON_AUTO_CANCEL, (Object)this.autoCancelFlag);
            object.put(JSON_CAMPAIGN_STEP_ID, (Object)this.campaignStepId);
            object.put(JSON_DEEP_ACTION_ID, (Object)this.deepActionId);
            if (this.deepActionParameters != null && this.deepActionParameters.size() > 0) {
                JSONObject deepActionParams = new JSONObject();
                for (Map.Entry<String, String> e : this.deepActionParameters.entrySet()) {
                    deepActionParams.put(e.getKey(), (Object)e.getValue());
                }
                object.put(JSON_DEEP_ACTION_PARAMS, (Object)deepActionParams);
            }
            object.put(JSON_DEEP_LINK, (Object)this.deepLinkURL);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }
}

