/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.push.model;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import com.tune.ma.campaign.model.TuneCampaign;
import com.tune.ma.push.model.TunePushPayload;
import com.tune.ma.utils.TuneStringUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class TunePushMessage {
    public static final String TUNE_EXTRA_MESSAGE = "com.tune.ma.EXTRA_MESSAGE";
    private static final String BUNDLE_APP_ID = "app_id";
    private static final String BUNDLE_ALERT_KEY = "alert";
    private static final String BUNDLE_PAYLOAD_KEY = "payload";
    private static final String BUNDLE_PUSH_ID_KEY = "ARTPID";
    private static final String BUNDLE_CAMPAIGN_ID = "CAMPAIGN_ID";
    private static final String BUNDLE_LENGTH_TO_REPORT = "LENGTH_TO_REPORT";
    private static final String JSON_APP_NAME = "appName";
    private static final String JSON_MESSAGE_ID = "local_message_id";
    private static final String TUNE_TEST_MESSAGE = "TEST_MESSAGE";
    private static final String BUNDLE_STYLE = "style";
    private static final String BUNDLE_IMAGE = "image";
    private static final String BUNDLE_BIG_TEXT = "big_text";
    private static final String BUNDLE_TITLE = "title";
    private static final String BUNDLE_SUMMARY = "summary";
    private String appId;
    private String alertMessage;
    private TunePushPayload payload;
    private String appName;
    private TuneCampaign campaign;
    private String messageIdentifier;
    private String style;
    private Bitmap image;
    private String title;
    private String summary;
    private String bigText;

    public TunePushMessage(String jsonString) throws JSONException {
        JSONObject json = new JSONObject(jsonString);
        this.appName = json.getString(JSON_APP_NAME);
        this.appId = json.getString(BUNDLE_APP_ID);
        this.alertMessage = json.getString(BUNDLE_ALERT_KEY);
        String campaignId = json.getString(BUNDLE_CAMPAIGN_ID);
        String variationId = json.getString(BUNDLE_PUSH_ID_KEY);
        Integer secondsToReport = json.getInt(BUNDLE_LENGTH_TO_REPORT);
        this.campaign = new TuneCampaign(campaignId, variationId, secondsToReport);
        if (json.has(BUNDLE_PAYLOAD_KEY)) {
            this.payload = new TunePushPayload(json.getString(BUNDLE_PAYLOAD_KEY));
        }
        this.messageIdentifier = json.getString(JSON_MESSAGE_ID);
    }

    public TunePushMessage(Bundle extras, String appName) throws Exception {
        this.appName = appName;
        this.appId = this.checkGet(extras, BUNDLE_APP_ID);
        this.alertMessage = this.checkGet(extras, BUNDLE_ALERT_KEY);
        String pushId = this.checkGet(extras, BUNDLE_PUSH_ID_KEY);
        String campaignId = this.checkGet(extras, BUNDLE_CAMPAIGN_ID);
        Integer secondsToReport = Integer.parseInt(this.checkGet(extras, BUNDLE_LENGTH_TO_REPORT));
        this.campaign = new TuneCampaign(campaignId, pushId, secondsToReport);
        if (extras.containsKey(BUNDLE_PAYLOAD_KEY) && extras.getString(BUNDLE_PAYLOAD_KEY) != null) {
            this.payload = new TunePushPayload(extras.getString(BUNDLE_PAYLOAD_KEY));
        }
        this.messageIdentifier = UUID.randomUUID().toString();
        if (extras.containsKey(BUNDLE_STYLE)) {
            this.style = extras.getString(BUNDLE_STYLE);
            if (this.style.equals("regular")) {
                return;
            }
            if (this.style.equals(BUNDLE_IMAGE)) {
                try {
                    this.image = BitmapFactory.decodeStream((InputStream)((InputStream)new URL(this.checkGet(extras, BUNDLE_IMAGE)).getContent()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.style.equals(BUNDLE_BIG_TEXT)) {
                this.bigText = this.checkGet(extras, BUNDLE_BIG_TEXT);
            }
            this.title = extras.getString(BUNDLE_TITLE);
            this.summary = extras.getString(BUNDLE_SUMMARY);
        }
    }

    private String checkGet(Bundle extras, String toGet) throws Exception {
        String result = extras.getString(toGet);
        if (result == null) {
            throw new Exception(TuneStringUtils.format("Push messages should have an '%s' field.", toGet));
        }
        return result;
    }

    public boolean isOpenActionDeepAction() {
        return this.getPayload() != null && this.getPayload().isOpenActionDeepAction();
    }

    public boolean isOpenActionDeepLink() {
        return this.getPayload() != null && this.getPayload().isOpenActionDeepLink();
    }

    public boolean isAutoCancelNotification() {
        boolean autoCancel = true;
        if (this.payload != null && this.payload.getOnOpenAction() != null) {
            autoCancel = this.payload.getOnOpenAction().isAutoCancelNotification();
        }
        return autoCancel;
    }

    public boolean isTestMessage() {
        if (this.campaign == null || this.campaign.getVariationId() == null) {
            return false;
        }
        return this.campaign.getVariationId().equals(TUNE_TEST_MESSAGE);
    }

    public String getAlertMessage() {
        return this.alertMessage;
    }

    public TunePushPayload getPayload() {
        return this.payload;
    }

    public TuneCampaign getCampaign() {
        return this.campaign;
    }

    public String getTicker() {
        return this.alertMessage;
    }

    public String getTitle() {
        return this.appName;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getTunePushIdAsInt() {
        int messageIdInt = 0;
        if (this.campaign.getVariationId() != null) {
            messageIdInt = this.campaign.getVariationId().hashCode();
        }
        return messageIdInt;
    }

    public String getMessageIdentifier() {
        return this.messageIdentifier;
    }

    public String getStyle() {
        return this.style;
    }

    public Bitmap getImage() {
        return this.image;
    }

    public String getExpandedTitle() {
        return this.title;
    }

    public String getExpandedText() {
        return this.bigText;
    }

    public String getSummary() {
        return this.summary;
    }

    public String toJson() {
        JSONObject object = new JSONObject();
        try {
            object.put(JSON_APP_NAME, (Object)this.appName);
            object.put(BUNDLE_APP_ID, (Object)this.appId);
            object.put(BUNDLE_ALERT_KEY, (Object)this.alertMessage);
            object.put(BUNDLE_PUSH_ID_KEY, (Object)this.campaign.getVariationId());
            object.put(BUNDLE_CAMPAIGN_ID, (Object)this.campaign.getCampaignId());
            object.put(BUNDLE_LENGTH_TO_REPORT, (Object)this.campaign.getNumberOfSecondsToReportAnalytics());
            if (this.payload != null) {
                object.put(BUNDLE_PAYLOAD_KEY, (Object)this.payload.toJson().toString());
            }
            object.put(JSON_MESSAGE_ID, (Object)this.messageIdentifier);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object.toString();
    }
}

