/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.push;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import com.tune.TuneUtils;
import com.tune.ma.TuneManager;
import com.tune.ma.analytics.model.TuneAnalyticsVariable;
import com.tune.ma.analytics.model.TuneVariableType;
import com.tune.ma.eventbus.TuneEventBus;
import com.tune.ma.eventbus.event.TuneAppBackgrounded;
import com.tune.ma.eventbus.event.TuneAppForegrounded;
import com.tune.ma.eventbus.event.push.TunePushEnabled;
import com.tune.ma.eventbus.event.userprofile.TuneUpdateUserProfile;
import com.tune.ma.push.TuneGooglePlayServicesDelegate;
import com.tune.ma.push.TunePushInfo;
import com.tune.ma.push.model.TunePushMessage;
import com.tune.ma.push.settings.TuneNotificationBuilder;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneOptional;
import com.tune.ma.utils.TuneSharedPrefsDelegate;
import com.tune.ma.utils.TuneStringUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

public class TunePushManager {
    public static final String PREFS_TMA_PUSH = "com.tune.ma.push";
    public static final String PROPERTY_NOTIFICATION_BUILDER = "notificationBuilder";
    private static final String PROPERTY_REG_ID = "registrationId";
    private static final String PROPERTY_APP_VERSION = "appVersion";
    private static final String PROPERTY_GCM_SENDER = "gcmSenderId";
    static final String PROPERTY_DEVELOPER_PUSH_ENABLED = "developerPushEnabledPreference";
    static final String PROPERTY_END_USER_PUSH_ENABLED = "userPushEnabledPreference";
    static final String PROPERTY_IS_COPPA = "isCoppa";
    private Context context;
    TuneSharedPrefsDelegate sharedPrefs;
    protected String currentAppVersion;
    private Object gcm;
    private ExecutorService executorService;
    private String pushSenderId;
    private Set<String> processedMessages;
    private TunePushMessage lastOpenedPushMessage;

    public TunePushManager(Context context) {
        this(context, TuneManager.getInstance().getProfileManager().getProfileVariableValue("appBuild"));
    }

    public TunePushManager(Context context, String currentAppVersion) {
        this.context = context;
        this.sharedPrefs = new TuneSharedPrefsDelegate(context, PREFS_TMA_PUSH);
        this.currentAppVersion = currentAppVersion;
        this.sharedPrefs.remove(PROPERTY_NOTIFICATION_BUILDER);
        this.executorService = Executors.newSingleThreadExecutor();
        this.processedMessages = new HashSet<String>();
    }

    public void onEvent(TuneAppForegrounded event) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    TunePushManager.this.checkUserPushDisabledSetting();
                }
            });
        }
    }

    public synchronized void onEvent(TuneAppBackgrounded event) {
        this.lastOpenedPushMessage = null;
    }

    public void onEvent(TuneUpdateUserProfile event) {
        TuneAnalyticsVariable var = event.getVariable();
        if ("age".equals(var.getName())) {
            int age = Integer.parseInt(var.getValue());
            if (age < 13) {
                this.updatePushEnabled(PROPERTY_IS_COPPA, true);
            } else {
                this.updatePushEnabled(PROPERTY_IS_COPPA, false);
            }
        }
    }

    private boolean checkUserPushDisabledSetting() {
        try {
            int notificationStatusCode = TuneGooglePlayServicesDelegate.isNotificationEnabled(this.context);
            int statusAllowed = TuneGooglePlayServicesDelegate.getAppOpsManagerModeAllowed();
            if (notificationStatusCode == statusAllowed) {
                this.updatePushEnabled(PROPERTY_END_USER_PUSH_ENABLED, true);
                return false;
            }
            this.updatePushEnabled(PROPERTY_END_USER_PUSH_ENABLED, false);
            return true;
        }
        catch (Exception e) {
            TuneDebugLog.w("Failed to check push status", e);
            return false;
        }
    }

    public boolean ensureDeviceIsRegistered() {
        boolean isNewGCMSender;
        String storedRegistrationId = this.sharedPrefs.getStringFromSharedPreferences(PROPERTY_REG_ID);
        boolean registeredAlready = false;
        boolean isNewAppVersion = !this.isAppVersionSameForStoredRegistrationId();
        boolean bl = isNewGCMSender = !this.isGCMSenderSameForStoredRegistrationId();
        if (storedRegistrationId != null && storedRegistrationId.isEmpty() || isNewAppVersion || isNewGCMSender) {
            TuneDebugLog.d("Need to register device");
            TuneEventBus.post(new TuneUpdateUserProfile(TuneAnalyticsVariable.Builder("deviceToken").withType(TuneVariableType.STRING).build()));
            this.storePushPrefs(null);
            boolean unregisterFirst = !storedRegistrationId.isEmpty() && isNewGCMSender;
            this.registerInBackground(unregisterFirst);
        } else {
            registeredAlready = true;
            this.setDeviceToken(storedRegistrationId);
        }
        return registeredAlready;
    }

    protected boolean isGooglePlayServicesAvailable() {
        boolean playServicesInstalled = false;
        try {
            int resultCode = TuneGooglePlayServicesDelegate.isGooglePlayServicesAvailable(this.context);
            int connectionResultSuccess = TuneGooglePlayServicesDelegate.getConnectionResultSuccessField();
            if (resultCode == connectionResultSuccess) {
                playServicesInstalled = true;
                TuneDebugLog.i("Play Services are enabled");
            } else if (TuneGooglePlayServicesDelegate.isUserRecoverable(resultCode)) {
                TuneDebugLog.e("User needs to install Google Play Services.");
            } else {
                TuneDebugLog.e("This device does not support Push Notifications.");
            }
        }
        catch (Exception e) {
            TuneDebugLog.w("Failed to check if google play services is available: ", e);
        }
        return playServicesInstalled;
    }

    private boolean isAppVersionSameForStoredRegistrationId() {
        String registeredAppVersion = this.sharedPrefs.getStringFromSharedPreferences(PROPERTY_APP_VERSION);
        if (registeredAppVersion == null) {
            return this.currentAppVersion == null;
        }
        return registeredAppVersion.equals(this.currentAppVersion);
    }

    private boolean isGCMSenderSameForStoredRegistrationId() {
        String registeredGCMSender = this.sharedPrefs.getStringFromSharedPreferences(PROPERTY_GCM_SENDER);
        if (registeredGCMSender == null) {
            return this.pushSenderId == null;
        }
        return registeredGCMSender.equals(this.pushSenderId);
    }

    protected void registerInBackground(final boolean unregisterFirst) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                String msg = "";
                try {
                    if (TunePushManager.this.gcm == null) {
                        TunePushManager.this.gcm = TuneGooglePlayServicesDelegate.getGCMInstance(TunePushManager.this.context);
                    }
                    if (unregisterFirst) {
                        TuneGooglePlayServicesDelegate.unregisterGCM(TunePushManager.this.gcm);
                        msg = "Successfully unregistered device. Re-registering now... ";
                    }
                    if (TunePushManager.this.pushSenderId != null) {
                        String registrationId = TuneGooglePlayServicesDelegate.registerGCM(TunePushManager.this.gcm, TunePushManager.this.pushSenderId);
                        msg = msg + "Successful registration: " + registrationId;
                        TunePushManager.this.setDeviceToken(registrationId);
                    }
                }
                catch (Exception ex) {
                    msg = msg + "Error: " + ex;
                }
                TuneDebugLog.w(msg);
            }
        });
    }

    protected void setDeviceToken(String deviceToken) {
        TuneDebugLog.alwaysLog("Tune Push Device Registration Id: " + deviceToken);
        this.storePushPrefs(deviceToken);
        TuneEventBus.post(new TuneUpdateUserProfile(TuneAnalyticsVariable.Builder("deviceToken").withValue(deviceToken).build()));
        String pushEnabledStatus = "NO";
        if (this.isPushEnabled()) {
            pushEnabledStatus = "YES";
        }
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("pushEnabled", pushEnabledStatus)));
    }

    protected void storePushPrefs(String regId) {
        this.sharedPrefs.saveToSharedPreferences(PROPERTY_REG_ID, regId);
        this.sharedPrefs.saveToSharedPreferences(PROPERTY_APP_VERSION, this.currentAppVersion);
        this.sharedPrefs.saveToSharedPreferences(PROPERTY_GCM_SENDER, this.pushSenderId);
    }

    public synchronized TuneOptional<TunePushMessage> checkGetPushFromActivity(Activity activity) {
        TunePushMessage message;
        Intent intent = activity.getIntent();
        if (intent == null) {
            return TuneOptional.empty();
        }
        Bundle extras = intent.getExtras();
        if (extras == null || !extras.containsKey("com.tune.ma.EXTRA_MESSAGE")) {
            return TuneOptional.empty();
        }
        try {
            message = new TunePushMessage(extras.getString("com.tune.ma.EXTRA_MESSAGE"));
        }
        catch (JSONException e) {
            TuneDebugLog.e("Error building push message in activity: ", e);
            return TuneOptional.empty();
        }
        if (!TuneManager.getInstance().getProfileManager().getAppId().equals(message.getAppId())) {
            return TuneOptional.empty();
        }
        if (this.processedMessages.contains(message.getMessageIdentifier())) {
            return TuneOptional.empty();
        }
        this.processedMessages.add(message.getMessageIdentifier());
        this.lastOpenedPushMessage = message;
        return TuneOptional.of(message);
    }

    public boolean isPushEnabled() {
        boolean endUserPushEnabled = this.sharedPrefs.getBooleanFromSharedPreferences(PROPERTY_END_USER_PUSH_ENABLED, true);
        boolean developerPushEnabled = this.sharedPrefs.getBooleanFromSharedPreferences(PROPERTY_DEVELOPER_PUSH_ENABLED, true);
        boolean tooYoungForPush = this.sharedPrefs.getBooleanFromSharedPreferences(PROPERTY_IS_COPPA, false);
        if (tooYoungForPush) {
            return false;
        }
        return endUserPushEnabled && developerPushEnabled;
    }

    private boolean isPushStatusDetermined() {
        return this.sharedPrefs.contains(PROPERTY_DEVELOPER_PUSH_ENABLED) || this.sharedPrefs.contains(PROPERTY_END_USER_PUSH_ENABLED) || this.sharedPrefs.contains(PROPERTY_IS_COPPA);
    }

    synchronized void updatePushEnabled(String key, boolean newKeyValue) {
        boolean keyExisted = this.sharedPrefs.contains(key);
        boolean oldKeyValue = this.sharedPrefs.getBooleanFromSharedPreferences(key);
        boolean pushPreviouslyDetermined = this.isPushStatusDetermined();
        boolean oldPushEnabled = this.isPushEnabled();
        this.sharedPrefs.saveBooleanToSharedPreferences(key, newKeyValue);
        if (!keyExisted || oldKeyValue != newKeyValue) {
            boolean newPushEnabled = this.isPushEnabled();
            String varValue = newPushEnabled ? "YES" : "NO";
            TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("pushEnabled", varValue)));
            if (!pushPreviouslyDetermined || oldPushEnabled != newPushEnabled) {
                TuneEventBus.post(new TunePushEnabled(newPushEnabled));
            }
        }
    }

    public void setPushNotificationSenderId(String pushSenderId) {
        if (pushSenderId == null) {
            TuneDebugLog.IAMConfigError("The push sender can not be null in 'setPushNotificationSenderId'");
        }
        if (TuneManager.getInstance().getProfileManager().getProfileVariableValue("pushEnabled") == null) {
            TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("pushEnabled", "NO")));
        }
        this.pushSenderId = pushSenderId;
        this.ensureDeviceIsRegistered();
    }

    public void setPushNotificationRegistrationId(String registrationId) {
        if (registrationId == null) {
            TuneDebugLog.IAMConfigError("The device token can not be null in 'setPushNotificationRegistrationId'");
        }
        this.setDeviceToken(registrationId);
    }

    public void setTuneNotificationBuilder(TuneNotificationBuilder toStore) {
        try {
            this.sharedPrefs.saveToSharedPreferences(PROPERTY_NOTIFICATION_BUILDER, toStore.toJson().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setOptedOutOfPush(boolean optedOut) {
        this.updatePushEnabled(PROPERTY_DEVELOPER_PUSH_ENABLED, !optedOut);
    }

    public String getDeviceToken() {
        return this.sharedPrefs.getStringFromSharedPreferences(PROPERTY_REG_ID, null);
    }

    public synchronized boolean didOpenFromTunePushThisSession() {
        return this.lastOpenedPushMessage != null;
    }

    public synchronized TunePushInfo getLastOpenedPushInfo() {
        if (this.lastOpenedPushMessage == null) {
            return null;
        }
        TunePushInfo info = new TunePushInfo();
        info.setCampaignId(this.lastOpenedPushMessage.getCampaign().getCampaignId());
        info.setPushId(this.lastOpenedPushMessage.getCampaign().getVariationId());
        info.setExtrasPayload(this.lastOpenedPushMessage.getPayload().getUserExtraPayloadParams());
        return info;
    }

    public boolean didUserManuallyDisablePush() {
        if (Build.VERSION.SDK_INT >= 19) {
            return this.checkUserPushDisabledSetting();
        }
        return false;
    }

    private void checkPushSettings(String methodName) {
        this.checkPushPermissionsHelper("com.google.android.c2dm.permission.RECEIVE", methodName);
        this.checkPushPermissionsHelper("android.permission.WAKE_LOCK", methodName);
        this.checkPushPermissionsHelper(this.context.getPackageName() + ".permission.C2D_MESSAGE", methodName);
        try {
            Object object = TuneGooglePlayServicesDelegate.getGCMInstance(this.context);
        }
        catch (Exception e) {
            TuneDebugLog.IAMConfigError("Could not find com.google.android.gms.gcm.GoogleCloudMessaging, make sure you are building with it.");
        }
    }

    private void checkPushPermissionsHelper(String permission2, String methodName) {
        if (!TuneUtils.hasPermission(this.context, permission2)) {
            TuneDebugLog.IAMConfigError(TuneStringUtils.format("You need the '%s' permission in your manifest to use push and '%s'", permission2, methodName));
        }
    }
}

