/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.profile;

import android.content.Context;
import com.tune.TuneUtils;
import com.tune.ma.analytics.model.TuneAnalyticsVariable;
import com.tune.ma.analytics.model.TuneVariableType;
import com.tune.ma.eventbus.TuneEventBus;
import com.tune.ma.eventbus.event.TuneAppBackgrounded;
import com.tune.ma.eventbus.event.TuneAppForegrounded;
import com.tune.ma.eventbus.event.TuneSessionVariableToSet;
import com.tune.ma.eventbus.event.userprofile.TuneCustomProfileVariablesCleared;
import com.tune.ma.eventbus.event.userprofile.TuneUpdateUserProfile;
import com.tune.ma.profile.SystemInfo;
import com.tune.ma.profile.TuneProfileKeys;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneSharedPrefsDelegate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneUserProfile {
    public static final String PREFS_TMA_PROFILE = "com.tune.ma.profile";
    public static final String PREFS_CUSTOM_VARIABLES_KEY = "custom_variables";
    private Context context;
    TuneSharedPrefsDelegate sharedPrefs;
    private HashMap<String, TuneAnalyticsVariable> variables;
    private Set<String> customVariables;
    private Set<TuneAnalyticsVariable> sessionVariables;
    private static final Set<String> variablesToSave = new HashSet<String>(Arrays.asList("user_id", "is_paying_user", "mat_id", "open_log_id", "user_email_md5", "user_email_sha1", "user_email_sha256", "user_name_md5", "user_name_sha1", "user_name_sha256", "user_phone_md5", "user_phone_sha1", "user_phone_sha256", "session_id", "is_first_session", "last_session_date", "session_count", "current_session_date", "deviceToken", "pushEnabled"));

    public TuneUserProfile(Context context) {
        this.context = context;
        this.sharedPrefs = new TuneSharedPrefsDelegate(context, PREFS_TMA_PROFILE);
        this.variables = new HashMap();
        this.customVariables = new HashSet<String>();
        this.sessionVariables = new HashSet<TuneAnalyticsVariable>();
        for (String v : variablesToSave) {
            TuneAnalyticsVariable p = this.getProfileVariableFromPrefs(v);
            if (p == null) continue;
            this.storeProfileVariable(p, false);
        }
        this.storeProfileVariable(new TuneAnalyticsVariable("sdk_version", "4.9.0", TuneVariableType.VERSION));
        Integer minutesFromGMT = TimeZone.getDefault().getRawOffset() / 1000 / 60;
        this.storeProfileVariable(new TuneAnalyticsVariable("minutesFromGMT", minutesFromGMT));
        this.storeProfileVariable(new TuneAnalyticsVariable("os_type", "android"));
        SystemInfo sysInfo = new SystemInfo(context);
        this.storeProfileVariable(new TuneAnalyticsVariable("hardwareType", sysInfo.getModel()));
        this.storeProfileVariable(new TuneAnalyticsVariable("appBuild", sysInfo.getAppBuild()));
        this.storeProfileVariable(new TuneAnalyticsVariable("apiLevel", sysInfo.getApiLevel()));
        this.storeProfileVariable(new TuneAnalyticsVariable("interfaceIdiom", sysInfo.getTabletOrPhone()));
    }

    public String getAppId() {
        String advertiserId = this.getProfileVariableValue("advertiser_id");
        String packageName = this.getProfileVariableValue("package_name");
        if (advertiserId == null) {
            advertiserId = this.sharedPrefs.getStringFromSharedPreferences("advertiser_id");
        }
        if (packageName == null) {
            packageName = this.sharedPrefs.getStringFromSharedPreferences("package_name");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(advertiserId);
        sb.append("|");
        sb.append(packageName);
        sb.append("|");
        sb.append("android");
        return TuneUtils.md5(sb.toString());
    }

    public String getDeviceId() {
        String GAID = this.getProfileVariableValue("google_aid");
        String fireAid = this.getProfileVariableValue("fire_aid");
        String androidId = this.getProfileVariableValue("android_id");
        if (GAID != null) {
            return GAID;
        }
        if (fireAid != null) {
            return fireAid;
        }
        if (androidId != null) {
            return androidId;
        }
        return this.getProfileVariableValue("mat_id");
    }

    public String getSessionId() {
        return this.getProfileVariableValue("session_id");
    }

    public Set<TuneAnalyticsVariable> getSessionVariables() {
        return this.sessionVariables;
    }

    public void deleteSharedPrefs() {
        this.sharedPrefs.clearSharedPreferences();
    }

    public synchronized void onEvent(TuneAppForegrounded event) {
        TuneAnalyticsVariable storedIsFirstSession = this.getProfileVariableFromPrefs("is_first_session");
        TuneAnalyticsVariable.TuneAnalyticsVariableBuilder isFirstSession = TuneAnalyticsVariable.Builder("is_first_session");
        if (storedIsFirstSession == null) {
            this.storeProfileVariable(isFirstSession.withValue(true).build());
        } else if (storedIsFirstSession.getValue().equalsIgnoreCase("1")) {
            this.storeProfileVariable(isFirstSession.withValue(false).build());
        }
        TuneAnalyticsVariable.TuneAnalyticsVariableBuilder sessionCount = TuneAnalyticsVariable.Builder("session_count");
        if (this.getProfileVariableFromPrefs("session_count") == null) {
            sessionCount.withValue(1);
        } else {
            int count = Integer.parseInt(this.getProfileVariableFromPrefs("session_count").getValue());
            sessionCount.withValue(count + 1);
        }
        TuneAnalyticsVariable.TuneAnalyticsVariableBuilder lastSession = TuneAnalyticsVariable.Builder("last_session_date");
        if (this.getProfileVariableFromPrefs("last_session_date") == null) {
            lastSession.withType(TuneVariableType.DATETIME);
        } else {
            Date previousSession = TuneAnalyticsVariable.stringToDate(this.getProfileVariableFromPrefs("current_session_date").getValue());
            lastSession.withValue(previousSession);
        }
        this.storeProfileVariable(new TuneAnalyticsVariable("session_id", event.getSessionId()));
        this.storeProfileVariable(sessionCount.build());
        this.storeProfileVariable(lastSession.build());
        this.storeProfileVariable(new TuneAnalyticsVariable("current_session_date", new Date(event.getSessionStartTime())));
        try {
            String customVariablesJsonStr = this.sharedPrefs.getStringFromSharedPreferences(PREFS_CUSTOM_VARIABLES_KEY, "[]");
            JSONArray customVariablesJson = new JSONArray(customVariablesJsonStr);
            for (int i = 0; i < customVariablesJson.length(); ++i) {
                this.customVariables.add(customVariablesJson.getString(i));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        for (String variableName : this.customVariables) {
            TuneAnalyticsVariable storedVar = this.getProfileVariableFromPrefs(variableName);
            this.storeProfileVariable(storedVar, false);
        }
    }

    public synchronized void onEvent(TuneAppBackgrounded event) {
        JSONArray customVariablesJson = new JSONArray(this.customVariables);
        this.sharedPrefs.saveToSharedPreferences(PREFS_CUSTOM_VARIABLES_KEY, customVariablesJson.toString());
    }

    public void onEvent(TuneUpdateUserProfile event) {
        TuneAnalyticsVariable var = event.getVariable();
        this.storeProfileVariable(var);
    }

    public synchronized void onEvent(TuneSessionVariableToSet event) {
        String variableName = event.getVariableName();
        String variableValue = event.getVariableValue();
        if (event.saveToProfile()) {
            this.sessionVariables.add(new TuneAnalyticsVariable(variableName, variableValue));
        }
    }

    public synchronized TuneAnalyticsVariable getProfileVariable(String key) {
        return this.variables.get(key);
    }

    public String getProfileVariableValue(String key) {
        TuneAnalyticsVariable result = this.getProfileVariable(key);
        if (result != null) {
            return result.getValue();
        }
        return null;
    }

    public synchronized TuneAnalyticsVariable getProfileVariableFromPrefs(String key) {
        String json = this.sharedPrefs.getStringFromSharedPreferences(key, null);
        if (json == null) {
            return null;
        }
        return TuneAnalyticsVariable.fromJson(json);
    }

    private void storeProfileVariable(TuneAnalyticsVariable value) {
        this.storeProfileVariable(value, true);
    }

    private synchronized void storeProfileVariable(TuneAnalyticsVariable value, boolean updatePrefs) {
        String name = value.getName();
        this.variables.put(name, value);
        if (updatePrefs && (variablesToSave.contains(name) || this.customVariables.contains(name))) {
            this.sharedPrefs.saveToSharedPreferences(name, value.toJsonForLocalStorage().toString());
        }
    }

    public synchronized JSONArray toJson() {
        JSONArray result = new JSONArray();
        for (TuneAnalyticsVariable var : this.variables.values()) {
            List<JSONObject> variableJsonList = var.toListOfJsonObjectsForDispatch();
            for (JSONObject variableJson : variableJsonList) {
                if (variableJson == null) continue;
                result.put((Object)variableJson);
            }
        }
        for (TuneAnalyticsVariable sessionVariable : this.sessionVariables) {
            List<JSONObject> objects = sessionVariable.toListOfJsonObjectsForDispatch();
            for (JSONObject object : objects) {
                result.put((Object)object);
            }
        }
        return result;
    }

    public synchronized List<TuneAnalyticsVariable> getCopyOfVars() {
        LinkedList<TuneAnalyticsVariable> result = new LinkedList<TuneAnalyticsVariable>();
        for (TuneAnalyticsVariable var : this.variables.values()) {
            result.add(new TuneAnalyticsVariable(var));
        }
        for (TuneAnalyticsVariable sessionVariable : this.sessionVariables) {
            result.add(sessionVariable);
        }
        return result;
    }

    public synchronized void registerCustomProfileVariable(TuneAnalyticsVariable var) {
        if (TuneAnalyticsVariable.validateName(var.getName())) {
            String prettyName = TuneAnalyticsVariable.cleanVariableName(var.getName());
            if (TuneProfileKeys.systemVariables.contains(prettyName)) {
                TuneDebugLog.IAMConfigError("The variable '" + prettyName + "' is a system variable, and cannot be set in this manner. Please use another name.");
                return;
            }
            if (prettyName.startsWith("TUNE_")) {
                TuneDebugLog.IAMConfigError("Profile variables starting with 'TUNE_' are reserved. Not registering: " + prettyName);
                return;
            }
            this.customVariables.add(prettyName);
            TuneAnalyticsVariable storedVar = this.getProfileVariableFromPrefs(prettyName);
            if (storedVar != null && storedVar.getType() == var.getType()) {
                if (storedVar.didHaveValueManuallySet()) {
                    this.storeProfileVariable(TuneAnalyticsVariable.Builder(prettyName).withValue(storedVar.getValue()).withType(storedVar.getType()).withValueManuallySet(true).build());
                } else {
                    this.storeProfileVariable(TuneAnalyticsVariable.Builder(prettyName).withValue(var.getValue()).withType(storedVar.getType()).build());
                }
            } else {
                this.storeProfileVariable(TuneAnalyticsVariable.Builder(prettyName).withValue(var.getValue()).withType(var.getType()).build());
            }
        }
    }

    public synchronized void setCustomProfileVariable(TuneAnalyticsVariable var) {
        if (TuneAnalyticsVariable.validateName(var.getName())) {
            String prettyName = TuneAnalyticsVariable.cleanVariableName(var.getName());
            if (this.customVariables.contains(prettyName)) {
                TuneAnalyticsVariable storedVar = this.getProfileVariableFromPrefs(prettyName);
                if (storedVar == null || storedVar.getType() == var.getType()) {
                    this.storeProfileVariable(TuneAnalyticsVariable.Builder(prettyName).withValue(var.getValue()).withType(var.getType()).withValueManuallySet(true).build());
                } else {
                    TuneDebugLog.IAMConfigError("Attempting to set the variable '" + prettyName + "', registered as a " + (Object)((Object)storedVar.getType()) + ", with the " + (Object)((Object)var.getType()) + " setter. Please use the appropriate setter.");
                }
            } else {
                TuneDebugLog.IAMConfigError("In order to set a value for '" + prettyName + "' it must be registered first.");
            }
        }
    }

    public synchronized TuneAnalyticsVariable getCustomProfileVariable(String name) {
        TuneAnalyticsVariable result = null;
        if (TuneAnalyticsVariable.validateName(name)) {
            String prettyName = TuneAnalyticsVariable.cleanVariableName(name);
            if (this.customVariables.contains(prettyName)) {
                result = this.getProfileVariable(prettyName);
            } else {
                TuneDebugLog.IAMConfigError("In order to get a value for '" + prettyName + "' it must be registered first.");
            }
        }
        return result;
    }

    public void clearCertainCustomProfileVariable(String key) {
        List<String> clearedVariables = this.clearCustomProfileVariables(Arrays.asList(key));
        if (clearedVariables.size() > 0) {
            TuneEventBus.post(new TuneCustomProfileVariablesCleared(clearedVariables));
        }
    }

    public void clearAllCustomProfileVariables() {
        List<String> clearedVariables = this.clearCustomProfileVariables(this.customVariables);
        if (clearedVariables.size() > 0) {
            TuneEventBus.post(new TuneCustomProfileVariablesCleared(clearedVariables));
        }
    }

    private synchronized List<String> clearCustomProfileVariables(Iterable<String> toRemove) {
        LinkedList<String> clearedVariables = new LinkedList<String>();
        for (String key : toRemove) {
            String prettyName;
            if (!TuneAnalyticsVariable.validateName(key) || !this.customVariables.contains(prettyName = TuneAnalyticsVariable.cleanVariableName(key))) continue;
            this.variables.remove(prettyName);
            this.sharedPrefs.remove(prettyName);
            clearedVariables.add(prettyName);
        }
        return clearedVariables;
    }
}

