/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.profile;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import java.util.Calendar;

public class SystemInfo {
    private final String device = Build.DEVICE;
    private final String model = Build.MODEL;
    private final int apiLevel = Build.VERSION.SDK_INT;
    private int appBuild;
    private final String tabletOrPhone;
    private static final String TABLET = "tablet";
    private static final String PHONE = "phone";
    private String packageName;

    public String tabletOrPhone() {
        return this.tabletOrPhone;
    }

    public SystemInfo(Context context) {
        this.tabletOrPhone = SystemInfo.isTablet(context) ? TABLET : PHONE;
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pInfo = pm.getPackageInfo(context.getPackageName(), 128);
            this.packageName = context.getPackageName();
            this.appBuild = pInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    protected int calculateMinutesFromGMTForCalendar(Calendar calendar) {
        return (calendar.get(15) + calendar.get(16)) / 60000;
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public String getDevice() {
        return this.device;
    }

    public String getModel() {
        return this.model;
    }

    public String getApiLevel() {
        return "" + this.apiLevel;
    }

    public String getTabletOrPhone() {
        return this.tabletOrPhone;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getAppBuild() {
        return Integer.toString(this.appBuild);
    }
}

