/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.powerhooks;

import com.tune.ma.model.TuneCallback;
import com.tune.ma.playlist.model.TunePlaylist;
import com.tune.ma.powerhooks.model.TunePowerHookValue;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneJsonUtils;
import com.tune.ma.utils.TuneStringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class TunePowerHookManager {
    private Map<String, TunePowerHookValue> phookHash = new HashMap<String, TunePowerHookValue>();
    private TuneCallback callback = null;
    private ExecutorService executorService;
    private Set<String> userRegisteredPowerHooks = new HashSet<String>();

    public TunePowerHookManager() {
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void updatePowerHooksFromPlaylist(TunePlaylist playlist) {
        boolean notifyPowerHooksChanged = false;
        JSONObject phookJson = playlist.getPowerHooks();
        if (phookJson == null) {
            return;
        }
        Iterator phookIds = phookJson.keys();
        while (phookIds.hasNext()) {
            String hookId = (String)phookIds.next();
            if (!this.mergeInPlaylistPowerHook(hookId, TuneJsonUtils.getJSONObject(phookJson, hookId))) continue;
            notifyPowerHooksChanged = true;
        }
        if (!playlist.isFromDisk() && notifyPowerHooksChanged) {
            this.executeOnPowerHooksChangedBlocks();
        }
    }

    private boolean mergeInPlaylistPowerHook(String hookId, JSONObject json) {
        boolean notifyChange = false;
        TunePowerHookValue existingPhook = this.getPowerHookValue(hookId);
        TunePowerHookValue newPhook = null;
        if (existingPhook != null) {
            try {
                newPhook = existingPhook.clone();
                newPhook.mergeWithPlaylistJson(json);
                this.phookHash.put(hookId, newPhook);
                if (!newPhook.getValue().equals(existingPhook.getValue())) {
                    notifyChange = true;
                }
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                TuneDebugLog.e("Failed to clone existingPhook: " + existingPhook.getHookId());
            }
        } else {
            newPhook = new TunePowerHookValue();
            newPhook.setHookId(hookId);
            newPhook.mergeWithPlaylistJson(json);
            this.phookHash.put(hookId, newPhook);
            notifyChange = false;
        }
        return notifyChange;
    }

    private void executeOnPowerHooksChangedBlocks() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (TunePowerHookManager.this.callback != null) {
                    TunePowerHookManager.this.callback.execute();
                }
            }
        });
    }

    public synchronized void registerPowerHook(String hookId, String friendlyName, String defaultValue, String description, List<String> approvedValues) {
        if (hookId == null || friendlyName == null || defaultValue == null) {
            TuneDebugLog.IAMConfigError("TUNE Power Hook IDs, friendly names and default values cannot be null. This registration (hookId:" + hookId + ", friendlyName:" + friendlyName + ", defaultValue: " + defaultValue + ") will be ignored.");
            return;
        }
        String scrubbedHookId = TuneStringUtils.scrubStringForMongo(hookId);
        if (this.userRegisteredPowerHooks.contains(scrubbedHookId)) {
            TuneDebugLog.IAMConfigError("Invalid attempt to overwrite a previously registered Power Hook for hook ID \"" + hookId + "\".");
        } else {
            this.userRegisteredPowerHooks.add(scrubbedHookId);
            TunePowerHookValue existingPowerHook = this.getPowerHookValue(hookId);
            if (existingPowerHook != null) {
                existingPowerHook.setFriendlyName(friendlyName);
                existingPowerHook.setDefaultValue(defaultValue);
                existingPowerHook.setDescription(description);
                existingPowerHook.setApprovedValues(approvedValues);
            } else {
                this.phookHash.put(scrubbedHookId, new TunePowerHookValue(scrubbedHookId, friendlyName, defaultValue, description, approvedValues));
            }
        }
    }

    public synchronized String getValueForHookById(String hookId) {
        String scrubbedHookId = TuneStringUtils.scrubStringForMongo(hookId);
        TunePowerHookValue phookValue = this.phookHash.get(scrubbedHookId);
        if (phookValue == null) {
            TuneDebugLog.IAMConfigError("No Power Hook was registered with the given Hook ID: " + hookId);
            return null;
        }
        return phookValue.getValue();
    }

    public synchronized void setValueForHookById(String hookId, String value) {
        TunePowerHookValue phookValue = this.getPowerHookValue(hookId);
        if (phookValue == null) {
            TuneDebugLog.IAMConfigError("No Power Hook was registered with the given Hook ID: " + hookId);
        } else {
            phookValue.setValue(value);
        }
    }

    public synchronized void onPowerHooksChanged(TuneCallback callback) {
        this.callback = callback;
    }

    public synchronized List<TunePowerHookValue> getPowerHookValues() {
        ArrayList<TunePowerHookValue> values = new ArrayList<TunePowerHookValue>();
        for (Map.Entry<String, TunePowerHookValue> entry : this.phookHash.entrySet()) {
            values.add(entry.getValue());
        }
        return values;
    }

    private TunePowerHookValue getPowerHookValue(String hookId) {
        String scrubbedHookId = TuneStringUtils.scrubStringForMongo(hookId);
        TunePowerHookValue phookValue = this.phookHash.get(scrubbedHookId);
        return phookValue;
    }

    protected Map<String, TunePowerHookValue> getPowerHooks() {
        return new HashMap<String, TunePowerHookValue>(this.phookHash);
    }

    protected void clearPowerHooks() {
        this.phookHash = new HashMap<String, TunePowerHookValue>();
    }

    void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

