/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.playlist.model;

import com.tune.ma.utils.TuneJsonUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class TunePlaylist {
    public static final String SCHEMA_VERSION_KEY = "schema_version";
    public static final String POWER_HOOKS_KEY = "power_hooks";
    public static final String IN_APP_MESSAGES_KEY = "messages";
    public static final String EXPERIMENT_DETAILS_KEY = "experiment_details";
    public static final String SEGMENTS_KEY = "segments";
    private String schemaVersion;
    private JSONObject powerHooks;
    private JSONObject inAppMessages;
    private JSONObject experimentDetails;
    private JSONObject segments;
    private boolean fromDisk;
    private boolean fromConnectedMode;

    public TunePlaylist(JSONObject playlistJson) {
        this.schemaVersion = TuneJsonUtils.getString(playlistJson, SCHEMA_VERSION_KEY);
        this.experimentDetails = TuneJsonUtils.getJSONObject(playlistJson, EXPERIMENT_DETAILS_KEY);
        this.powerHooks = TuneJsonUtils.getJSONObject(playlistJson, POWER_HOOKS_KEY);
        this.inAppMessages = TuneJsonUtils.getJSONObject(playlistJson, IN_APP_MESSAGES_KEY);
        this.segments = TuneJsonUtils.getJSONObject(playlistJson, SEGMENTS_KEY);
    }

    public TunePlaylist() {
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public JSONObject getPowerHooks() {
        return this.powerHooks;
    }

    public void setPowerHooks(JSONObject powerHooks) {
        this.powerHooks = powerHooks;
    }

    public JSONObject getInAppMessages() {
        return this.inAppMessages;
    }

    public void setInAppMessages(JSONObject inAppMessages) {
        this.inAppMessages = inAppMessages;
    }

    public JSONObject getExperimentDetails() {
        return this.experimentDetails;
    }

    public void setExperimentDetails(JSONObject experimentDetails) {
        this.experimentDetails = experimentDetails;
    }

    public JSONObject getSegments() {
        return this.segments;
    }

    public void setSegments(JSONObject segments) {
        this.segments = segments;
    }

    public boolean isFromDisk() {
        return this.fromDisk;
    }

    public void setFromDisk(boolean fromDisk) {
        this.fromDisk = fromDisk;
    }

    public boolean isFromConnectedMode() {
        return this.fromConnectedMode;
    }

    public void setFromConnectedMode(boolean fromConnectedMode) {
        this.fromConnectedMode = fromConnectedMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TunePlaylist)) {
            return false;
        }
        TunePlaylist that = (TunePlaylist)o;
        if (this.schemaVersion != null ? !this.schemaVersion.equals(that.schemaVersion) : that.schemaVersion != null) {
            return false;
        }
        if (this.powerHooks != null && that.powerHooks != null ? !this.powerHooks.toString().equals(that.powerHooks.toString()) : this.powerHooks != that.powerHooks) {
            return false;
        }
        if (this.inAppMessages != null && that.inAppMessages != null ? !this.inAppMessages.toString().equals(that.inAppMessages.toString()) : this.inAppMessages != that.inAppMessages) {
            return false;
        }
        if (this.segments != null && that.segments != null ? !this.segments.toString().equals(that.segments.toString()) : this.segments != that.segments) {
            return false;
        }
        return !(this.experimentDetails == null || that.experimentDetails == null ? this.experimentDetails != that.experimentDetails : !this.experimentDetails.toString().equals(that.experimentDetails.toString()));
    }

    public int hashCode() {
        int result = this.schemaVersion != null ? this.schemaVersion.hashCode() : 0;
        result = 31 * result + (this.powerHooks != null ? this.powerHooks.toString().hashCode() : 0);
        result = 31 * result + (this.inAppMessages != null ? this.inAppMessages.toString().hashCode() : 0);
        result = 31 * result + (this.experimentDetails != null ? this.experimentDetails.toString().hashCode() : 0);
        result = 31 * result * (this.segments != null ? this.segments.toString().hashCode() : 0);
        return result;
    }

    public JSONObject toJson() {
        JSONObject playlistJson = new JSONObject();
        try {
            playlistJson.put(SCHEMA_VERSION_KEY, (Object)this.schemaVersion);
            playlistJson.put(EXPERIMENT_DETAILS_KEY, (Object)this.experimentDetails);
            playlistJson.put(POWER_HOOKS_KEY, (Object)this.powerHooks);
            playlistJson.put(IN_APP_MESSAGES_KEY, (Object)this.inAppMessages);
            playlistJson.put(SEGMENTS_KEY, (Object)this.segments);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return playlistJson;
    }
}

