/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.playlist;

import android.text.TextUtils;
import android.util.Log;
import com.tune.ma.TuneManager;
import com.tune.ma.configuration.TuneConfigurationManager;
import com.tune.ma.eventbus.TuneEventBus;
import com.tune.ma.eventbus.event.TuneAppBackgrounded;
import com.tune.ma.eventbus.event.TuneAppForegrounded;
import com.tune.ma.eventbus.event.TunePlaylistManagerCurrentPlaylistChanged;
import com.tune.ma.model.TuneCallback;
import com.tune.ma.model.TuneCallbackHolder;
import com.tune.ma.playlist.model.TunePlaylist;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneJsonUtils;
import com.tune.ma.utils.TuneStringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TunePlaylistManager {
    private TuneCallbackHolder onFirstPlaylistDownloadCallbackHolder;
    private boolean firstPlaylistCallbackExecuted;
    private TunePlaylist currentPlaylist;
    private boolean started = false;
    private boolean isUpdating = false;
    private boolean receivedFirstPlaylistDownload = false;
    private ScheduledThreadPoolExecutor scheduler;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static final String TAG = "PlaylistManager";

    public TunePlaylistManager() {
        this.loadPlaylistFromDisk();
    }

    public synchronized void onEvent(TuneAppForegrounded event) {
        if (TuneManager.getInstance() == null || TuneManager.getInstance().getConfigurationManager().isTMADisabled()) {
            return;
        }
        if (this.onFirstPlaylistDownloadCallbackHolder != null && this.onFirstPlaylistDownloadCallbackHolder.isCanceled()) {
            if (this.receivedFirstPlaylistDownload) {
                this.onFirstPlaylistDownloadCallbackHolder.executeBlock();
            } else {
                long timeout = this.onFirstPlaylistDownloadCallbackHolder.getTimeout();
                if (timeout > 0L) {
                    this.onFirstPlaylistDownloadCallbackHolder.setTimeout(timeout);
                }
            }
        }
        if (TuneManager.getInstance().getConfigurationManager().getPollForPlaylist() && !this.started) {
            this.startPlaylistRetriever();
            this.started = true;
        } else {
            this.executorService.execute(new PlaylistRetrievalTask());
        }
    }

    public synchronized void onEvent(TuneAppBackgrounded event) {
        if (this.started) {
            this.stopPlaylistRetriever();
            this.started = false;
        }
        if (this.onFirstPlaylistDownloadCallbackHolder != null) {
            this.onFirstPlaylistDownloadCallbackHolder.stopTimer();
        }
    }

    private void startPlaylistRetriever() {
        TuneDebugLog.i(TAG, "Starting PlaylistRetriever Schedule.");
        this.scheduler = new ScheduledThreadPoolExecutor(1);
        this.scheduler.scheduleAtFixedRate(new PlaylistRetrievalTask(), 0L, TuneManager.getInstance().getConfigurationManager().getPlaylistRequestPeriod(), TimeUnit.SECONDS);
    }

    private void stopPlaylistRetriever() {
        if (this.scheduler != null) {
            TuneDebugLog.i(TAG, "Stopping PlaylistRetriever Schedule.");
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
    }

    private boolean loadPlaylistFromDisk() {
        JSONObject playlistFromDisk = null;
        playlistFromDisk = TuneManager.getInstance().getConfigurationManager().usePlaylistPlayer() ? TuneManager.getInstance().getPlaylistPlayer().getNext() : TuneManager.getInstance().getFileManager().readPlaylist();
        if (playlistFromDisk != null) {
            TunePlaylist playlist = new TunePlaylist(playlistFromDisk);
            playlist.setFromDisk(true);
            this.setCurrentPlaylist(playlist);
            return true;
        }
        return false;
    }

    public synchronized boolean isUserInSegmentId(String segmentId) {
        if (TextUtils.isEmpty((CharSequence)segmentId)) {
            return false;
        }
        JSONObject segments = this.currentPlaylist.getSegments();
        if (segments == null) {
            return false;
        }
        JSONArray segmentIds = segments.names();
        if (segmentIds == null) {
            return false;
        }
        for (int i = 0; i < segmentIds.length(); ++i) {
            if (!segmentIds.optString(i).equals(segmentId)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isUserInAnySegmentIds(List<String> segmentIdsToCheck) {
        if (segmentIdsToCheck == null) {
            return false;
        }
        JSONObject segments = this.currentPlaylist.getSegments();
        if (segments == null) {
            return false;
        }
        JSONArray segmentIds = segments.names();
        if (segmentIds == null) {
            return false;
        }
        ArrayList<String> segmentIdsList = new ArrayList<String>();
        for (int i = 0; i < segmentIds.length(); ++i) {
            segmentIdsList.add(segmentIds.optString(i));
        }
        return !Collections.disjoint(segmentIdsList, segmentIdsToCheck);
    }

    public synchronized void forceSetUserInSegmentId(String segmentId, boolean isInSegment) {
        if (this.currentPlaylist.getSegments() == null) {
            this.currentPlaylist.setSegments(new JSONObject());
        }
        try {
            if (isInSegment) {
                this.currentPlaylist.getSegments().put(segmentId, (Object)"Set by forceSetUserInSegmentId");
            } else {
                this.currentPlaylist.getSegments().remove(segmentId);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public synchronized void getConnectedPlaylist() {
        if (TuneManager.getInstance().getConfigurationManager().getPollForPlaylist() && this.started) {
            this.stopPlaylistRetriever();
            this.started = false;
        }
        this.executorService.execute(new PlaylistRetrievalTask());
    }

    public TunePlaylist getCurrentPlaylist() {
        return this.currentPlaylist;
    }

    protected synchronized void setCurrentPlaylist(TunePlaylist newPlaylist) {
        if (TuneManager.getInstance() == null || TuneManager.getInstance().getConfigurationManager().isTMADisabled()) {
            newPlaylist = new TunePlaylist();
        }
        if (this.currentPlaylist == null || !this.currentPlaylist.equals(newPlaylist)) {
            this.currentPlaylist = newPlaylist;
            if (TuneManager.getInstance() != null && !newPlaylist.isFromDisk() && !newPlaylist.isFromConnectedMode()) {
                TuneDebugLog.i("Saving New Playlist to Disk");
                TuneManager.getInstance().getFileManager().writePlaylist(this.currentPlaylist.toJson());
            }
            if (TuneManager.getInstance() != null) {
                TuneManager.getInstance().getPowerHookManager().updatePowerHooksFromPlaylist(this.currentPlaylist);
            }
            TuneEventBus.post(new TunePlaylistManagerCurrentPlaylistChanged(newPlaylist));
        }
        if (!newPlaylist.isFromDisk()) {
            this.checkTriggerOnFirstPlaylistDownloadedCallback();
        }
    }

    public synchronized void onFirstPlaylistDownloaded(final TuneCallback callback, long timeout) {
        if (callback == null) {
            TuneDebugLog.IAMConfigError("You passed a null TuneCallback for the onFirstPlaylistDownloaded callback.");
            return;
        }
        if (this.onFirstPlaylistDownloadCallbackHolder != null) {
            this.onFirstPlaylistDownloadCallbackHolder.stopTimer();
        }
        this.setFirstPlaylistCallbackExecuted(false);
        if (TuneManager.getInstance() == null || TuneManager.getInstance().getConfigurationManager().isTMADisabled()) {
            TuneDebugLog.i("TMA is Disabled, executing firstPlaylistDownload callback");
            this.setFirstPlaylistCallbackExecuted(true);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    callback.execute();
                }
            });
        } else if (this.receivedFirstPlaylistDownload) {
            TuneDebugLog.i("Playlist already downloaded upon callback registration, executing firstPlaylistDownload callback");
            this.setFirstPlaylistCallbackExecuted(true);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    callback.execute();
                }
            });
        } else {
            this.onFirstPlaylistDownloadCallbackHolder = new TuneCallbackHolder(callback);
            if (timeout > 0L) {
                TuneDebugLog.i("Playlist not downloaded, executing firstPlaylistDownload callback after timeout " + timeout);
                this.onFirstPlaylistDownloadCallbackHolder.setTimeout(timeout);
            }
        }
    }

    public boolean hasFirstPlaylistCallbackExecuted() {
        return this.firstPlaylistCallbackExecuted;
    }

    public void setFirstPlaylistCallbackExecuted(boolean firstPlaylistCallbackExecuted) {
        this.firstPlaylistCallbackExecuted = firstPlaylistCallbackExecuted;
    }

    private synchronized void checkTriggerOnFirstPlaylistDownloadedCallback() {
        if (!this.receivedFirstPlaylistDownload) {
            this.receivedFirstPlaylistDownload = true;
            if (!this.firstPlaylistCallbackExecuted && this.onFirstPlaylistDownloadCallbackHolder != null) {
                TuneDebugLog.i("Playlist downloaded, executing firstPlaylistDownload callback");
                try {
                    this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            TunePlaylistManager.this.onFirstPlaylistDownloadCallbackHolder.executeBlock();
                        }
                    });
                }
                catch (Exception e) {
                    TuneDebugLog.e(TuneStringUtils.format("Exception in executing firstPlaylistDownload callback. %s", Log.getStackTraceString((Throwable)e)));
                }
            }
        }
    }

    private class PlaylistRetrievalTask
    implements Runnable {
        private PlaylistRetrievalTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TuneManager.getInstance() == null || TuneManager.getInstance().getConfigurationManager().isTMADisabled()) {
                return;
            }
            TuneDebugLog.i("Retrieving Playlist from Server");
            if (TunePlaylistManager.this.isUpdating) {
                return;
            }
            TunePlaylistManager.this.isUpdating = true;
            try {
                TuneConfigurationManager configurationManager = TuneManager.getInstance().getConfigurationManager();
                boolean fromConnectedMode = false;
                JSONObject response = null;
                if (configurationManager.usePlaylistPlayer()) {
                    response = TuneManager.getInstance().getPlaylistPlayer().getNext();
                } else if (TuneManager.getInstance().getConnectedModeManager().isInConnectedMode()) {
                    response = TuneManager.getInstance().getApi().getConnectedPlaylist();
                    fromConnectedMode = true;
                } else {
                    response = TuneManager.getInstance().getApi().getPlaylist();
                }
                TunePlaylist newPlaylist = null;
                if (response == null) {
                    TuneDebugLog.w("Playlist response did not have any JSON");
                    TunePlaylistManager.this.checkTriggerOnFirstPlaylistDownloadedCallback();
                } else if (response.length() == 0) {
                    TuneDebugLog.w("Received empty playlist from the server -- not updating");
                    TunePlaylistManager.this.checkTriggerOnFirstPlaylistDownloadedCallback();
                } else {
                    if (configurationManager.echoPlaylists()) {
                        TuneDebugLog.alwaysLog("Got Playlist:\n" + TuneJsonUtils.getPrettyJson(response));
                    }
                    newPlaylist = new TunePlaylist(response);
                    newPlaylist.setFromConnectedMode(fromConnectedMode);
                }
                if (newPlaylist != null) {
                    TunePlaylistManager.this.setCurrentPlaylist(newPlaylist);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                TuneDebugLog.e(TunePlaylistManager.TAG, "Failed to download new playlist.");
            }
            finally {
                TunePlaylistManager.this.isUpdating = false;
            }
        }
    }
}

