/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.model;

import com.tune.ma.TuneManager;
import com.tune.ma.model.TuneCallback;
import com.tune.ma.playlist.TunePlaylistManager;
import com.tune.ma.session.TuneSessionManager;
import java.util.Timer;
import java.util.TimerTask;

public class TuneCallbackHolder {
    private TuneCallback callback;
    private long timeInMillis;
    private Timer timer;
    private Object lock;
    private boolean timerActive;
    private boolean canceled;

    public TuneCallbackHolder(TuneCallback callback) {
        this.callback = callback;
        this.lock = new Object();
        this.timerActive = false;
        this.canceled = false;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public long getTimeout() {
        return this.timeInMillis;
    }

    public void setTimeout(long timeInMillis) {
        this.timeInMillis = timeInMillis;
        this.timer = new Timer(true);
        this.timerActive = true;
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TuneCallbackHolder.this.lock;
                synchronized (object) {
                    TuneCallbackHolder.this.timerActive = false;
                }
                TuneCallbackHolder.this.execute();
            }
        }, this.timeInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.timer != null) {
                if (this.timerActive) {
                    this.timerActive = false;
                    this.timer.cancel();
                    this.canceled = true;
                }
                this.timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBlock() {
        Object object = this.lock;
        synchronized (object) {
            if (this.timer != null) {
                if (this.timerActive) {
                    this.timerActive = false;
                    this.timer.cancel();
                }
                this.timer = null;
            }
            this.execute();
        }
    }

    private void execute() {
        if (this.callback != null && TuneManager.getInstance() != null) {
            TunePlaylistManager playlistManager = TuneManager.getInstance().getPlaylistManager();
            TuneSessionManager sessionManager = TuneManager.getInstance().getSessionManager();
            if (playlistManager != null && !playlistManager.hasFirstPlaylistCallbackExecuted()) {
                if (sessionManager != null && sessionManager.hasActivityVisible()) {
                    playlistManager.setFirstPlaylistCallbackExecuted(true);
                    this.callback.execute();
                } else {
                    this.canceled = true;
                }
            }
        }
    }
}

