/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.file;

import android.content.Context;
import com.tune.ma.analytics.model.event.TuneAnalyticsEventBase;
import com.tune.ma.file.FileManager;
import com.tune.ma.utils.TuneFileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneFileManager
implements FileManager {
    private Context context;
    private static final String ANALYTICS_FILE_NAME = "tune_analytics.txt";
    private static final String CONFIGURATION_FILE_NAME = "tune_configuration.json";
    private static final String PLAYLIST_FILE_NAME = "tune_playlist.json";
    private static final Object ANALYTICS_LOCK = new Object();
    private static final Object CONFIGURATION_LOCK = new Object();
    private static final Object PLAYLIST_LOCK = new Object();
    private static final String TAG = "FileManager";

    public TuneFileManager(Context context) {
        this.context = context;
    }

    @Override
    public void writeConfiguration(JSONObject configuration) {
        TuneFileUtils.writeFile(configuration.toString(), CONFIGURATION_FILE_NAME, CONFIGURATION_LOCK, this.context);
    }

    @Override
    public JSONObject readConfiguration() {
        return TuneFileUtils.readJsonFile(CONFIGURATION_FILE_NAME, CONFIGURATION_LOCK, this.context);
    }

    @Override
    public void deleteConfiguration() {
        TuneFileUtils.deleteFile(CONFIGURATION_FILE_NAME, CONFIGURATION_LOCK, this.context);
    }

    @Override
    public JSONObject readPlaylist() {
        return TuneFileUtils.readJsonFile(PLAYLIST_FILE_NAME, PLAYLIST_LOCK, this.context);
    }

    @Override
    public void writePlaylist(JSONObject playlist) {
        TuneFileUtils.writeFile(playlist.toString(), PLAYLIST_FILE_NAME, PLAYLIST_LOCK, this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAnalytics(TuneAnalyticsEventBase event) {
        Object object = ANALYTICS_LOCK;
        synchronized (object) {
            FileOutputStream outputStream = null;
            try {
                outputStream = this.context.openFileOutput(ANALYTICS_FILE_NAME, 32768);
                outputStream.write(event.toJson().toString().getBytes());
                outputStream.write("\n".getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONArray readAnalytics() {
        Object object = ANALYTICS_LOCK;
        synchronized (object) {
            JSONArray analyticsArray = new JSONArray();
            File analyticsFile = new File(this.context.getFilesDir(), ANALYTICS_FILE_NAME);
            if (analyticsFile.exists()) {
                FileInputStream fis = null;
                InputStreamReader isr = null;
                BufferedReader bufferedReader = null;
                try {
                    String line;
                    fis = new FileInputStream(analyticsFile);
                    isr = new InputStreamReader(fis);
                    bufferedReader = new BufferedReader(isr);
                    while ((line = bufferedReader.readLine()) != null) {
                        line = line.trim();
                        try {
                            JSONObject analyticsEvent = new JSONObject(line);
                            analyticsArray.put((Object)analyticsEvent);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            return analyticsArray;
        }
    }

    @Override
    public void deleteAnalytics() {
        TuneFileUtils.deleteFile(ANALYTICS_FILE_NAME, ANALYTICS_LOCK, this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAnalytics(int numEventsToDelete) {
        StringBuilder eventsToSave = new StringBuilder();
        Object object = ANALYTICS_LOCK;
        synchronized (object) {
            if (numEventsToDelete == 0) {
                return;
            }
            File analyticsFile = new File(this.context.getFilesDir(), ANALYTICS_FILE_NAME);
            if (!analyticsFile.exists()) {
                return;
            }
            int lineCount = 1;
            FileInputStream fis = null;
            InputStreamReader isr = null;
            BufferedReader bufferedReader = null;
            try {
                String line;
                fis = new FileInputStream(analyticsFile);
                isr = new InputStreamReader(fis);
                bufferedReader = new BufferedReader(isr);
                while ((line = bufferedReader.readLine()) != null) {
                    if (lineCount > numEventsToDelete) {
                        eventsToSave.append(line + "\n");
                    }
                    ++lineCount;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (eventsToSave.length() != 0) {
            TuneFileUtils.writeFile(eventsToSave.toString(), ANALYTICS_FILE_NAME, ANALYTICS_LOCK, this.context);
        } else {
            TuneFileUtils.deleteFile(ANALYTICS_FILE_NAME, ANALYTICS_LOCK, this.context);
        }
    }
}

