/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.experiments.model;

import com.tune.ma.experiments.model.TuneExperimentDetails;
import com.tune.ma.powerhooks.model.TunePowerHookValue;
import com.tune.ma.utils.TuneDateUtils;
import java.util.Date;
import org.json.JSONObject;

public class TunePowerHookExperimentDetails
extends TuneExperimentDetails {
    private Date experimentStartDate;
    private Date experimentEndDate;

    public TunePowerHookExperimentDetails(String experimentId, String experimentName, String experimentType, String currentVariantId, String currentVariantName, String currentVariantLetter, String hookId, Date experimentStartDate, Date experimentEndDate) {
        super(experimentId, experimentName, experimentType, currentVariantId, currentVariantName, currentVariantLetter);
        this.experimentStartDate = experimentStartDate;
        this.experimentEndDate = experimentEndDate;
    }

    public TunePowerHookExperimentDetails(JSONObject experimentDetails, TunePowerHookValue powerHookValue) {
        super(experimentDetails);
        this.experimentStartDate = powerHookValue.getStartDate();
        this.experimentEndDate = powerHookValue.getEndDate();
    }

    public boolean isRunning() {
        Date now = TuneDateUtils.getNowUTC();
        if (this.experimentEndDate == null || this.experimentStartDate == null) {
            return false;
        }
        return now.after(this.experimentStartDate) && now.before(this.experimentEndDate);
    }

    public Date getExperimentStartDate() {
        return this.experimentStartDate;
    }

    public Date getExperimentEndDate() {
        return this.experimentEndDate;
    }
}

