/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.experiments.model;

import com.tune.ma.utils.TuneJsonUtils;
import org.json.JSONObject;

public class TuneExperimentDetails {
    public static final String DETAIL_EXPERIMENT_NAME_KEY = "name";
    public static final String DETAIL_EXPERIMENT_ID_KEY = "id";
    public static final String DETAIL_EXPERIMENT_TYPE_KEY = "type";
    public static final String DETAIL_CURRENT_VARIATION_KEY = "current_variation";
    public static final String DETAIL_CURRENT_VARIATION_ID_KEY = "id";
    public static final String DETAIL_CURRENT_VARIATION_NAME_KEY = "name";
    public static final String DETAIL_CURRENT_VARIATION_LETTER_KEY = "letter";
    public static final String DETAIL_TYPE_POWER_HOOK = "power_hook";
    public static final String DETAIL_TYPE_IN_APP = "in_app";
    private String experimentId;
    private String experimentName;
    private String experimentType;
    private String currentVariantId;
    private String currentVariantName;
    private String currentVariantLetter;

    public TuneExperimentDetails(String experimentId, String experimentName, String experimentType, String currentVariantId, String currentVariantName, String currentVariantLetter) {
        this.experimentId = experimentId;
        this.experimentName = experimentName;
        this.experimentType = experimentType;
        this.currentVariantId = currentVariantId;
        this.currentVariantName = currentVariantName;
        this.currentVariantLetter = currentVariantLetter;
    }

    public TuneExperimentDetails(JSONObject experimentDetailsJson) {
        this.experimentId = TuneJsonUtils.getString(experimentDetailsJson, "id");
        this.experimentName = TuneJsonUtils.getString(experimentDetailsJson, "name");
        this.experimentType = TuneJsonUtils.getString(experimentDetailsJson, DETAIL_EXPERIMENT_TYPE_KEY);
        JSONObject currentVariationJson = TuneJsonUtils.getJSONObject(experimentDetailsJson, DETAIL_CURRENT_VARIATION_KEY);
        this.currentVariantId = TuneJsonUtils.getString(currentVariationJson, "id");
        this.currentVariantName = TuneJsonUtils.getString(currentVariationJson, "name");
        this.currentVariantLetter = TuneJsonUtils.getString(currentVariationJson, DETAIL_CURRENT_VARIATION_LETTER_KEY);
    }

    public String getExperimentId() {
        return this.experimentId;
    }

    public String getExperimentName() {
        return this.experimentName;
    }

    public String getExperimentType() {
        return this.experimentType;
    }

    public String getCurrentVariantId() {
        return this.currentVariantId;
    }

    public String getCurrentVariantName() {
        return this.currentVariantName;
    }

    public String getCurrentVariantLetter() {
        return this.currentVariantLetter;
    }
}

