/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.experiments;

import com.tune.ma.eventbus.TuneEventBus;
import com.tune.ma.eventbus.event.TunePlaylistManagerCurrentPlaylistChanged;
import com.tune.ma.eventbus.event.TuneSessionVariableToSet;
import com.tune.ma.experiments.model.TuneInAppMessageExperimentDetails;
import com.tune.ma.experiments.model.TunePowerHookExperimentDetails;
import com.tune.ma.playlist.model.TunePlaylist;
import com.tune.ma.powerhooks.model.TunePowerHookValue;
import com.tune.ma.utils.TuneJsonUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class TuneExperimentManager {
    public static final String TUNE_ACTIVE_VARIATION_ID = "TUNE_ACTIVE_VARIATION_ID";
    private Map<String, TunePowerHookExperimentDetails> phookExperimentDetails = new HashMap<String, TunePowerHookExperimentDetails>();
    private Map<String, TuneInAppMessageExperimentDetails> inAppExperimentDetails = new HashMap<String, TuneInAppMessageExperimentDetails>();
    private Set<String> addedActiveVariations = new HashSet<String>();

    public void onEvent(TunePlaylistManagerCurrentPlaylistChanged event) {
        TunePlaylist activePlaylist = event.getNewPlaylist();
        HashMap<String, TunePowerHookExperimentDetails> phookExperimentDetailsTemp = new HashMap<String, TunePowerHookExperimentDetails>();
        HashMap<String, TuneInAppMessageExperimentDetails> inAppMessageExperimentDetailsTemp = new HashMap<String, TuneInAppMessageExperimentDetails>();
        JSONObject experimentDetails = activePlaylist.getExperimentDetails();
        if (experimentDetails == null) {
            return;
        }
        Iterator experimentDetailsIter = experimentDetails.keys();
        block0: while (experimentDetailsIter.hasNext()) {
            String experimentId = (String)experimentDetailsIter.next();
            JSONObject experiment = TuneJsonUtils.getJSONObject(experimentDetails, experimentId);
            String type = TuneJsonUtils.getString(experiment, "type");
            if (type != null && type.equals("power_hook")) {
                JSONObject hooks = activePlaylist.getPowerHooks();
                Iterator hooksIter = hooks.keys();
                while (hooksIter.hasNext()) {
                    String hookId = (String)hooksIter.next();
                    TunePowerHookValue hookValue = new TunePowerHookValue();
                    hookValue.mergeWithPlaylistJson(TuneJsonUtils.getJSONObject(hooks, hookId));
                    if (!experimentId.equals(hookValue.getExperimentId())) continue;
                    TunePowerHookExperimentDetails details = new TunePowerHookExperimentDetails(experiment, hookValue);
                    phookExperimentDetailsTemp.put(hookId, details);
                    if (this.addedActiveVariations.contains(details.getCurrentVariantId())) continue block0;
                    this.addedActiveVariations.add(details.getCurrentVariantId());
                    TuneEventBus.post(new TuneSessionVariableToSet(TUNE_ACTIVE_VARIATION_ID, details.getCurrentVariantId(), TuneSessionVariableToSet.SaveTo.PROFILE));
                    continue block0;
                }
                continue;
            }
            if (type == null || !type.equals("in_app")) continue;
            TuneInAppMessageExperimentDetails details = new TuneInAppMessageExperimentDetails(experiment);
            inAppMessageExperimentDetailsTemp.put(TuneJsonUtils.getString(experiment, "name"), details);
        }
        this.setPhookExperimentDetails(new HashMap<String, TunePowerHookExperimentDetails>(phookExperimentDetailsTemp));
        this.setInAppExperimentDetails(new HashMap<String, TuneInAppMessageExperimentDetails>(inAppMessageExperimentDetailsTemp));
    }

    private synchronized void setPhookExperimentDetails(Map<String, TunePowerHookExperimentDetails> phookExperimentDetails) {
        this.phookExperimentDetails = phookExperimentDetails;
    }

    private synchronized void setInAppExperimentDetails(Map<String, TuneInAppMessageExperimentDetails> inAppExperimentDetails) {
        this.inAppExperimentDetails = inAppExperimentDetails;
    }

    public synchronized Map<String, TunePowerHookExperimentDetails> getPhookExperimentDetails() {
        return new HashMap<String, TunePowerHookExperimentDetails>(this.phookExperimentDetails);
    }

    public synchronized Map<String, TuneInAppMessageExperimentDetails> getInAppExperimentDetails() {
        return new HashMap<String, TuneInAppMessageExperimentDetails>(this.inAppExperimentDetails);
    }
}

