/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.eventbus;

import com.tune.BuildConfig;
import com.tune.ma.analytics.model.TuneAnalyticsVariable;
import com.tune.ma.eventbus.event.TuneGetAdvertisingIdCompleted;
import com.tune.ma.eventbus.event.TuneManagerInitialized;
import com.tune.ma.eventbus.event.userprofile.TuneUpdateUserProfile;
import com.tune.ma.utils.TuneDebugLog;
import de.greenrobot.event.EventBus;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TuneEventBus {
    public static final EventBus EVENT_BUS = EventBus.builder().throwSubscriberException(BuildConfig.DEBUG_MODE.booleanValue()).build();
    public static final int PRIORITY_FIRST = 100;
    public static final int PRIORITY_SECOND = 99;
    public static final int PRIORITY_THIRD = 98;
    public static final int PRIORITY_IRRELEVANT = 2;
    private static List<Object> eventQueue = new ArrayList<Object>();
    private static volatile boolean enabled = false;
    private static volatile boolean managerInitialized = false;
    private static volatile boolean getAdvertisingIdCompleted = false;

    public static synchronized void post(Object event) {
        if (!enabled) {
            return;
        }
        if (event instanceof TuneManagerInitialized) {
            managerInitialized = true;
            if (getAdvertisingIdCompleted) {
                TuneEventBus.dequeue();
            }
            return;
        }
        if (event instanceof TuneGetAdvertisingIdCompleted) {
            getAdvertisingIdCompleted = true;
            TuneGetAdvertisingIdCompleted advertisingIdEvent = (TuneGetAdvertisingIdCompleted)event;
            switch (advertisingIdEvent.getType()) {
                case ANDROID_ID: {
                    eventQueue.add(0, new TuneUpdateUserProfile(new TuneAnalyticsVariable("android_id", advertisingIdEvent.getDeviceId())));
                    break;
                }
                case FIRE_AID: {
                    eventQueue.add(0, new TuneUpdateUserProfile(new TuneAnalyticsVariable("fire_aid", advertisingIdEvent.getDeviceId())));
                    eventQueue.add(1, new TuneUpdateUserProfile(new TuneAnalyticsVariable("fire_ad_tracking_disabled", advertisingIdEvent.getLimitAdTrackingEnabled())));
                    break;
                }
                case GOOGLE_AID: {
                    eventQueue.add(0, new TuneUpdateUserProfile(new TuneAnalyticsVariable("google_aid", advertisingIdEvent.getDeviceId())));
                    eventQueue.add(1, new TuneUpdateUserProfile(new TuneAnalyticsVariable("google_ad_tracking_disabled", advertisingIdEvent.getLimitAdTrackingEnabled())));
                    break;
                }
            }
            if (managerInitialized) {
                TuneEventBus.dequeue();
            }
            return;
        }
        if (managerInitialized && getAdvertisingIdCompleted) {
            EVENT_BUS.post(event);
        } else {
            TuneDebugLog.d("Adding event " + event.getClass().getName() + " to queue with current size " + eventQueue.size());
            eventQueue.add(event);
        }
    }

    public static void register(Object subscriber) {
        if (!enabled) {
            return;
        }
        EVENT_BUS.register(subscriber);
    }

    public static void register(Object subscriber, int priority) {
        if (!enabled) {
            return;
        }
        EVENT_BUS.register(subscriber, priority);
    }

    public static void unregister(Object subscriber) {
        if (!enabled || subscriber == null) {
            return;
        }
        EVENT_BUS.unregister(subscriber);
    }

    public static synchronized void disable() {
        enabled = false;
        eventQueue.clear();
    }

    public static void enable() {
        enabled = true;
    }

    protected static synchronized List<Object> getQueue() {
        return eventQueue;
    }

    public static void clearFlags() {
        managerInitialized = false;
        getAdvertisingIdCompleted = false;
    }

    private static synchronized void dequeue() {
        Iterator<Object> it = eventQueue.iterator();
        while (it.hasNext()) {
            Object queuedEvent = it.next();
            EVENT_BUS.post(queuedEvent);
            it.remove();
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }
}

