/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.connected;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import com.tune.ma.TuneManager;
import com.tune.ma.deepactions.model.TuneDeepAction;
import com.tune.ma.eventbus.event.TuneAppBackgrounded;
import com.tune.ma.eventbus.event.TuneConnectedModeTurnedOn;
import com.tune.ma.eventbus.event.TunePlaylistManagerCurrentPlaylistChanged;
import com.tune.ma.powerhooks.model.TunePowerHookValue;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneConnectedModeManager {
    private static final String POWER_HOOKS_KEY = "power_hooks";
    private static final String DEEP_ACTIONS_KEY = "deep_actions";
    private static final String DEVICE_INFO_KEY = "device_info";
    private Context context;
    private boolean hasConnected;
    private ExecutorService executorService;

    public TuneConnectedModeManager(Context context) {
        this.context = context;
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void onEvent(TuneConnectedModeTurnedOn event) {
        this.handleConnection();
    }

    public void onEvent(TuneAppBackgrounded event) {
        if (this.isInConnectedMode()) {
            this.handleDisconnection();
        }
    }

    public void handleConnection() {
        this.setConnectedMode(true);
        this.showConnectedModeAlert();
        this.sendConnectDeviceRequest();
        this.sendSyncRequest();
        TuneManager.getInstance().getPlaylistManager().getConnectedPlaylist();
    }

    public void handleDisconnection() {
        this.setConnectedMode(false);
        this.sendDisconnectDeviceRequest();
    }

    public void showConnectedModeAlert() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)TuneConnectedModeManager.this.context, (CharSequence)"Success! This device is now in connected mode.", (int)1).show();
            }
        });
    }

    public void sendConnectDeviceRequest() {
        this.executorService.execute(new Connect());
    }

    public void sendDisconnectDeviceRequest() {
        this.executorService.execute(new Disconnect());
    }

    public void sendSyncRequest() {
        JSONArray powerHooksJson = new JSONArray();
        JSONArray deepActionsJson = new JSONArray();
        for (TunePowerHookValue tunePowerHookValue : TuneManager.getInstance().getPowerHookManager().getPowerHookValues()) {
            if (tunePowerHookValue.getDefaultValue() == null || tunePowerHookValue.getFriendlyName() == null) continue;
            powerHooksJson.put((Object)tunePowerHookValue.toJson());
        }
        List<TuneDeepAction> deepActions = TuneManager.getInstance().getDeepActionManager().getDeepActions();
        for (TuneDeepAction deepAction : deepActions) {
            deepActionsJson.put((Object)deepAction.toJson());
        }
        JSONObject jSONObject = new JSONObject();
        JSONObject combined = new JSONObject();
        try {
            combined.put(POWER_HOOKS_KEY, (Object)powerHooksJson);
            combined.put(DEEP_ACTIONS_KEY, (Object)deepActionsJson);
            combined.put(DEVICE_INFO_KEY, (Object)jSONObject);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.executorService.execute(new Sync(combined));
    }

    public void onEvent(TunePlaylistManagerCurrentPlaylistChanged event) {
        if (this.isInConnectedMode()) {
            // empty if block
        }
    }

    public boolean isInConnectedMode() {
        return this.hasConnected;
    }

    public void setConnectedMode(boolean connected) {
        this.hasConnected = connected;
    }

    private class Sync
    implements Runnable {
        private JSONObject syncObject;

        public Sync(JSONObject syncObject) {
            this.syncObject = syncObject;
        }

        @Override
        public void run() {
            if (TuneManager.getInstance() != null) {
                TuneManager.getInstance().getApi().postSync(this.syncObject);
            }
        }
    }

    private class Disconnect
    implements Runnable {
        private Disconnect() {
        }

        @Override
        public void run() {
            if (TuneManager.getInstance() != null) {
                TuneManager.getInstance().getApi().postDisconnect();
            }
        }
    }

    private class Connect
    implements Runnable {
        private Connect() {
        }

        @Override
        public void run() {
            if (TuneManager.getInstance() != null) {
                TuneManager.getInstance().getApi().postConnect();
            }
        }
    }
}

