/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.configuration;

import android.content.Context;
import com.tune.ma.TuneManager;
import com.tune.ma.configuration.TuneConfiguration;
import com.tune.ma.eventbus.TuneEventBus;
import com.tune.ma.eventbus.event.TuneAppForegrounded;
import com.tune.ma.eventbus.event.TuneConnectedModeTurnedOn;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneJsonUtils;
import com.tune.ma.utils.TuneSharedPrefsDelegate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneConfigurationManager {
    private static final String CONNECTED_MODE_ON = "1";
    private boolean debugLoggingOn;
    private boolean debugMode;
    private String playlistHostPort;
    private String configurationHostPort;
    private String analyticsHostPort;
    private String connectedModeHostPort;
    private String staticContentHostPort;
    private boolean echoAnalytics;
    private boolean echoFiveline;
    private boolean echoPlaylists;
    private boolean echoConfigurations;
    private boolean echoPushes;
    private boolean usePlaylistPlayer;
    private List<String> playlistPlayerFilenames;
    private boolean useConfigurationPlayer;
    private List<String> configurationPlayerFilenames;
    private boolean enabledTMA;
    private boolean gotFirstConfiguration;
    private boolean shouldAutoCollectDeviceLocation;
    private boolean shouldSendScreenViews;
    private boolean pollForPlaylist;
    private int analyticsDispatchPeriod;
    private int analyticsMessageStorageLimit;
    private int playlistRequestPeriod;
    private List<String> PIIFiltersAsStrings;
    private List<Pattern> PIIFiltersAsPatterns;
    private String pluginName;
    TuneSharedPrefsDelegate sharedPrefs;
    ExecutorService executorService;

    public TuneConfigurationManager(Context context, TuneConfiguration localConfig) {
        this.sharedPrefs = new TuneSharedPrefsDelegate(context, "com.mobileapptracking");
        if (localConfig == null) {
            localConfig = new TuneConfiguration();
        }
        this.setupConfiguration(localConfig);
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void onEvent(TuneAppForegrounded event) {
        if (!this.isTMADisabled()) {
            this.updateConfigurationFromServer();
        }
    }

    public void setupConfiguration(TuneConfiguration configuration) {
        JSONObject storedConfig = TuneManager.getInstance().getFileManager().readConfiguration();
        if (storedConfig != null) {
            this.updateConfigurationFromTuneConfigurationObject(configuration);
            this.updateConfigurationFromJson(storedConfig);
        } else {
            this.updateConfigurationFromTuneConfigurationObject(configuration);
        }
    }

    public void getConfigurationIfDisabled() {
        if (this.isTMADisabled() && !this.isTMAPermanentlyDisabled() && !this.gotFirstConfiguration) {
            this.updateConfigurationFromServer();
        }
    }

    public synchronized void updateConfigurationFromTuneConfigurationObject(TuneConfiguration config) {
        this.analyticsDispatchPeriod = config.getAnalyticsDispatchPeriod();
        this.analyticsMessageStorageLimit = config.getAnalyticsMessageStorageLimit();
        this.playlistRequestPeriod = config.getPlaylistRequestPeriod();
        this.shouldAutoCollectDeviceLocation = config.shouldAutoCollectDeviceLocation();
        this.shouldSendScreenViews = config.shouldSendScreenViews();
        this.pollForPlaylist = config.getPollForPlaylist();
        this.echoAnalytics = config.echoAnalytics();
        this.echoPlaylists = config.echoPlaylists();
        this.echoConfigurations = config.echoConfigurations();
        this.echoFiveline = config.echoFiveline();
        this.echoPushes = config.echoPushes();
        this.PIIFiltersAsStrings = config.getPIIFiltersAsStrings();
        this.buildPIIFiltersAsPatterns();
        this.debugLoggingOn = config.debugLoggingOn();
        if (this.debugLoggingOn) {
            TuneDebugLog.enableLog();
            TuneDebugLog.setLogLevel(1);
        }
        this.debugMode = config.debugMode();
        this.playlistHostPort = config.getPlaylistHostPort();
        this.configurationHostPort = config.getConfigurationHostPort();
        this.analyticsHostPort = config.getAnalyticsHostPort();
        this.connectedModeHostPort = config.getConnectedModeHostPort();
        this.staticContentHostPort = config.getStaticContentHostPort();
        this.usePlaylistPlayer = config.usePlaylistPlayer();
        this.playlistPlayerFilenames = config.getPlaylistPlayerFilenames();
        this.useConfigurationPlayer = config.useConfigurationPlayer();
        this.configurationPlayerFilenames = config.getConfigurationPlayerFilenames();
    }

    public synchronized void updateConfigurationFromJson(JSONObject configuration) {
        try {
            if (configuration.has("analytics_dispatch_period")) {
                this.analyticsDispatchPeriod = configuration.getInt("analytics_dispatch_period");
            }
            if (configuration.has("analytics_message_limit")) {
                this.analyticsMessageStorageLimit = configuration.getInt("analytics_message_limit");
            }
            if (configuration.has("playlist_request_period")) {
                this.playlistRequestPeriod = configuration.getInt("playlist_request_period");
            }
            if (configuration.has("autocollect_location")) {
                this.shouldAutoCollectDeviceLocation = configuration.getBoolean("autocollect_location");
            }
            if (configuration.has("echo_analytics")) {
                this.echoAnalytics = configuration.getBoolean("echo_analytics");
            }
            if (configuration.has("echo_playlists")) {
                this.echoPlaylists = configuration.getBoolean("echo_playlists");
            }
            if (configuration.has("echo_configurations")) {
                this.echoConfigurations = configuration.getBoolean("echo_configurations");
            }
            if (configuration.has("echo_fiveline")) {
                this.echoFiveline = configuration.getBoolean("echo_fiveline");
            }
            if (configuration.has("PIIRegexFilters")) {
                JSONArray jsonArray = configuration.getJSONArray("PIIRegexFilters");
                this.PIIFiltersAsStrings = TuneJsonUtils.JSONArrayToStringArrayList(jsonArray);
                this.buildPIIFiltersAsPatterns();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public synchronized void updateConfigurationFromRemoteJson(JSONObject configuration) {
        this.updateConfigurationFromJson(configuration);
        this.updateConnectedModeState(configuration);
        if (!this.isTMAPermanentlyDisabled()) {
            this.updatePermanentlyDisabledState(configuration);
            this.updateDisabledState(configuration);
        }
    }

    public synchronized void updateConfigurationFromServer() {
        if (this.isTMAPermanentlyDisabled()) {
            return;
        }
        this.gotFirstConfiguration = true;
        if (this.useConfigurationPlayer) {
            JSONObject configuration = TuneManager.getInstance().getConfigurationPlayer().getNext();
            this.updateConfigurationFromRemoteJson(configuration);
            if (this.echoConfigurations) {
                TuneDebugLog.alwaysLog("Got configuration from configuration player:\n" + TuneJsonUtils.getPrettyJson(configuration));
            }
        } else {
            this.executorService.execute(new GetConfigurationTask(this));
        }
    }

    public void buildPIIFiltersAsPatterns() {
        ArrayList<Pattern> filtersAsPatterns = new ArrayList<Pattern>();
        for (String pattern : this.PIIFiltersAsStrings) {
            try {
                Pattern p = Pattern.compile(pattern, 2);
                filtersAsPatterns.add(p);
            }
            catch (PatternSyntaxException e) {
                e.printStackTrace();
                TuneDebugLog.e("Exception parsing PIIRegexFilters filter: " + pattern);
            }
        }
        this.PIIFiltersAsPatterns = filtersAsPatterns;
    }

    public void updateConnectedModeState(JSONObject config) {
        boolean newConnectedModeStatus = CONNECTED_MODE_ON.equals(config.optString("connected_mode"));
        if (newConnectedModeStatus && !TuneManager.getInstance().getConnectedModeManager().isInConnectedMode()) {
            TuneEventBus.post(new TuneConnectedModeTurnedOn());
        }
    }

    public void updateDisabledState(JSONObject config) {
        try {
            if (config.has("disabled")) {
                boolean newDisabledState = config.getBoolean("disabled");
                this.sharedPrefs.saveBooleanToSharedPreferences("disabled", newDisabledState);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updatePermanentlyDisabledState(JSONObject config) {
        try {
            if (config.has("permanently_disabled") && config.getBoolean("permanently_disabled")) {
                this.sharedPrefs.saveBooleanToSharedPreferences("permanently_disabled", true);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public boolean isTMADisabled() {
        if (this.isTMAPermanentlyDisabled()) {
            return true;
        }
        return this.sharedPrefs.getBooleanFromSharedPreferences("disabled", false);
    }

    public boolean isTMAPermanentlyDisabled() {
        return this.sharedPrefs.getBooleanFromSharedPreferences("permanently_disabled");
    }

    public boolean debugLoggingOn() {
        return this.debugLoggingOn;
    }

    public boolean debugMode() {
        return this.debugMode;
    }

    public String getPlaylistHostPort() {
        return this.playlistHostPort;
    }

    public String getConfigurationHostPort() {
        return this.configurationHostPort;
    }

    public String getAnalyticsHostPort() {
        return this.analyticsHostPort;
    }

    public String getConnectedModeHostPort() {
        return this.connectedModeHostPort;
    }

    public String getStaticContentHostPort() {
        return this.staticContentHostPort;
    }

    public boolean echoAnalytics() {
        return this.echoAnalytics;
    }

    public boolean echoFiveline() {
        return this.echoFiveline;
    }

    public boolean echoPlaylists() {
        return this.echoPlaylists;
    }

    public boolean echoConfigurations() {
        return this.echoConfigurations;
    }

    public boolean echoPushes() {
        return this.echoPushes;
    }

    public boolean usePlaylistPlayer() {
        return this.usePlaylistPlayer;
    }

    public List<String> getPlaylistPlayerFilenames() {
        return this.playlistPlayerFilenames;
    }

    public boolean useConfigurationPlayer() {
        return this.useConfigurationPlayer;
    }

    public List<String> getConfigurationPlayerFilenames() {
        return this.configurationPlayerFilenames;
    }

    public boolean shouldAutoCollectDeviceLocation() {
        return this.shouldAutoCollectDeviceLocation;
    }

    public boolean shouldSendScreenViews() {
        return this.shouldSendScreenViews;
    }

    public boolean getPollForPlaylist() {
        return this.pollForPlaylist;
    }

    public int getAnalyticsDispatchPeriod() {
        return this.analyticsDispatchPeriod;
    }

    public int getAnalyticsMessageStorageLimit() {
        return this.analyticsMessageStorageLimit;
    }

    public int getPlaylistRequestPeriod() {
        return this.playlistRequestPeriod;
    }

    public List<Pattern> getPIIFiltersAsPatterns() {
        return this.PIIFiltersAsPatterns;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getApiVersion() {
        return "v3";
    }

    private static class GetConfigurationTask
    implements Runnable {
        TuneConfigurationManager tuneConfiguration;

        public GetConfigurationTask(TuneConfigurationManager tuneConfiguration) {
            this.tuneConfiguration = tuneConfiguration;
        }

        @Override
        public void run() {
            JSONObject response = TuneManager.getInstance().getApi().getConfiguration();
            if (response == null) {
                TuneDebugLog.w("Configuration response did not have any JSON");
            } else if (response.length() == 0) {
                TuneDebugLog.w("Received empty configuration from the server -- not updating");
            } else {
                if (this.tuneConfiguration.echoConfigurations) {
                    TuneDebugLog.alwaysLog("Got configuration:\n" + TuneJsonUtils.getPrettyJson(response));
                }
                TuneManager.getInstance().getFileManager().writeConfiguration(response);
                this.tuneConfiguration.updateConfigurationFromRemoteJson(response);
            }
        }
    }
}

