/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.campaign.model;

import com.tune.ma.analytics.model.TuneAnalyticsVariable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneCampaign {
    public static final String TUNE_CAMPAIGN_IDENTIFIER = "TUNE_CAMPAIGN_ID";
    public static final String TUNE_CAMPAIGN_VARIATION_IDENTIFIER = "TUNE_CAMPAIGN_VARIATION_ID";
    private String campaignId;
    private String variationId;
    private Integer numberOfSecondsToReportAnalytics;
    private Date lastViewed;
    private Date timestampToStopReportingAnalytics;
    private static final String JSON_CAMPAIGN_ID = "campaignId";
    private static final String JSON_VARIATION_ID = "variationId";
    private static final String JSON_LAST_VIEWED = "lastViewed";
    private static final String JSON_NUMBER_OF_SECONDS_TO_REPORT = "numberOfSecondsToReportAnalytics";

    public TuneCampaign(String campaignId, String variationId, Integer numberOfSecondsToReportAnalytics) {
        this.campaignId = campaignId;
        this.variationId = variationId;
        this.numberOfSecondsToReportAnalytics = numberOfSecondsToReportAnalytics;
    }

    public Set<TuneAnalyticsVariable> toAnalyticVariables() {
        HashSet<TuneAnalyticsVariable> result = new HashSet<TuneAnalyticsVariable>();
        result.add(new TuneAnalyticsVariable(TUNE_CAMPAIGN_IDENTIFIER, this.campaignId));
        result.add(new TuneAnalyticsVariable(TUNE_CAMPAIGN_VARIATION_IDENTIFIER, this.variationId));
        return result;
    }

    public boolean hasCampaignId() {
        return this.campaignId != null && this.campaignId.length() > 0;
    }

    public boolean hasVariationId() {
        return this.variationId != null && this.variationId.length() > 0;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getVariationId() {
        return this.variationId;
    }

    public Integer getNumberOfSecondsToReportAnalytics() {
        return this.numberOfSecondsToReportAnalytics;
    }

    private void calculateTimestampToStopReportingAnalytics() {
        if (this.numberOfSecondsToReportAnalytics != null && this.lastViewed != null) {
            this.timestampToStopReportingAnalytics = new Date(this.lastViewed.getTime() + (long)(1000 * this.numberOfSecondsToReportAnalytics));
        }
    }

    public void markCampaignViewed() {
        this.lastViewed = new Date();
        this.calculateTimestampToStopReportingAnalytics();
    }

    public boolean needToReportCampaignAnalytics() {
        if (this.timestampToStopReportingAnalytics != null) {
            return this.timestampToStopReportingAnalytics.before(new Date());
        }
        return false;
    }

    public String toStorage() throws JSONException {
        JSONObject result = new JSONObject();
        result.put(JSON_CAMPAIGN_ID, (Object)this.campaignId);
        result.put(JSON_VARIATION_ID, (Object)this.variationId);
        result.put(JSON_LAST_VIEWED, this.lastViewed.getTime());
        result.put(JSON_NUMBER_OF_SECONDS_TO_REPORT, (Object)this.numberOfSecondsToReportAnalytics);
        return result.toString();
    }

    public static TuneCampaign fromStorage(String json) throws JSONException {
        JSONObject jsonObject = new JSONObject(json);
        String campaignId = jsonObject.getString(JSON_CAMPAIGN_ID);
        String variationId = jsonObject.getString(JSON_VARIATION_ID);
        Integer secondsToReport = jsonObject.getInt(JSON_NUMBER_OF_SECONDS_TO_REPORT);
        TuneCampaign result = new TuneCampaign(campaignId, variationId, secondsToReport);
        result.lastViewed = new Date(jsonObject.getInt(JSON_LAST_VIEWED));
        result.calculateTimestampToStopReportingAnalytics();
        return result;
    }
}

