/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.campaign;

import android.content.Context;
import com.tune.ma.campaign.model.TuneCampaign;
import com.tune.ma.eventbus.TuneEventBus;
import com.tune.ma.eventbus.event.TuneAppForegrounded;
import com.tune.ma.eventbus.event.TuneSessionVariableToSet;
import com.tune.ma.eventbus.event.campaign.TuneCampaignViewed;
import com.tune.ma.utils.TuneSharedPrefsDelegate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TuneCampaignStateManager {
    private final String TUNE_CAMPAIGN_PREFS = "com.tune.ma.campaign";
    Map<String, TuneCampaign> viewedCampaigns = new HashMap<String, TuneCampaign>();
    Set<String> campaignIdsRecordedThisSession = new HashSet<String>();
    Set<String> variationIdsRecordedThisSession = new HashSet<String>();
    TuneSharedPrefsDelegate sharedPrefs;

    public TuneCampaignStateManager(Context context) {
        this.sharedPrefs = new TuneSharedPrefsDelegate(context, "com.tune.ma.campaign");
        this.retrieveViewedCampaigns();
        this.campaignHouseKeeping();
    }

    public void onEvent(TuneAppForegrounded event) {
        this.campaignHouseKeeping();
        for (Map.Entry<String, TuneCampaign> e : this.viewedCampaigns.entrySet()) {
            String campaignId = e.getValue().getCampaignId();
            this.addViewedCampaignIdToSession(campaignId);
            String variationId = e.getKey();
            this.addViewedVariationIdToSession(variationId);
        }
    }

    public void onEvent(TuneCampaignViewed event) {
        TuneCampaign campaign = event.getCampaign();
        if (campaign != null && campaign.hasCampaignId() && campaign.hasVariationId()) {
            campaign.markCampaignViewed();
            if (!this.viewedCampaigns.containsKey(campaign.getVariationId())) {
                this.addViewedCampaignIdToSession(campaign.getCampaignId());
                this.addViewedVariationIdToSession(campaign.getVariationId());
            }
            this.viewedCampaigns.put(campaign.getVariationId(), campaign);
        }
        this.storeViewedCampaigns();
    }

    private void campaignHouseKeeping() {
        boolean needToStoreChanges = false;
        for (Map.Entry<String, TuneCampaign> e : this.viewedCampaigns.entrySet()) {
            if (e.getValue().needToReportCampaignAnalytics()) continue;
            this.viewedCampaigns.remove(e.getKey());
            needToStoreChanges = true;
        }
        if (needToStoreChanges) {
            this.storeViewedCampaigns();
        }
    }

    private void addViewedCampaignIdToSession(String campaignId) {
        if (!this.campaignIdsRecordedThisSession.contains(campaignId)) {
            TuneEventBus.post(new TuneSessionVariableToSet("TUNE_CAMPAIGN_ID", campaignId, TuneSessionVariableToSet.SaveTo.PROFILE));
            this.campaignIdsRecordedThisSession.add(campaignId);
        }
    }

    private void addViewedVariationIdToSession(String variationId) {
        if (!this.variationIdsRecordedThisSession.contains(variationId)) {
            TuneEventBus.post(new TuneSessionVariableToSet("TUNE_CAMPAIGN_VARIATION_ID", variationId, TuneSessionVariableToSet.SaveTo.PROFILE));
            this.variationIdsRecordedThisSession.add(variationId);
        }
    }

    private void storeViewedCampaigns() {
        for (Map.Entry<String, TuneCampaign> entry : this.viewedCampaigns.entrySet()) {
            try {
                TuneCampaign campaign = entry.getValue();
                this.sharedPrefs.saveToSharedPreferences(entry.getKey(), campaign.toStorage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void retrieveViewedCampaigns() {
        if (this.viewedCampaigns == null) {
            this.viewedCampaigns = new HashMap<String, TuneCampaign>();
        }
        for (Map.Entry<String, ?> entry : this.sharedPrefs.getAll().entrySet()) {
            try {
                String storedCampaign = (String)entry.getValue();
                this.viewedCampaigns.put(entry.getKey(), TuneCampaign.fromStorage(storedCampaign));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

