/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.application;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import com.tune.Tune;
import com.tune.ma.TuneManager;
import com.tune.ma.eventbus.TuneEventBus;
import com.tune.ma.eventbus.event.TuneActivityConnected;
import com.tune.ma.eventbus.event.TuneActivityDisconnected;
import com.tune.ma.eventbus.event.TuneActivityResumed;
import com.tune.ma.eventbus.event.campaign.TuneCampaignViewed;
import com.tune.ma.eventbus.event.deepaction.TuneDeepActionCalled;
import com.tune.ma.eventbus.event.push.TunePushOpened;
import com.tune.ma.push.model.TunePushMessage;
import com.tune.ma.push.model.TunePushOpenAction;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneOptional;
import java.util.Calendar;
import java.util.Map;

public class TuneActivity
extends Activity {
    protected void onStart() {
        super.onStart();
        if (Build.VERSION.SDK_INT < 14) {
            TuneActivity.onStart(this);
        }
    }

    protected void onResume() {
        super.onResume();
        if (Build.VERSION.SDK_INT < 14) {
            TuneActivity.onResume(this);
        }
    }

    protected void onStop() {
        if (Build.VERSION.SDK_INT < 14) {
            TuneActivity.onStop(this);
        }
        super.onStop();
    }

    public static void onStart(@NonNull Activity activity) {
        if (activity == null) {
            TuneDebugLog.e("WARNING: TuneActivity.onStart() called with null Activity");
            return;
        }
        TuneDebugLog.i(activity.getClass().getSimpleName(), "onStart()");
        if (TuneManager.getInstance() != null && TuneManager.getInstance().getConfigurationManager() != null) {
            TuneManager.getInstance().getConfigurationManager().getConfigurationIfDisabled();
        }
        TuneOptional<TunePushMessage> possibleMessage = null;
        if (TuneManager.getInstance() != null && TuneManager.getInstance().getPushManager() != null && (possibleMessage = TuneManager.getInstance().getPushManager().checkGetPushFromActivity(activity)).isPresent()) {
            TunePushMessage message = possibleMessage.get();
            if (!message.isTestMessage()) {
                TuneEventBus.post(new TuneCampaignViewed(message.getCampaign()));
            }
            if (message.isOpenActionDeepAction()) {
                TunePushOpenAction action = message.getPayload().getOnOpenAction();
                String deepActionId = action.getDeepActionId();
                Map<String, String> deepActionParams = action.getDeepActionParameters();
                TuneEventBus.post(new TuneDeepActionCalled(deepActionId, deepActionParams, activity));
            }
        }
        TuneEventBus.post(new TuneActivityConnected(activity));
        if (possibleMessage != null && possibleMessage.isPresent() && !possibleMessage.get().isTestMessage()) {
            TuneEventBus.post(new TunePushOpened(possibleMessage.get()));
        }
    }

    public static void onResume(@NonNull Activity activity) {
        if (activity == null) {
            TuneDebugLog.e("WARNING: TuneActivity.onResume() called with null Activity");
            return;
        }
        TuneDebugLog.i(activity.getClass().getSimpleName(), "onResume()");
        Intent intent = activity.getIntent();
        if (intent != null) {
            String uriString = intent.getDataString();
            if (uriString != null) {
                Tune.getInstance().setReferralCallingPackage(activity.getCallingPackage());
                Tune.getInstance().setReferralUrl(uriString);
            }
            if (TuneActivity.shouldMeasureSession(intent)) {
                Tune.getInstance().measureSessionInternal();
            }
        }
        String[] splitName = activity.getClass().getSimpleName().split("TuneActivity");
        TuneEventBus.post(new TuneActivityResumed(splitName[0]));
    }

    private static boolean shouldMeasureSession(Intent intent) {
        return TuneActivity.isDeeplinkIntent(intent) || TuneActivity.isLaunchIntent(intent) || TuneActivity.isTimeToMeasureSessionAgain();
    }

    private static boolean isDeeplinkIntent(Intent intent) {
        return null != intent.getDataString();
    }

    private static boolean isLaunchIntent(Intent intent) {
        return "android.intent.action.MAIN".equals(intent.getAction());
    }

    private static boolean isTimeToMeasureSessionAgain() {
        long timeLastMeasuredSession = Tune.getInstance().getTimeLastMeasuredSession();
        long eightHoursInMilliseconds = 28800000L;
        boolean lastMeasuredMoreThan8HoursAgo = timeLastMeasuredSession < System.currentTimeMillis() - 28800000L;
        Calendar today = Calendar.getInstance();
        Calendar lastMeasuredSessionDate = Calendar.getInstance();
        lastMeasuredSessionDate.setTimeInMillis(Tune.getInstance().getTimeLastMeasuredSession());
        boolean lastMeasuredOnADifferentUTCDay = today.get(6) != lastMeasuredSessionDate.get(6);
        return lastMeasuredOnADifferentUTCDay || lastMeasuredMoreThan8HoursAgo;
    }

    public static void onStop(@NonNull Activity activity) {
        if (activity == null) {
            TuneDebugLog.e("WARNING: TuneActivity.onStop() called with null Activity");
            return;
        }
        TuneDebugLog.i(activity.getClass().getSimpleName(), "onStop()");
        TuneEventBus.post(new TuneActivityDisconnected(activity));
    }
}

