/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.analytics.model.event;

import com.tune.TuneEvent;
import com.tune.TuneEventItem;
import com.tune.ma.analytics.model.TuneAnalyticsEventItem;
import com.tune.ma.analytics.model.TuneAnalyticsVariable;
import com.tune.ma.analytics.model.TuneEventType;
import com.tune.ma.analytics.model.event.TuneAnalyticsEventBase;

public class TuneCustomEvent
extends TuneAnalyticsEventBase {
    public TuneCustomEvent(TuneEvent event) {
        this.category = "Custom";
        this.eventType = TuneEventType.EVENT;
        this.action = event.getEventId() != 0 ? Integer.toString(event.getEventId()) : event.getEventName();
        if (event.getEventItems() != null) {
            for (TuneEventItem item : event.getEventItems()) {
                this.items.add(new TuneAnalyticsEventItem(item));
            }
        }
        if (!event.getTags().isEmpty()) {
            this.tags.addAll(event.getTags());
        }
        if (event.getEventId() != 0) {
            this.tags.add(new TuneAnalyticsVariable("site_event_id", event.getEventId()));
        }
        if (event.getRevenue() != 0.0) {
            this.tags.add(new TuneAnalyticsVariable("revenue", event.getRevenue()));
        }
        if (event.getCurrencyCode() != null) {
            this.tags.add(new TuneAnalyticsVariable("currency_code", event.getCurrencyCode()));
        }
        if (event.getRefId() != null) {
            this.tags.add(new TuneAnalyticsVariable("advertiser_ref_id", event.getRefId()));
        }
        if (event.getReceiptData() != null) {
            this.tags.add(new TuneAnalyticsVariable("store_iap_data", event.getReceiptData()));
        }
        if (event.getReceiptSignature() != null) {
            this.tags.add(new TuneAnalyticsVariable("store_iap_signature", event.getReceiptSignature()));
        }
        if (event.getContentType() != null) {
            this.tags.add(new TuneAnalyticsVariable("content_type", event.getContentType()));
        }
        if (event.getContentId() != null) {
            this.tags.add(new TuneAnalyticsVariable("content_id", event.getContentId()));
        }
        if (event.getDate1() != null) {
            this.tags.add(new TuneAnalyticsVariable("date1", event.getDate1()));
        }
        if (event.getDate2() != null) {
            this.tags.add(new TuneAnalyticsVariable("date2", event.getDate2()));
        }
        if (event.getLevel() != 0) {
            this.tags.add(new TuneAnalyticsVariable("level", event.getLevel()));
        }
        if (event.getQuantity() != 0) {
            this.tags.add(new TuneAnalyticsVariable("quantity", event.getQuantity()));
        }
        if (event.getRating() != 0.0) {
            this.tags.add(new TuneAnalyticsVariable("rating", event.getRating()));
        }
        if (event.getSearchString() != null) {
            this.tags.add(new TuneAnalyticsVariable("search_string", event.getSearchString()));
        }
        if (event.getAttribute1() != null) {
            this.tags.add(new TuneAnalyticsVariable("attribute_sub1", event.getAttribute1()));
        }
        if (event.getAttribute2() != null) {
            this.tags.add(new TuneAnalyticsVariable("attribute_sub2", event.getAttribute2()));
        }
        if (event.getAttribute3() != null) {
            this.tags.add(new TuneAnalyticsVariable("attribute_sub3", event.getAttribute3()));
        }
        if (event.getAttribute4() != null) {
            this.tags.add(new TuneAnalyticsVariable("attribute_sub4", event.getAttribute4()));
        }
        if (event.getAttribute5() != null) {
            this.tags.add(new TuneAnalyticsVariable("attribute_sub5", event.getAttribute5()));
        }
    }
}

