/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.analytics.model.event;

import com.tune.ma.TuneManager;
import com.tune.ma.analytics.model.TuneAnalyticsEventItem;
import com.tune.ma.analytics.model.TuneAnalyticsSubmitter;
import com.tune.ma.analytics.model.TuneAnalyticsVariable;
import com.tune.ma.analytics.model.TuneEventType;
import com.tune.ma.utils.TuneJsonUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class TuneAnalyticsEventBase {
    public static final String APPLICATION_CATEGORY = "Application";
    public static final String CUSTOM_CATEGORY = "Custom";
    private static final String SCHEMA_VERSION_VALUE = "2.0";
    private static final String ACTION = "action";
    private static final String APP_ID = "appId";
    private static final String CATEGORY = "category";
    private static final String CONTROL = "control";
    private static final String CONTROL_EVENT = "controlEvent";
    private static final String EVENT_TYPE = "type";
    private static final String ITEMS = "items";
    private static final String PROFILE = "profile";
    private static final String SCHEMA_VERSION = "schemaVersion";
    private static final String SESSION_TIME = "sessionTime";
    private static final String SUBMITTER = "submitter";
    private static final String TAGS = "tags";
    private static final String TIMESTAMP = "timestamp";
    protected TuneAnalyticsSubmitter submitter;
    protected TuneEventType eventType;
    protected String action;
    protected String appId;
    protected String category;
    protected String control;
    protected String controlEvent;
    protected String eventId;
    protected Set<TuneAnalyticsVariable> tags;
    protected List<TuneAnalyticsEventItem> items;
    protected List<TuneAnalyticsVariable> profile;
    protected double sessionTime = -1.0;
    protected double timeStamp = (double)System.currentTimeMillis() / 1000.0;

    public TuneAnalyticsEventBase() {
        this.submitter = new TuneAnalyticsSubmitter(TuneManager.getInstance().getProfileManager());
        this.appId = TuneManager.getInstance().getProfileManager().getAppId();
        this.profile = TuneManager.getInstance().getProfileManager().getCopyOfVars();
        this.sessionTime = TuneManager.getInstance().getSessionManager().getSecondsSinceSessionStart();
        this.items = new ArrayList<TuneAnalyticsEventItem>();
        this.tags = new HashSet<TuneAnalyticsVariable>();
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        this.control = control;
    }

    public String getControlEvent() {
        return this.controlEvent;
    }

    public void setControlEvent(String controlEvent) {
        this.controlEvent = controlEvent;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String id) {
        this.eventId = id;
    }

    public TuneEventType getEventType() {
        return this.eventType;
    }

    public List<TuneAnalyticsEventItem> getItems() {
        return this.items;
    }

    public void setItems(List<TuneAnalyticsEventItem> items) {
        this.items = items;
    }

    public Set<TuneAnalyticsVariable> getTags() {
        return this.tags;
    }

    public void setTags(Set<TuneAnalyticsVariable> tags) {
        this.tags = tags;
    }

    public double getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        try {
            List<JSONObject> listOfVariablesAsJson;
            object.put(SCHEMA_VERSION, (Object)SCHEMA_VERSION_VALUE);
            JSONObject submitterJson = new JSONObject();
            TuneJsonUtils.put(submitterJson, "sessionId", this.submitter.getSessionId());
            TuneJsonUtils.put(submitterJson, "deviceId", this.submitter.getDeviceId());
            TuneJsonUtils.put(submitterJson, "gaid", this.submitter.getGoogleAdvertisingId());
            object.put(SUBMITTER, (Object)submitterJson);
            TuneJsonUtils.put(object, ACTION, this.action);
            TuneJsonUtils.put(object, APP_ID, this.appId);
            TuneJsonUtils.put(object, CATEGORY, this.category);
            TuneJsonUtils.put(object, CONTROL, this.control);
            TuneJsonUtils.put(object, CONTROL_EVENT, this.controlEvent);
            TuneJsonUtils.put(object, EVENT_TYPE, this.eventType.toString());
            TuneJsonUtils.put(object, SESSION_TIME, this.sessionTime);
            TuneJsonUtils.put(object, TIMESTAMP, this.timeStamp);
            if (this.tags != null) {
                JSONArray tagsArray = new JSONArray();
                for (TuneAnalyticsVariable tag : this.tags) {
                    listOfVariablesAsJson = tag.toListOfJsonObjectsForDispatch();
                    for (JSONObject tagJson : listOfVariablesAsJson) {
                        tagsArray.put((Object)tagJson);
                    }
                }
                object.put(TAGS, (Object)tagsArray);
            }
            if (this.items != null) {
                JSONArray itemsArray = new JSONArray();
                for (TuneAnalyticsEventItem item : this.items) {
                    itemsArray.put((Object)item.toJson());
                }
                object.put(ITEMS, (Object)itemsArray);
            }
            JSONArray profileArray = new JSONArray();
            for (TuneAnalyticsVariable p : this.profile) {
                listOfVariablesAsJson = p.toListOfJsonObjectsForDispatch();
                for (JSONObject pJson : listOfVariablesAsJson) {
                    profileArray.put((Object)pJson);
                }
            }
            object.put(PROFILE, (Object)profileArray);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }
}

