/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.analytics.model;

import android.text.TextUtils;
import com.tune.TuneLocation;
import com.tune.TuneUtils;
import com.tune.ma.TuneManager;
import com.tune.ma.analytics.model.TuneHashType;
import com.tune.ma.analytics.model.TuneVariableType;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneJsonUtils;
import com.tune.ma.utils.TunePIIUtils;
import com.tune.ma.utils.TuneStringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneAnalyticsVariable {
    public static final String IOS_BOOLEAN_TRUE = "YES";
    public static final String IOS_BOOLEAN_FALSE = "NO";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String HASH = "hash";
    public static final String SHOULD_AUTO_HASH = "shouldAutoHash";
    public static final String DID_HAVE_VALUE_MANUALLY_SET = "didHaveValueManuallySet";
    private String name;
    private String value;
    private TuneVariableType type;
    private TuneHashType hashType;
    private boolean shouldAutoHash;
    private boolean didHaveValueManuallySet;

    private TuneAnalyticsVariable() {
    }

    public TuneAnalyticsVariable(String name, String value) {
        this(name, value, TuneVariableType.STRING);
    }

    public TuneAnalyticsVariable(String name, boolean value) {
        this(name, value ? "1" : "0", TuneVariableType.BOOLEAN);
    }

    public TuneAnalyticsVariable(String name, int value) {
        this(name, Integer.toString(value), TuneVariableType.FLOAT);
    }

    public TuneAnalyticsVariable(String name, double value) {
        this(name, Double.toString(value), TuneVariableType.FLOAT);
    }

    public TuneAnalyticsVariable(String name, float value) {
        this(name, Float.toString(value), TuneVariableType.FLOAT);
    }

    public TuneAnalyticsVariable(String name, Date value) {
        this(name, TuneAnalyticsVariable.dateToString(value), TuneVariableType.DATETIME);
    }

    public TuneAnalyticsVariable(String name, TuneLocation value) {
        this(name, TuneAnalyticsVariable.geolocationToString(value), TuneVariableType.GEOLOCATION);
    }

    public TuneAnalyticsVariable(String name, String value, TuneVariableType type) {
        this(name, value, type, TuneHashType.NONE, false);
    }

    public TuneAnalyticsVariable(String name, String value, TuneVariableType type, TuneHashType hashType, boolean shouldAutohash) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.hashType = hashType;
        this.shouldAutoHash = shouldAutohash;
        this.didHaveValueManuallySet = false;
    }

    public TuneAnalyticsVariable(TuneAnalyticsVariable var) {
        this.name = var.getName();
        this.value = var.getValue();
        this.type = var.getType();
        this.hashType = var.getHashType();
        this.shouldAutoHash = var.getShouldAutoHash();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public TuneVariableType getType() {
        return this.type;
    }

    public TuneHashType getHashType() {
        return this.hashType;
    }

    public boolean didHaveValueManuallySet() {
        return this.didHaveValueManuallySet;
    }

    public List<JSONObject> toListOfJsonObjectsForDispatch() {
        ArrayList<JSONObject> arrayOfJsonVariables = new ArrayList<JSONObject>();
        boolean hasPII = TunePIIUtils.check(this.value, TuneManager.getInstance().getConfigurationManager().getPIIFiltersAsPatterns());
        if (this.shouldAutoHash || hasPII) {
            arrayOfJsonVariables.add(this.toJsonWithHashType(TuneHashType.MD5, false));
            arrayOfJsonVariables.add(this.toJsonWithHashType(TuneHashType.SHA1, false));
            arrayOfJsonVariables.add(this.toJsonWithHashType(TuneHashType.SHA256, false));
        } else {
            arrayOfJsonVariables.add(this.toJsonWithHashType(TuneHashType.NONE, false));
        }
        return arrayOfJsonVariables;
    }

    public boolean getShouldAutoHash() {
        return this.shouldAutoHash;
    }

    public JSONObject toJsonForLocalStorage() {
        return this.toJsonWithHashType(TuneHashType.NONE, true);
    }

    private JSONObject toJsonWithHashType(TuneHashType hashWith, boolean forLocalStorage) {
        JSONObject object = new JSONObject();
        try {
            object.put(NAME, (Object)this.name);
            if (this.value == null) {
                object.put(VALUE, JSONObject.NULL);
            } else if (hashWith == TuneHashType.NONE) {
                object.put(VALUE, (Object)this.value);
            } else if (hashWith == TuneHashType.MD5) {
                object.put(VALUE, (Object)TuneUtils.md5(this.value));
            } else if (hashWith == TuneHashType.SHA1) {
                object.put(VALUE, (Object)TuneUtils.sha1(this.value));
            } else if (hashWith == TuneHashType.SHA256) {
                object.put(VALUE, (Object)TuneUtils.sha256(this.value));
            }
            object.put(TYPE, (Object)this.type.toString().toLowerCase(Locale.ENGLISH));
            if (forLocalStorage) {
                if (this.hashType != TuneHashType.NONE) {
                    object.put(HASH, (Object)this.hashType.toString().toLowerCase(Locale.ENGLISH));
                }
                object.put(SHOULD_AUTO_HASH, this.shouldAutoHash);
                object.put(DID_HAVE_VALUE_MANUALLY_SET, this.didHaveValueManuallySet);
            } else if (hashWith != TuneHashType.NONE) {
                object.put(HASH, (Object)hashWith.toString().toLowerCase(Locale.ENGLISH));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }

    public static TuneAnalyticsVariable fromJson(String json) {
        TuneAnalyticsVariable var = null;
        try {
            JSONObject object = new JSONObject(json);
            String name = TuneJsonUtils.getString(object, NAME);
            String value = null;
            if (!object.isNull(VALUE)) {
                value = TuneJsonUtils.getString(object, VALUE);
            }
            TuneVariableType type = TuneVariableType.valueOf(TuneJsonUtils.getString(object, TYPE).toUpperCase(Locale.ENGLISH));
            TuneHashType hash = TuneHashType.NONE;
            if (object.has(HASH)) {
                hash = TuneHashType.valueOf(TuneJsonUtils.getString(object, HASH).toUpperCase(Locale.ENGLISH));
            }
            var = new TuneAnalyticsVariable();
            var.name = name;
            var.value = value;
            var.type = type;
            var.hashType = hash;
            var.shouldAutoHash = object.optBoolean(SHOULD_AUTO_HASH, false);
            var.didHaveValueManuallySet = object.getBoolean(DID_HAVE_VALUE_MANUALLY_SET);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return var;
    }

    public static boolean validateName(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            TuneDebugLog.IAMConfigError("Attempted to use a variable with name of null or empty string.");
            return false;
        }
        String prettyName = TuneAnalyticsVariable.cleanVariableName(name);
        if (!name.equals(prettyName)) {
            TuneDebugLog.IAMConfigError("Variable name " + name + " had special characters and was automatically changed to " + prettyName);
        }
        if (prettyName.isEmpty()) {
            TuneDebugLog.IAMConfigError("Cannot set variable with name " + name + ", characters exclusively not in [a-zA-Z0-9_-].");
            return false;
        }
        return true;
    }

    public static String cleanVariableName(String name) {
        if (name == null) {
            return null;
        }
        name = name.replaceAll("[^a-zA-Z0-9_\\-]", "");
        return name;
    }

    public static boolean validateVersion(String version) {
        if (TextUtils.isEmpty((CharSequence)version)) {
            return true;
        }
        Pattern versionPattern = Pattern.compile("^(0|[1-9]\\d*)(\\.(0|[1-9]\\d*)){0,2}(\\-.*)?$");
        Matcher matcher = versionPattern.matcher(version);
        return matcher.matches();
    }

    public static String dateToString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ", Locale.US);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        df.setTimeZone(tz);
        String dateString = df.format(date).replaceAll("\\+0000", "Z");
        return dateString;
    }

    public static Date stringToDate(String s) {
        if (s == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        df.setTimeZone(tz);
        Date d = null;
        try {
            d = df.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    public static String geolocationToString(TuneLocation loc) {
        if (loc == null) {
            return null;
        }
        return TuneStringUtils.format("%.9f,%.9f", loc.getLongitude(), loc.getLatitude());
    }

    public static TuneLocation stringToGeolocation(String s) {
        if (s == null) {
            return null;
        }
        String[] foo = TextUtils.split((String)s, (String)",");
        if (foo.length == 2) {
            return new TuneLocation(Double.valueOf(foo[0]), Double.valueOf(foo[1]));
        }
        return null;
    }

    public static TuneAnalyticsVariableBuilder Builder(String variableName) {
        return new TuneAnalyticsVariableBuilder(variableName);
    }

    public static class TuneAnalyticsVariableBuilder {
        private String name;
        private String value;
        private TuneVariableType type;
        private TuneHashType hashType;
        private boolean shouldAutoHash;
        private boolean didHaveValueManuallySet;
        private boolean manuallySetType = false;

        public TuneAnalyticsVariableBuilder(String name) {
            this.name = name;
            this.value = null;
            this.type = TuneVariableType.STRING;
            this.hashType = TuneHashType.NONE;
            this.shouldAutoHash = false;
            this.didHaveValueManuallySet = false;
        }

        public TuneAnalyticsVariableBuilder withValue(String value) {
            this.value = value;
            return this;
        }

        public TuneAnalyticsVariableBuilder withValue(boolean value) {
            this.value = value ? "1" : "0";
            if (!this.manuallySetType) {
                this.type = TuneVariableType.BOOLEAN;
            }
            return this;
        }

        public TuneAnalyticsVariableBuilder withValue(int value) {
            this.value = Integer.toString(value);
            if (!this.manuallySetType) {
                this.type = TuneVariableType.FLOAT;
            }
            return this;
        }

        public TuneAnalyticsVariableBuilder withValue(double value) {
            this.value = Double.toString(value);
            if (!this.manuallySetType) {
                this.type = TuneVariableType.FLOAT;
            }
            return this;
        }

        public TuneAnalyticsVariableBuilder withValue(float value) {
            this.value = Float.toString(value);
            if (!this.manuallySetType) {
                this.type = TuneVariableType.FLOAT;
            }
            return this;
        }

        public TuneAnalyticsVariableBuilder withValue(Date value) {
            this.value = TuneAnalyticsVariable.dateToString(value);
            if (!this.manuallySetType) {
                this.type = TuneVariableType.DATETIME;
            }
            return this;
        }

        public TuneAnalyticsVariableBuilder withValue(TuneLocation value) {
            this.value = TuneAnalyticsVariable.geolocationToString(value);
            if (!this.manuallySetType) {
                this.type = TuneVariableType.GEOLOCATION;
            }
            return this;
        }

        public TuneAnalyticsVariableBuilder withType(TuneVariableType type) {
            this.type = type;
            this.manuallySetType = true;
            return this;
        }

        public TuneAnalyticsVariableBuilder withHash(TuneHashType hash) {
            this.hashType = hash;
            return this;
        }

        public TuneAnalyticsVariableBuilder withShouldAutoHash(boolean shouldAutoHash) {
            this.shouldAutoHash = shouldAutoHash;
            return this;
        }

        public TuneAnalyticsVariableBuilder withValueManuallySet(boolean didHaveValueManuallySet) {
            this.didHaveValueManuallySet = didHaveValueManuallySet;
            return this;
        }

        public TuneAnalyticsVariable build() {
            TuneAnalyticsVariable var = new TuneAnalyticsVariable();
            var.name = this.name;
            var.value = this.value;
            var.type = this.type;
            var.hashType = this.hashType;
            var.shouldAutoHash = this.shouldAutoHash;
            var.didHaveValueManuallySet = this.didHaveValueManuallySet;
            return var;
        }
    }
}

