/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.analytics.model;

import android.text.TextUtils;
import com.tune.TuneEventItem;
import com.tune.ma.analytics.model.TuneAnalyticsVariable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneAnalyticsEventItem {
    public String item;
    public String unitPrice;
    public String quantity;
    public String revenue;
    public Set<TuneAnalyticsVariable> attributes;

    public TuneAnalyticsEventItem(TuneEventItem eventItem) {
        this.item = eventItem.itemname;
        this.unitPrice = Double.toString(eventItem.unitPrice);
        this.quantity = Integer.toString(eventItem.quantity);
        this.revenue = Double.toString(eventItem.revenue);
        this.attributes = new HashSet<TuneAnalyticsVariable>();
        if (!TextUtils.isEmpty((CharSequence)eventItem.attribute1)) {
            this.attributes.add(new TuneAnalyticsVariable("attribute_sub1", eventItem.attribute1));
        }
        if (!TextUtils.isEmpty((CharSequence)eventItem.attribute2)) {
            this.attributes.add(new TuneAnalyticsVariable("attribute_sub2", eventItem.attribute2));
        }
        if (!TextUtils.isEmpty((CharSequence)eventItem.attribute3)) {
            this.attributes.add(new TuneAnalyticsVariable("attribute_sub3", eventItem.attribute3));
        }
        if (!TextUtils.isEmpty((CharSequence)eventItem.attribute4)) {
            this.attributes.add(new TuneAnalyticsVariable("attribute_sub4", eventItem.attribute4));
        }
        if (!TextUtils.isEmpty((CharSequence)eventItem.attribute5)) {
            this.attributes.add(new TuneAnalyticsVariable("attribute_sub5", eventItem.attribute5));
        }
    }

    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        try {
            object.put("item", (Object)this.item);
            object.put("unitPrice", (Object)this.unitPrice);
            object.put("quantity", (Object)this.quantity);
            object.put("revenue", (Object)this.revenue);
            if (this.attributes != null) {
                JSONArray attributesArray = new JSONArray();
                for (TuneAnalyticsVariable attribute : this.attributes) {
                    List<JSONObject> listOfVariablesAsJson = attribute.toListOfJsonObjectsForDispatch();
                    for (JSONObject attributeJson : listOfVariablesAsJson) {
                        attributesArray.put((Object)attributeJson);
                    }
                }
                object.put("attributes", (Object)attributesArray);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }
}

