/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.analytics;

import android.content.Context;
import com.tune.TuneEvent;
import com.tune.ma.TuneManager;
import com.tune.ma.analytics.model.TuneAnalyticsListener;
import com.tune.ma.analytics.model.TuneAnalyticsManagerState;
import com.tune.ma.analytics.model.TuneAnalyticsVariable;
import com.tune.ma.analytics.model.event.TuneAnalyticsEventBase;
import com.tune.ma.analytics.model.event.TuneCustomEvent;
import com.tune.ma.analytics.model.event.TuneScreenViewEvent;
import com.tune.ma.analytics.model.event.push.TunePushActionEvent;
import com.tune.ma.analytics.model.event.push.TunePushEnabledEvent;
import com.tune.ma.analytics.model.event.push.TunePushOpenedEvent;
import com.tune.ma.analytics.model.event.session.TuneBackgroundEvent;
import com.tune.ma.analytics.model.event.session.TuneForegroundEvent;
import com.tune.ma.analytics.model.event.tracer.TuneClearVariablesEvent;
import com.tune.ma.analytics.model.event.tracer.TuneTracerEvent;
import com.tune.ma.eventbus.event.TuneActivityResumed;
import com.tune.ma.eventbus.event.TuneAppBackgrounded;
import com.tune.ma.eventbus.event.TuneAppForegrounded;
import com.tune.ma.eventbus.event.TuneEventOccurred;
import com.tune.ma.eventbus.event.TuneSessionVariableToSet;
import com.tune.ma.eventbus.event.push.TunePushEnabled;
import com.tune.ma.eventbus.event.push.TunePushOpened;
import com.tune.ma.eventbus.event.userprofile.TuneCustomProfileVariablesCleared;
import com.tune.ma.push.model.TunePushMessage;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneJsonUtils;
import com.tune.ma.utils.TuneStringUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneAnalyticsManager {
    private static final String ANALYTICS_EVENTS_KEY = "events";
    private static final String CONNECTED_EVENTS_KEY = "event";
    private ScheduledThreadPoolExecutor scheduler;
    private TuneAnalyticsListener listener;
    private TuneAnalyticsManagerState state;
    private Set<TuneAnalyticsVariable> sessionVariables;
    private Boolean shouldQueueCustomEvents;
    private List<TuneEvent> customEventQueue;
    protected Context context;

    public TuneAnalyticsManager(Context context) {
        this.context = context;
        this.state = TuneAnalyticsManagerState.NOT_TRACKING;
        this.sessionVariables = new HashSet<TuneAnalyticsVariable>();
        this.shouldQueueCustomEvents = true;
        this.customEventQueue = new LinkedList<TuneEvent>();
    }

    public synchronized void onEvent(TuneEventOccurred event) {
        TuneEvent tuneEvent = event.getEvent();
        if (this.shouldQueueCustomEvents()) {
            this.queueCustomEvent(tuneEvent);
        } else {
            TuneCustomEvent customEvent = new TuneCustomEvent(tuneEvent);
            this.storeAndTrackAnalyticsEvent(false, customEvent);
        }
    }

    private synchronized void queueCustomEvent(TuneEvent event) {
        this.customEventQueue.add(event);
    }

    private synchronized boolean shouldQueueCustomEvents() {
        return this.shouldQueueCustomEvents;
    }

    synchronized void setShouldQueueCustomEvents(Boolean newValue) {
        this.shouldQueueCustomEvents = newValue;
        if (!this.shouldQueueCustomEvents.booleanValue()) {
            for (TuneEvent event : this.customEventQueue) {
                TuneCustomEvent customEvent = new TuneCustomEvent(event);
                this.storeAndTrackAnalyticsEvent(false, customEvent);
            }
            this.customEventQueue.clear();
        }
    }

    public void onEvent(TuneActivityResumed event) {
        if (TuneManager.getInstance().getConfigurationManager().shouldSendScreenViews()) {
            String activityName = event.getActivityName();
            TuneScreenViewEvent screenViewEvent = new TuneScreenViewEvent(activityName);
            this.storeAndTrackAnalyticsEvent(false, screenViewEvent);
        }
    }

    public void onEvent(TuneAppForegrounded event) {
        this.setShouldQueueCustomEvents(false);
        TuneForegroundEvent foregroundEvent = new TuneForegroundEvent();
        this.storeAndTrackAnalyticsEvent(false, foregroundEvent);
        this.startScheduledDispatch();
    }

    public void onEvent(TuneAppBackgrounded event) {
        this.setShouldQueueCustomEvents(true);
        TuneBackgroundEvent backgroundEvent = new TuneBackgroundEvent();
        this.storeAndTrackAnalyticsEvent(false, backgroundEvent);
        this.stopScheduledDispatch();
        this.sessionVariables.clear();
    }

    public void onEvent(TuneCustomProfileVariablesCleared event) {
        TuneClearVariablesEvent tracerEvent = new TuneClearVariablesEvent(event);
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.execute(new DispatchTask().withCustomTracer(tracerEvent));
        } else {
            TuneManager.getInstance().getFileManager().writeAnalytics(tracerEvent);
        }
    }

    public void onEvent(TunePushOpened event) {
        TunePushMessage message = event.getMessage();
        this.storeAndTrackAnalyticsEvent(false, new TunePushOpenedEvent(message));
        this.storeAndTrackAnalyticsEvent(false, new TunePushActionEvent(message));
    }

    public void onEvent(TunePushEnabled event) {
        boolean status = event.isEnabled();
        this.storeAndTrackAnalyticsEvent(false, new TunePushEnabledEvent(status));
    }

    public void onEvent(TuneSessionVariableToSet event) {
        String variableName = event.getVariableName();
        String variableValue = event.getVariableValue();
        if (event.saveToAnalyticsManager()) {
            this.registerSessionVariable(variableName, variableValue);
        }
    }

    public synchronized void registerSessionVariable(String variableName, String variableValue) {
        TuneAnalyticsVariable newVariable = new TuneAnalyticsVariable(variableName, variableValue);
        this.sessionVariables.add(newVariable);
    }

    public synchronized void addSessionVariablesToEvent(TuneAnalyticsEventBase event) {
        HashSet<TuneAnalyticsVariable> finalTags = new HashSet<TuneAnalyticsVariable>(this.sessionVariables);
        finalTags.addAll(event.getTags());
        event.setTags(finalTags);
    }

    public boolean currentlyTrackingEvents() {
        return true;
    }

    public TuneAnalyticsManagerState getState() {
        return this.state;
    }

    public void setState(TuneAnalyticsManagerState state) {
        TuneDebugLog.d("TuneAnalyticsManager state set to " + state.toString());
        this.state = state;
    }

    public TuneAnalyticsListener getListener() {
        return this.listener;
    }

    public void setListener(TuneAnalyticsListener listener) {
        this.listener = listener;
    }

    public void storeAndTrackAnalyticsEvent(boolean force, TuneAnalyticsEventBase event) {
        this.addSessionVariablesToEvent(event);
        if (TuneManager.getInstance().getConnectedModeManager().isInConnectedMode()) {
            if (this.scheduler == null) {
                this.scheduler = new ScheduledThreadPoolExecutor(1);
            }
            if (!this.scheduler.isShutdown()) {
                this.scheduler.execute(new DispatchToConnectedModeTask(event));
            }
            return;
        }
        TuneManager.getInstance().getFileManager().writeAnalytics(event);
    }

    public TuneTracerEvent buildTracerEvent() {
        TuneTracerEvent tracer = new TuneTracerEvent();
        this.addSessionVariablesToEvent(tracer);
        return tracer;
    }

    public void startScheduledDispatch() {
        if (TuneManager.getInstance() == null || TuneManager.getInstance().getConfigurationManager().isTMADisabled()) {
            return;
        }
        TuneDebugLog.i("Starting Analytics Dispatching");
        if (this.scheduler == null) {
            this.scheduler = new ScheduledThreadPoolExecutor(1);
        }
        this.scheduler.scheduleAtFixedRate(new DispatchTask(), 0L, TuneManager.getInstance().getConfigurationManager().getAnalyticsDispatchPeriod(), TimeUnit.SECONDS);
    }

    public void stopScheduledDispatch() {
        if (this.scheduler != null) {
            TuneDebugLog.i("Stopping dispatch, flush remaining events!");
            this.scheduler.execute(new DispatchTask());
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    public Set<TuneAnalyticsVariable> getSessionVariables() {
        return this.sessionVariables;
    }

    private class DispatchToConnectedModeTask
    implements Runnable {
        private TuneAnalyticsEventBase event;

        public DispatchToConnectedModeTask(TuneAnalyticsEventBase event) {
            this.event = event;
        }

        @Override
        public void run() {
            try {
                boolean success;
                JSONObject eventsJson = new JSONObject().put(TuneAnalyticsManager.CONNECTED_EVENTS_KEY, (Object)this.event.toJson());
                if (TuneManager.getInstance().getConfigurationManager().echoAnalytics()) {
                    try {
                        TuneDebugLog.alwaysLog("Dispatching connected analytics event:\n" + TuneJsonUtils.ppAnalyticsEvent(this.event.toJson(), 0));
                    }
                    catch (Exception ex) {
                        TuneDebugLog.alwaysLog("Failed to build event for echo:" + ex);
                    }
                }
                if (!(success = TuneManager.getInstance().getApi().postConnectedAnalytics(eventsJson, TuneAnalyticsManager.this.listener))) {
                    TuneDebugLog.e("Failed to send connected Analytics");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private class DispatchTask
    implements Runnable {
        TuneTracerEvent customTracer;

        private DispatchTask() {
        }

        public DispatchTask withCustomTracer(TuneTracerEvent customTracer) {
            this.customTracer = customTracer;
            return this;
        }

        @Override
        public void run() {
            if (TuneManager.getInstance().getConnectedModeManager().isInConnectedMode() || TuneManager.getInstance().getConfigurationManager().isTMADisabled()) {
                return;
            }
            JSONArray events = TuneManager.getInstance().getFileManager().readAnalytics();
            if (this.customTracer == null) {
                events.put((Object)TuneAnalyticsManager.this.buildTracerEvent().toJson());
            } else {
                events.put((Object)this.customTracer.toJson());
            }
            if (TuneAnalyticsManager.this.listener != null) {
                TuneAnalyticsManager.this.listener.dispatchingRequest(events);
            }
            try {
                boolean success;
                JSONObject eventsJson = new JSONObject().put(TuneAnalyticsManager.ANALYTICS_EVENTS_KEY, (Object)events);
                if (TuneManager.getInstance().getConfigurationManager().echoAnalytics()) {
                    for (int i = 0; i < events.length(); ++i) {
                        try {
                            TuneDebugLog.alwaysLog(TuneStringUtils.format("Dispatching analytics event (%s/%s):\n%s", i + 1, events.length(), TuneJsonUtils.ppAnalyticsEvent(events.getJSONObject(i), 0)));
                            continue;
                        }
                        catch (Exception ex) {
                            TuneDebugLog.alwaysLog("Failed to build event for echo:" + ex);
                        }
                    }
                }
                if (success = TuneManager.getInstance().getApi().postAnalytics(eventsJson, TuneAnalyticsManager.this.listener)) {
                    TuneManager.getInstance().getFileManager().deleteAnalytics(events.length() - 1);
                } else {
                    TuneDebugLog.e("Failed to send Analytics, will try again on next interval.");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

