/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma;

import android.content.Context;
import com.tune.Tune;
import com.tune.http.Api;
import com.tune.http.TuneApi;
import com.tune.ma.TuneIAMNotEnabledException;
import com.tune.ma.analytics.TuneAnalyticsManager;
import com.tune.ma.campaign.TuneCampaignStateManager;
import com.tune.ma.configuration.TuneConfiguration;
import com.tune.ma.configuration.TuneConfigurationManager;
import com.tune.ma.connected.TuneConnectedModeManager;
import com.tune.ma.deepactions.TuneDeepActionManager;
import com.tune.ma.eventbus.TuneEventBus;
import com.tune.ma.eventbus.event.TuneManagerInitialized;
import com.tune.ma.experiments.TuneExperimentManager;
import com.tune.ma.file.FileManager;
import com.tune.ma.file.TuneFileManager;
import com.tune.ma.playlist.TunePlaylistManager;
import com.tune.ma.powerhooks.TunePowerHookManager;
import com.tune.ma.profile.TuneUserProfile;
import com.tune.ma.push.TunePushManager;
import com.tune.ma.session.TuneSessionManager;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneJSONPlayer;
import com.tune.ma.utils.TuneStringUtils;

public class TuneManager {
    private TuneAnalyticsManager analyticsManager;
    private TuneUserProfile profileManager;
    private TuneSessionManager sessionManager;
    private TuneConfigurationManager configurationManager;
    private TuneConnectedModeManager connectedModeManager;
    private TunePowerHookManager powerHookManager;
    private TunePlaylistManager playlistManager;
    private FileManager fileManager;
    private Api api;
    private TuneDeepActionManager deepActionManager;
    private TunePushManager pushManager;
    private TuneCampaignStateManager campaignStateManager;
    private TuneJSONPlayer configurationPlayer;
    private TuneJSONPlayer playlistPlayer;
    private TuneExperimentManager experimentManager;
    private static TuneManager instance = null;

    private TuneManager() {
    }

    public static TuneManager init(Context context, TuneConfiguration configuration) {
        if (instance == null) {
            instance = new TuneManager();
            TuneManager.instance.fileManager = new TuneFileManager(context);
            TuneManager.instance.api = new TuneApi();
            TuneManager.instance.configurationManager = new TuneConfigurationManager(context, configuration);
            if (TuneManager.instance.configurationManager.useConfigurationPlayer()) {
                TuneJSONPlayer configurationPlayer = new TuneJSONPlayer(context);
                configurationPlayer.setFiles(TuneManager.instance.configurationManager.getConfigurationPlayerFilenames());
                TuneManager.instance.configurationPlayer = configurationPlayer;
            }
            TuneManager.instance.powerHookManager = new TunePowerHookManager();
            TuneManager.instance.profileManager = new TuneUserProfile(context);
            TuneManager.instance.playlistManager = new TunePlaylistManager();
            TuneManager.instance.experimentManager = new TuneExperimentManager();
            if (!TuneManager.instance.configurationManager.isTMADisabled()) {
                TuneManager.instance.sessionManager = TuneSessionManager.init(context);
                TuneManager.instance.analyticsManager = new TuneAnalyticsManager(context);
                TuneManager.instance.connectedModeManager = new TuneConnectedModeManager(context);
                TuneManager.instance.deepActionManager = new TuneDeepActionManager();
                TuneManager.instance.pushManager = new TunePushManager(context);
                TuneManager.instance.campaignStateManager = new TuneCampaignStateManager(context);
                if (TuneManager.instance.configurationManager.usePlaylistPlayer()) {
                    TuneJSONPlayer playlistPlayer = new TuneJSONPlayer(context);
                    playlistPlayer.setFiles(TuneManager.instance.configurationManager.getPlaylistPlayerFilenames());
                    TuneManager.instance.playlistPlayer = playlistPlayer;
                }
                TuneEventBus.register(TuneManager.instance.campaignStateManager, 100);
                TuneEventBus.register(TuneManager.instance.sessionManager, 99);
                TuneEventBus.register(TuneManager.instance.profileManager, 98);
                TuneEventBus.register(TuneManager.instance.analyticsManager, 2);
                TuneEventBus.register(TuneManager.instance.configurationManager, 2);
                TuneEventBus.register(TuneManager.instance.connectedModeManager, 2);
                TuneEventBus.register(TuneManager.instance.playlistManager, 2);
                TuneEventBus.register(TuneManager.instance.deepActionManager);
                TuneEventBus.register(TuneManager.instance.experimentManager, 2);
                TuneEventBus.register(TuneManager.instance.pushManager);
                TuneEventBus.post(new TuneManagerInitialized());
            } else {
                TuneEventBus.disable();
            }
        }
        return instance;
    }

    public static void destroy() {
        if (instance != null) {
            TuneEventBus.unregister(TuneManager.instance.campaignStateManager);
            TuneEventBus.unregister(TuneManager.instance.sessionManager);
            TuneEventBus.unregister(TuneManager.instance.analyticsManager);
            TuneEventBus.unregister(TuneManager.instance.configurationManager);
            TuneEventBus.unregister(TuneManager.instance.connectedModeManager);
            TuneEventBus.unregister(TuneManager.instance.profileManager);
            TuneEventBus.unregister(TuneManager.instance.playlistManager);
            TuneEventBus.unregister(TuneManager.instance.powerHookManager);
            TuneEventBus.unregister(TuneManager.instance.deepActionManager);
            TuneEventBus.unregister(TuneManager.instance.experimentManager);
            TuneEventBus.unregister(TuneManager.instance.pushManager);
        }
        instance = null;
    }

    public static TuneManager getInstance() {
        return instance;
    }

    public Api getApi() {
        return this.api;
    }

    public void setApi(Api api) {
        this.api = api;
    }

    public TuneAnalyticsManager getAnalyticsManager() {
        return this.analyticsManager;
    }

    public TuneUserProfile getProfileManager() {
        return this.profileManager;
    }

    public TuneSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public TunePlaylistManager getPlaylistManager() {
        return this.playlistManager;
    }

    public TuneConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public TuneConnectedModeManager getConnectedModeManager() {
        return this.connectedModeManager;
    }

    public TunePowerHookManager getPowerHookManager() {
        return this.powerHookManager;
    }

    public TuneDeepActionManager getDeepActionManager() {
        return this.deepActionManager;
    }

    public TunePushManager getPushManager() {
        return this.pushManager;
    }

    public TuneJSONPlayer getConfigurationPlayer() {
        return this.configurationPlayer;
    }

    public TuneJSONPlayer getPlaylistPlayer() {
        return this.playlistPlayer;
    }

    public TuneExperimentManager getExperimentManager() {
        return this.experimentManager;
    }

    public static TunePowerHookManager getPowerHookManagerForUser(String methodName) {
        if (TuneManager.getInstance() == null || TuneManager.getInstance().getPowerHookManager() == null) {
            TuneManager.handleError(methodName);
            return null;
        }
        return TuneManager.getInstance().getPowerHookManager();
    }

    public static TuneDeepActionManager getDeepActionManagerForUser(String methodName) {
        if (TuneManager.getInstance() == null || TuneManager.getInstance().getDeepActionManager() == null) {
            TuneManager.handleError(methodName);
            return null;
        }
        return TuneManager.getInstance().getDeepActionManager();
    }

    public static TuneExperimentManager getExperimentManagerForUser(String methodName) {
        if (TuneManager.getInstance() == null || TuneManager.getInstance().getExperimentManager() == null) {
            TuneManager.handleError(methodName);
            return null;
        }
        return TuneManager.getInstance().getExperimentManager();
    }

    public static TunePlaylistManager getPlaylistManagerForUser(String methodName) {
        if (TuneManager.getInstance() == null || TuneManager.getInstance().getPlaylistManager() == null) {
            TuneManager.handleError(methodName);
            return null;
        }
        return TuneManager.getInstance().getPlaylistManager();
    }

    public static TuneUserProfile getProfileForUser(String methodName) {
        if (TuneManager.getInstance() == null || TuneManager.getInstance().getProfileManager() == null) {
            TuneManager.handleError(methodName);
            return null;
        }
        return TuneManager.getInstance().getProfileManager();
    }

    public static TunePushManager getPushManagerForUser(String methodName) {
        if (TuneManager.getInstance() == null || TuneManager.getInstance().getPushManager() == null) {
            TuneManager.handleError(methodName);
            return null;
        }
        return TuneManager.getInstance().getPushManager();
    }

    public static void handleError(String methodName) {
        String message = TuneStringUtils.format("In order to use the method '%s' you must have IAM enabled. See: https://developers.mobileapptracking.com/requirements-for-in-app-marketing/", methodName);
        if (Tune.getInstance().isInDebugMode()) {
            throw new TuneIAMNotEnabledException(message);
        }
        TuneDebugLog.e(message);
    }
}

