/*
 * Decompiled with CFR 0.152.
 */
package com.tune.location;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.tune.TuneUtils;
import com.tune.ma.utils.TuneDebugLog;
import java.util.Timer;
import java.util.TimerTask;

public class TuneLocationListener
implements LocationListener {
    private static final int LISTENER_TIMEOUT = 30000;
    private static final int LOCATION_VALIDITY_DURATION = 120000;
    private static final long MIN_TIME_BETWEEN_UPDATES = 5000L;
    private static final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 10L;
    private static final int DESIRED_ACCURACY = 1000;
    private Context context;
    private LocationManager locationManager;
    private Location lastLocation;
    private Timer timer;
    private boolean listening;

    public TuneLocationListener(Context context) {
        this.context = context;
        this.locationManager = (LocationManager)context.getSystemService("location");
    }

    public boolean isLocationEnabled() {
        return TuneUtils.hasPermission(this.context, "android.permission.ACCESS_FINE_LOCATION") || TuneUtils.hasPermission(this.context, "android.permission.ACCESS_COARSE_LOCATION");
    }

    public boolean isProviderEnabled() {
        boolean gpsEnabled = false;
        boolean networkEnabled = false;
        try {
            gpsEnabled = this.locationManager.isProviderEnabled("gps");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            networkEnabled = this.locationManager.isProviderEnabled("network");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gpsEnabled || networkEnabled;
    }

    public Location getLastLocation() {
        if (!(this.lastLocation != null && System.currentTimeMillis() - this.lastLocation.getTime() <= 120000L || this.listening)) {
            TuneDebugLog.d("Last location is null or outdated");
            this.startListening();
        }
        return this.lastLocation;
    }

    public void startListening() {
        if (!this.isLocationEnabled()) {
            return;
        }
        if (!this.isProviderEnabled()) {
            TuneDebugLog.d("No location providers, device needs to turn on location");
            return;
        }
        if (this.listening) {
            return;
        }
        this.listening = true;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post((Runnable)new GetLocationUpdates(this));
    }

    public void stopListening() {
        TuneDebugLog.d("Stopping listening of location updates");
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.locationManager.removeUpdates((LocationListener)this);
        this.listening = false;
    }

    public boolean isListening() {
        return this.listening;
    }

    protected boolean isBetterLocation(Location location, Location currentBestLocation) {
        boolean isNewer;
        if (currentBestLocation == null) {
            return true;
        }
        long timeDelta = location.getTime() - currentBestLocation.getTime();
        boolean isSignificantlyNewer = timeDelta > 120000L;
        boolean isSignificantlyOlder = timeDelta < -120000L;
        boolean bl = isNewer = timeDelta > 0L;
        if (isSignificantlyNewer) {
            return true;
        }
        if (isSignificantlyOlder) {
            return false;
        }
        int accuracyDelta = (int)(location.getAccuracy() - currentBestLocation.getAccuracy());
        boolean isLessAccurate = accuracyDelta > 0;
        boolean isMoreAccurate = accuracyDelta < 0;
        boolean isSignificantlyLessAccurate = accuracyDelta > 200;
        boolean isFromSameProvider = this.isSameProvider(location.getProvider(), currentBestLocation.getProvider());
        if (isMoreAccurate) {
            return true;
        }
        if (isNewer && !isLessAccurate) {
            return true;
        }
        return isNewer && !isSignificantlyLessAccurate && isFromSameProvider;
    }

    private boolean isSameProvider(String provider1, String provider2) {
        if (provider1 == null) {
            return provider2 == null;
        }
        return provider1.equals(provider2);
    }

    public void onLocationChanged(Location location) {
        if (location != null) {
            TuneDebugLog.d("Received new location " + location.toString());
            if (this.isBetterLocation(location, this.lastLocation)) {
                TuneDebugLog.d("New location is better, saving");
                this.lastLocation = location;
            }
            if (location.getAccuracy() <= 1000.0f) {
                this.stopListening();
            }
        }
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onProviderDisabled(String provider) {
    }

    private class GetLocationUpdates
    implements Runnable {
        private LocationListener listener;

        public GetLocationUpdates(LocationListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            boolean hasCoarseLocationPermission;
            TuneDebugLog.d("Listening for location updates");
            boolean hasFineLocationPermission = TuneUtils.hasPermission(TuneLocationListener.this.context, "android.permission.ACCESS_FINE_LOCATION");
            if (hasFineLocationPermission && TuneLocationListener.this.locationManager.isProviderEnabled("gps")) {
                if (TuneLocationListener.this.lastLocation == null) {
                    TuneLocationListener.this.lastLocation = TuneLocationListener.this.locationManager.getLastKnownLocation("gps");
                }
                TuneLocationListener.this.locationManager.requestLocationUpdates("gps", 5000L, 10.0f, this.listener);
            }
            boolean hasNetworkProviderPermissions = hasCoarseLocationPermission = TuneUtils.hasPermission(TuneLocationListener.this.context, "android.permission.ACCESS_COARSE_LOCATION");
            if (Build.VERSION.SDK_INT < 23) {
                boolean bl = hasNetworkProviderPermissions = hasCoarseLocationPermission && hasFineLocationPermission;
            }
            if (hasNetworkProviderPermissions && TuneLocationListener.this.locationManager.isProviderEnabled("network")) {
                if (TuneLocationListener.this.lastLocation == null) {
                    TuneLocationListener.this.lastLocation = TuneLocationListener.this.locationManager.getLastKnownLocation("network");
                }
                TuneLocationListener.this.locationManager.requestLocationUpdates("network", 5000L, 10.0f, this.listener);
            }
            TuneLocationListener.this.timer = new Timer();
            TuneLocationListener.this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    TuneDebugLog.d("Location timer timed out");
                    TuneLocationListener.this.stopListening();
                }
            }, 30000L);
        }
    }
}

