/*
 * Decompiled with CFR 0.152.
 */
package com.tune.http;

import com.tune.TuneDeeplinkListener;
import com.tune.TuneUtils;
import com.tune.http.UrlRequester;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class TuneUrlRequester
implements UrlRequester {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestDeeplink(String deeplinkURL, String conversionKey, TuneDeeplinkListener listener) {
        if (listener == null) {
            return;
        }
        InputStream is = null;
        try {
            URL myurl = new URL(deeplinkURL);
            HttpURLConnection conn = (HttpURLConnection)myurl.openConnection();
            conn.setRequestProperty("X-MAT-Key", conversionKey);
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.connect();
            boolean error = false;
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                is = conn.getInputStream();
            } else {
                error = true;
                is = conn.getErrorStream();
            }
            String response = TuneUtils.readStream(is);
            if (error) {
                listener.didFailDeeplink(response);
            } else {
                listener.didReceiveDeeplink(response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject requestUrl(String url, JSONObject json, boolean debugMode) {
        InputStream is = null;
        try {
            URL myurl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)myurl.openConnection();
            conn.setReadTimeout(60000);
            conn.setConnectTimeout(60000);
            conn.setDoInput(true);
            if (json == null || json.length() == 0) {
                conn.setRequestMethod("GET");
            } else {
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("Accept", "application/json");
                conn.setRequestMethod("POST");
                OutputStream os = conn.getOutputStream();
                os.write(json.toString().getBytes("UTF-8"));
                os.close();
            }
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (debugMode) {
                TuneUtils.log("Request completed with status " + responseCode);
            }
            is = responseCode == 200 ? conn.getInputStream() : conn.getErrorStream();
            String responseAsString = TuneUtils.readStream(is);
            if (debugMode) {
                TuneUtils.log("Server response: " + responseAsString);
            }
            JSONObject responseJson = new JSONObject();
            try {
                JSONTokener tokener = new JSONTokener(responseAsString);
                responseJson = new JSONObject(tokener);
                if (debugMode) {
                    TuneUrlRequester.logResponse(responseJson);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String matResponderHeader = conn.getHeaderField("X-MAT-Responder");
            if (responseCode >= 200 && responseCode < 300) {
                JSONObject jSONObject = responseJson;
                return jSONObject;
            }
            if (responseCode == 400 && matResponderHeader != null) {
                if (debugMode) {
                    TuneUtils.log("Request received 400 error from TUNE server, won't be retried");
                }
                JSONObject jSONObject = null;
                return jSONObject;
            }
        }
        catch (Exception e) {
            if (debugMode) {
                TuneUtils.log("Request error with URL " + url);
            }
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new JSONObject();
    }

    private static void logResponse(JSONObject response) {
        if (response.length() > 0) {
            try {
                JSONObject options;
                if (response.has("errors") && response.getJSONArray("errors").length() != 0) {
                    String errorMsg = response.getJSONArray("errors").getString(0);
                    TuneUtils.log("Event was rejected by server with error: " + errorMsg);
                } else if (response.has("log_action") && !response.getString("log_action").equals("null") && !response.getString("log_action").equals("false") && !response.getString("log_action").equals("true")) {
                    JSONObject conversion;
                    JSONObject logAction = response.getJSONObject("log_action");
                    if (logAction.has("conversion") && (conversion = logAction.getJSONObject("conversion")).has("status")) {
                        String status = conversion.getString("status");
                        if (status.equals("rejected")) {
                            String statusCode = conversion.getString("status_code");
                            TuneUtils.log("Event was rejected by server: status code " + statusCode);
                        } else {
                            TuneUtils.log("Event was accepted by server");
                        }
                    }
                } else if (response.has("options") && (options = response.getJSONObject("options")).has("conversion_status")) {
                    String conversionStatus = options.getString("conversion_status");
                    TuneUtils.log("Event was " + conversionStatus + " by server");
                }
            }
            catch (JSONException e) {
                TuneUtils.log("Server response status could not be parsed");
                e.printStackTrace();
            }
        }
    }
}

