/*
 * Decompiled with CFR 0.152.
 */
package com.tune.http;

import android.net.Uri;
import com.tune.TuneUtils;
import com.tune.http.Api;
import com.tune.ma.TuneManager;
import com.tune.ma.analytics.model.TuneAnalyticsListener;
import com.tune.ma.configuration.TuneConfigurationManager;
import com.tune.ma.profile.TuneUserProfile;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneStringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneApi
implements Api {
    private static final String BOUNDARY = "thisIsMyFileBoundary";
    private static final int TIMEOUT = 60000;
    private static final String CONFIG_ENDPOINT_TEMPLATE = "/sdk_api/%s/apps/%s/configuration";
    private static final String PLAYLIST_ENDPOINT_TEMPLATE = "/sdk_api/%s/apps/%s/devices/%s/playlist";
    private static final String CONNECT_ENDPOINT_TEMPLATE = "/sdk_api/%s/apps/%s/devices/%s/connect";
    private static final String DISCONNECT_ENDPOINT_TEMPLATE = "/sdk_api/%s/apps/%s/devices/%s/disconnect";
    private static final String DISCOVERY_ENDPOINT_TEMPLATE = "/sdk_api/%s/apps/%s/devices/%s/discovery";
    private static final String SYNC_ENDPOINT_TEMPLATE = "/sdk_api/%s/apps/%s/sync";
    private static final String CONNECTED_PLAYLIST_ENDPOINT_TEMPLATE = "/sdk_api/%s/apps/%s/devices/%s/connected_playlist";
    private static final String REQUEST_METHOD_GET = "GET";
    private static final String REQUEST_METHOD_POST = "POST";
    private static final String APP_ID_HEADER = "X-ARTISAN-APPID";
    private static final String DEVICE_ID_HEADER = "X-ARTISAN-DEVICEID";
    private static final String SDK_VERSION_HEADER = "X-TUNE-SDKVERSION";
    private static final String APP_VERSION_HEADER = "X-TUNE-APPVERSION";
    private static final String OS_VERSION_HEADER = "X-TUNE-OSVERSION";
    private static final String OS_TYPE_HEADER = "X-TUNE-OSTYPE";
    private static final String TAG = "TuneHttp";

    @Override
    public JSONObject getPlaylist() {
        return this.getPlaylistBase(PLAYLIST_ENDPOINT_TEMPLATE);
    }

    @Override
    public JSONObject getConfiguration() {
        JSONObject response = null;
        Uri.Builder builder = new Uri.Builder();
        TuneConfigurationManager configManager = TuneManager.getInstance().getConfigurationManager();
        TuneUserProfile profileManager = TuneManager.getInstance().getProfileManager();
        builder.encodedPath(TuneStringUtils.format(CONFIG_ENDPOINT_TEMPLATE, configManager.getApiVersion(), profileManager.getAppId()));
        builder.appendQueryParameter("osVersion", profileManager.getProfileVariableValue("os_version"));
        builder.appendQueryParameter("appVersion", profileManager.getProfileVariableValue("app_version"));
        builder.appendQueryParameter("sdkVersion", profileManager.getProfileVariableValue("sdk_version"));
        builder.appendQueryParameter("matId", profileManager.getProfileVariableValue("mat_id"));
        builder.appendQueryParameter("GAID", profileManager.getProfileVariableValue("google_aid"));
        String pathWithQuery = builder.build().toString();
        String configHostPort = TuneManager.getInstance().getConfigurationManager().getConfigurationHostPort();
        HttpURLConnection urlConnection = this.buildUrlConnection(configHostPort + pathWithQuery, REQUEST_METHOD_GET);
        urlConnection.setRequestProperty("Accept", "application/json");
        if (urlConnection != null) {
            response = this.sendRequestAndReadResponse(urlConnection);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postAnalytics(JSONObject events, TuneAnalyticsListener listener) {
        boolean result = false;
        HttpURLConnection urlConnection = null;
        String analyticsHostPort = TuneManager.getInstance().getConfigurationManager().getAnalyticsHostPort();
        try {
            byte[] data = this.zipAndEncodeData(events.toString(), BOUNDARY);
            urlConnection = this.buildUrlConnection(analyticsHostPort, REQUEST_METHOD_POST);
            if (urlConnection != null) {
                urlConnection.setDoOutput(true);
                urlConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=thisIsMyFileBoundary");
                urlConnection.setRequestProperty("Content-Encoding", "gzip");
                urlConnection.setRequestProperty("Content-Length", Integer.toString(data.length));
                OutputStream os = urlConnection.getOutputStream();
                os.write(data);
                os.close();
                int responseCode = urlConnection.getResponseCode();
                TuneDebugLog.d("Analytics sent with response code " + responseCode);
                if (responseCode == 200) {
                    result = true;
                } else {
                    TuneDebugLog.e("Analytics failed w/ response code: " + responseCode);
                }
                if (listener != null) {
                    listener.didCompleteRequest(responseCode);
                }
            }
        }
        catch (ConnectException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postConnectedAnalytics(JSONObject event, TuneAnalyticsListener listener) {
        boolean result = false;
        TuneConfigurationManager configManager = TuneManager.getInstance().getConfigurationManager();
        TuneUserProfile profile = TuneManager.getInstance().getProfileManager();
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.encodedPath(TuneStringUtils.format(DISCOVERY_ENDPOINT_TEMPLATE, configManager.getApiVersion(), profile.getAppId(), profile.getDeviceId()));
        String path = uriBuilder.build().toString();
        HttpURLConnection urlConnection = null;
        try {
            byte[] data = event.toString().getBytes();
            urlConnection = this.buildUrlConnection(configManager.getConnectedModeHostPort() + path, REQUEST_METHOD_POST);
            if (urlConnection != null) {
                urlConnection.setDoOutput(true);
                urlConnection.setRequestProperty("Accept", "application/json");
                urlConnection.setRequestProperty("Content-Type", "application/json");
                urlConnection.setRequestProperty("Content-Length", Integer.toString(data.length));
                OutputStream os = urlConnection.getOutputStream();
                os.write(data);
                os.close();
                int responseCode = urlConnection.getResponseCode();
                TuneDebugLog.d("Connected Analytics sent with response code " + responseCode);
                if (responseCode == 200) {
                    result = true;
                } else {
                    TuneDebugLog.e("Connected Analytics failed w/ response code: " + responseCode);
                }
                if (listener != null) {
                    listener.didCompleteRequest(responseCode);
                }
            }
        }
        catch (ConnectException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postConnect() {
        boolean result = false;
        TuneConfigurationManager configManager = TuneManager.getInstance().getConfigurationManager();
        TuneUserProfile profile = TuneManager.getInstance().getProfileManager();
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.encodedPath(TuneStringUtils.format(CONNECT_ENDPOINT_TEMPLATE, configManager.getApiVersion(), profile.getAppId(), profile.getDeviceId()));
        String path = uriBuilder.build().toString();
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = this.buildUrlConnection(configManager.getConnectedModeHostPort() + path, REQUEST_METHOD_POST);
            if (urlConnection != null) {
                urlConnection.setRequestProperty("Accept", "application/json");
                urlConnection.setRequestProperty("Content-Type", "application/json");
                int responseCode = urlConnection.getResponseCode();
                TuneDebugLog.d("Connect sent with response code " + responseCode);
                if (responseCode == 200) {
                    result = true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postDisconnect() {
        TuneConfigurationManager configManager = TuneManager.getInstance().getConfigurationManager();
        TuneUserProfile profile = TuneManager.getInstance().getProfileManager();
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.encodedPath(TuneStringUtils.format(DISCONNECT_ENDPOINT_TEMPLATE, configManager.getApiVersion(), profile.getAppId(), profile.getDeviceId()));
        String path = uriBuilder.build().toString();
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = this.buildUrlConnection(configManager.getConnectedModeHostPort() + path, REQUEST_METHOD_POST);
            if (urlConnection != null) {
                urlConnection.setRequestProperty("Accept", "application/json");
                urlConnection.setRequestProperty("Content-Type", "application/json");
                int responseCode = urlConnection.getResponseCode();
                TuneDebugLog.d("Disconnect sent with response code " + responseCode);
                if (responseCode == 200) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postSync(JSONObject syncObject) {
        boolean result = false;
        TuneConfigurationManager configManager = TuneManager.getInstance().getConfigurationManager();
        TuneUserProfile profile = TuneManager.getInstance().getProfileManager();
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.encodedPath(TuneStringUtils.format(SYNC_ENDPOINT_TEMPLATE, configManager.getApiVersion(), profile.getAppId()));
        String path = uriBuilder.build().toString();
        HttpURLConnection urlConnection = null;
        try {
            byte[] data = syncObject.toString().getBytes();
            urlConnection = this.buildUrlConnection(configManager.getConnectedModeHostPort() + path, REQUEST_METHOD_POST);
            if (urlConnection != null) {
                urlConnection.setDoOutput(true);
                urlConnection.setRequestProperty("Accept", "application/json");
                urlConnection.setRequestProperty("Content-Type", "application/json");
                urlConnection.setRequestProperty("Content-Length", Integer.toString(data.length));
                OutputStream os = urlConnection.getOutputStream();
                os.write(data);
                os.close();
                int responseCode = urlConnection.getResponseCode();
                TuneDebugLog.d("Sync sent with response code " + responseCode);
                if (responseCode == 200) {
                    result = true;
                } else {
                    TuneDebugLog.e("Sync failed w/ response code: " + responseCode);
                }
            }
        }
        catch (ConnectException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return result;
    }

    @Override
    public JSONObject getConnectedPlaylist() {
        return this.getPlaylistBase(CONNECTED_PLAYLIST_ENDPOINT_TEMPLATE);
    }

    private JSONObject getPlaylistBase(String endpoint) {
        TuneConfigurationManager configManager = TuneManager.getInstance().getConfigurationManager();
        TuneUserProfile profile = TuneManager.getInstance().getProfileManager();
        JSONObject response = null;
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.encodedPath(TuneStringUtils.format(endpoint, configManager.getApiVersion(), profile.getAppId(), profile.getDeviceId()));
        String path = uriBuilder.build().toString();
        HttpURLConnection urlConnection = this.buildUrlConnection(configManager.getPlaylistHostPort() + path, REQUEST_METHOD_GET);
        urlConnection.setRequestProperty("Accept", "application/json");
        if (urlConnection != null) {
            response = this.sendRequestAndReadResponse(urlConnection);
        }
        return response;
    }

    private HttpURLConnection buildUrlConnection(String hostPort, String requestMethod) {
        HttpURLConnection urlConnection = null;
        URL url = null;
        try {
            url = new URL(hostPort);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setReadTimeout(60000);
            urlConnection.setConnectTimeout(60000);
            urlConnection.setDoInput(true);
            TuneUserProfile profileManager = TuneManager.getInstance().getProfileManager();
            urlConnection.setRequestProperty(DEVICE_ID_HEADER, profileManager.getDeviceId());
            urlConnection.setRequestProperty(APP_ID_HEADER, profileManager.getAppId());
            urlConnection.setRequestProperty(SDK_VERSION_HEADER, "4.9.0");
            urlConnection.setRequestProperty(APP_VERSION_HEADER, profileManager.getProfileVariableValue("app_version"));
            urlConnection.setRequestProperty(OS_VERSION_HEADER, profileManager.getProfileVariableValue("apiLevel"));
            urlConnection.setRequestProperty(OS_TYPE_HEADER, profileManager.getProfileVariableValue("os_type"));
            urlConnection.setRequestMethod(requestMethod);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return urlConnection;
    }

    private byte[] zipAndEncodeData(String uncompressedString, String boundary) throws IOException {
        byte[] compressed = TuneUtils.compress(uncompressedString);
        byte[] outputBuffer = TuneStringUtils.format("--%s\r\n", boundary).getBytes();
        String wrapperString = TuneStringUtils.format("Content-Disposition: form-data; name=\"%s\"; filename=\"analytics.gzip\"\r\n", "analytics");
        outputBuffer = TuneUtils.concatenateByteArrays(outputBuffer, wrapperString.getBytes());
        wrapperString = "Content-Type: application/gzip\r\n\r\n";
        outputBuffer = TuneUtils.concatenateByteArrays(outputBuffer, wrapperString.getBytes());
        outputBuffer = TuneUtils.concatenateByteArrays(outputBuffer, compressed);
        wrapperString = "\r\n";
        outputBuffer = TuneUtils.concatenateByteArrays(outputBuffer, wrapperString.getBytes());
        wrapperString = TuneStringUtils.format("--%s--\r\n", boundary);
        outputBuffer = TuneUtils.concatenateByteArrays(outputBuffer, wrapperString.getBytes());
        return outputBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject sendRequestAndReadResponse(HttpURLConnection connection) {
        String response = null;
        JSONObject responseJson = null;
        InputStream stream = null;
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                stream = connection.getErrorStream();
                TuneDebugLog.e(TAG, TuneStringUtils.format("Sending Request to %s failed with %s:\n%s", connection.getURL(), responseCode, TuneUtils.readStream(stream)));
                JSONObject jSONObject = responseJson;
                return jSONObject;
            }
            stream = connection.getInputStream();
            response = TuneUtils.readStream(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            TuneDebugLog.e(TAG, TuneStringUtils.format("Sending Request to %s caused IO exception.", connection.getURL()));
        }
        finally {
            connection.disconnect();
        }
        if (response != null) {
            try {
                responseJson = new JSONObject(response);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return responseJson;
    }
}

