/*
 * Decompiled with CFR 0.152.
 */
package com.tune;

import android.net.Uri;
import android.util.Log;
import com.tune.TuneEncryption;
import com.tune.TuneEvent;
import com.tune.TuneLocation;
import com.tune.TuneParameters;
import com.tune.TunePreloadData;
import com.tune.TuneUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class TuneUrlBuilder {
    private static TuneParameters params;

    TuneUrlBuilder() {
    }

    public static String appendTuneLinkParameters(String clickedTuneLinkUrl) {
        params = TuneParameters.getInstance();
        Uri uri = Uri.parse((String)clickedTuneLinkUrl);
        Uri.Builder builder = uri.buildUpon();
        builder.appendQueryParameter("mat_id", params.getMatId());
        if (!"json".equals(uri.getQueryParameter("response_format"))) {
            builder.appendQueryParameter("response_format", "json");
        }
        builder.appendQueryParameter("action", "click");
        return builder.toString();
    }

    public static String buildLink(TuneEvent eventData, TunePreloadData preloaded, boolean debugMode) {
        params = TuneParameters.getInstance();
        StringBuilder link = new StringBuilder("https://").append(params.getAdvertiserId()).append(".");
        if (debugMode) {
            link.append("debug.engine.mobileapptracking.com");
        } else {
            link.append("engine.mobileapptracking.com");
        }
        link.append("/serve?");
        link.append("ver=").append(params.getSdkVersion());
        link.append("&transaction_id=").append(UUID.randomUUID().toString());
        link.append("&sdk_retry_attempt=0");
        TuneUrlBuilder.safeAppend(link, "sdk", "android");
        TuneUrlBuilder.safeAppend(link, "action", params.getAction());
        TuneUrlBuilder.safeAppend(link, "advertiser_id", params.getAdvertiserId());
        TuneUrlBuilder.safeAppend(link, "package_name", params.getPackageName());
        TuneUrlBuilder.safeAppend(link, "referral_source", params.getReferralSource());
        TuneUrlBuilder.safeAppend(link, "referral_url", params.getReferralUrl());
        TuneUrlBuilder.safeAppend(link, "tracking_id", params.getTrackingId());
        if (eventData.getEventId() != 0) {
            TuneUrlBuilder.safeAppend(link, "site_event_id", Integer.toString(eventData.getEventId()));
        }
        if (!"session".equals(params.getAction()) && !"click".equals(params.getAction())) {
            TuneUrlBuilder.safeAppend(link, "site_event_name", eventData.getEventName());
        }
        if (preloaded != null) {
            link.append("&attr_set=1");
            TuneUrlBuilder.safeAppend(link, "publisher_id", preloaded.publisherId);
            TuneUrlBuilder.safeAppend(link, "offer_id", preloaded.offerId);
            TuneUrlBuilder.safeAppend(link, "agency_id", preloaded.agencyId);
            TuneUrlBuilder.safeAppend(link, "publisher_ref_id", preloaded.publisherReferenceId);
            TuneUrlBuilder.safeAppend(link, "publisher_sub_publisher", preloaded.publisherSubPublisher);
            TuneUrlBuilder.safeAppend(link, "publisher_sub_site", preloaded.publisherSubSite);
            TuneUrlBuilder.safeAppend(link, "publisher_sub_campaign", preloaded.publisherSubCampaign);
            TuneUrlBuilder.safeAppend(link, "publisher_sub_adgroup", preloaded.publisherSubAdgroup);
            TuneUrlBuilder.safeAppend(link, "publisher_sub_ad", preloaded.publisherSubAd);
            TuneUrlBuilder.safeAppend(link, "publisher_sub_keyword", preloaded.publisherSubKeyword);
            TuneUrlBuilder.safeAppend(link, "publisher_sub1", preloaded.publisherSub1);
            TuneUrlBuilder.safeAppend(link, "publisher_sub2", preloaded.publisherSub2);
            TuneUrlBuilder.safeAppend(link, "publisher_sub3", preloaded.publisherSub3);
            TuneUrlBuilder.safeAppend(link, "publisher_sub4", preloaded.publisherSub4);
            TuneUrlBuilder.safeAppend(link, "publisher_sub5", preloaded.publisherSub5);
            TuneUrlBuilder.safeAppend(link, "advertiser_sub_publisher", preloaded.advertiserSubPublisher);
            TuneUrlBuilder.safeAppend(link, "advertiser_sub_site", preloaded.advertiserSubSite);
            TuneUrlBuilder.safeAppend(link, "advertiser_sub_campaign", preloaded.advertiserSubCampaign);
            TuneUrlBuilder.safeAppend(link, "advertiser_sub_adgroup", preloaded.advertiserSubAdgroup);
            TuneUrlBuilder.safeAppend(link, "advertiser_sub_ad", preloaded.advertiserSubAd);
            TuneUrlBuilder.safeAppend(link, "advertiser_sub_keyword", preloaded.advertiserSubKeyword);
        }
        if (debugMode) {
            link.append("&debug=1");
        }
        return link.toString();
    }

    public static synchronized String buildDataUnencrypted(TuneEvent eventData) {
        params = TuneParameters.getInstance();
        StringBuilder link = new StringBuilder();
        link.append("connection_type=" + params.getConnectionType());
        TuneUrlBuilder.safeAppend(link, "android_id", params.getAndroidId());
        TuneUrlBuilder.safeAppend(link, "android_id_md5", params.getAndroidIdMd5());
        TuneUrlBuilder.safeAppend(link, "android_id_sha1", params.getAndroidIdSha1());
        TuneUrlBuilder.safeAppend(link, "android_id_sha256", params.getAndroidIdSha256());
        TuneUrlBuilder.safeAppend(link, "app_ad_tracking", params.getAppAdTrackingEnabled());
        TuneUrlBuilder.safeAppend(link, "app_name", params.getAppName());
        TuneUrlBuilder.safeAppend(link, "app_version", params.getAppVersion());
        TuneUrlBuilder.safeAppend(link, "app_version_name", params.getAppVersionName());
        TuneUrlBuilder.safeAppend(link, "country_code", params.getCountryCode());
        TuneUrlBuilder.safeAppend(link, "device_brand", params.getDeviceBrand());
        TuneUrlBuilder.safeAppend(link, "build", params.getDeviceBuild());
        TuneUrlBuilder.safeAppend(link, "device_carrier", params.getDeviceCarrier());
        TuneUrlBuilder.safeAppend(link, "device_cpu_type", params.getDeviceCpuType());
        TuneUrlBuilder.safeAppend(link, "device_cpu_subtype", params.getDeviceCpuSubtype());
        TuneUrlBuilder.safeAppend(link, "device_model", params.getDeviceModel());
        TuneUrlBuilder.safeAppend(link, "device_id", params.getDeviceId());
        TuneUrlBuilder.safeAppend(link, "fire_aid", params.getFireAdvertisingId());
        TuneUrlBuilder.safeAppend(link, "fire_ad_tracking_disabled", params.getFireAdTrackingLimited());
        TuneUrlBuilder.safeAppend(link, "google_aid", params.getGoogleAdvertisingId());
        TuneUrlBuilder.safeAppend(link, "google_ad_tracking_disabled", params.getGoogleAdTrackingLimited());
        TuneUrlBuilder.safeAppend(link, "insdate", params.getInstallDate());
        TuneUrlBuilder.safeAppend(link, "installer", params.getInstaller());
        TuneUrlBuilder.safeAppend(link, "install_referrer", params.getInstallReferrer());
        TuneUrlBuilder.safeAppend(link, "language", params.getLanguage());
        TuneUrlBuilder.safeAppend(link, "last_open_log_id", params.getLastOpenLogId());
        if (params.getLocation() != null) {
            TuneUrlBuilder.safeAppend(link, "altitude", Double.toString(params.getLocation().getAltitude()));
            TuneUrlBuilder.safeAppend(link, "latitude", Double.toString(params.getLocation().getLatitude()));
            TuneUrlBuilder.safeAppend(link, "longitude", Double.toString(params.getLocation().getLongitude()));
        } else {
            TuneUrlBuilder.safeAppend(link, "altitude", params.getAltitude());
            TuneUrlBuilder.safeAppend(link, "latitude", params.getLatitude());
            TuneUrlBuilder.safeAppend(link, "longitude", params.getLongitude());
        }
        TuneUrlBuilder.safeAppend(link, "locale", params.getLocale());
        TuneUrlBuilder.safeAppend(link, "mac_address", params.getMacAddress());
        TuneUrlBuilder.safeAppend(link, "mat_id", params.getMatId());
        TuneUrlBuilder.safeAppend(link, "mobile_country_code", params.getMCC());
        TuneUrlBuilder.safeAppend(link, "mobile_network_code", params.getMNC());
        TuneUrlBuilder.safeAppend(link, "open_log_id", params.getOpenLogId());
        TuneUrlBuilder.safeAppend(link, "os_version", params.getOsVersion());
        TuneUrlBuilder.safeAppend(link, "sdk_plugin", params.getPluginName());
        TuneUrlBuilder.safeAppend(link, "android_purchase_status", params.getPurchaseStatus());
        TuneUrlBuilder.safeAppend(link, "referrer_delay", params.getReferrerDelay());
        TuneUrlBuilder.safeAppend(link, "screen_density", params.getScreenDensity());
        TuneUrlBuilder.safeAppend(link, "screen_layout_size", params.getScreenWidth() + "x" + params.getScreenHeight());
        TuneUrlBuilder.safeAppend(link, "sdk_version", params.getSdkVersion());
        TuneUrlBuilder.safeAppend(link, "truste_tpid", params.getTRUSTeId());
        TuneUrlBuilder.safeAppend(link, "conversion_user_agent", params.getUserAgent());
        TuneUrlBuilder.safeAppend(link, "attribute_sub1", eventData.getAttribute1());
        TuneUrlBuilder.safeAppend(link, "attribute_sub2", eventData.getAttribute2());
        TuneUrlBuilder.safeAppend(link, "attribute_sub3", eventData.getAttribute3());
        TuneUrlBuilder.safeAppend(link, "attribute_sub4", eventData.getAttribute4());
        TuneUrlBuilder.safeAppend(link, "attribute_sub5", eventData.getAttribute5());
        TuneUrlBuilder.safeAppend(link, "content_id", eventData.getContentId());
        TuneUrlBuilder.safeAppend(link, "content_type", eventData.getContentType());
        if (eventData.getCurrencyCode() != null) {
            TuneUrlBuilder.safeAppend(link, "currency_code", eventData.getCurrencyCode());
        } else {
            TuneUrlBuilder.safeAppend(link, "currency_code", params.getCurrencyCode());
        }
        if (eventData.getDate1() != null) {
            TuneUrlBuilder.safeAppend(link, "date1", Long.toString(eventData.getDate1().getTime() / 1000L));
        }
        if (eventData.getDate2() != null) {
            TuneUrlBuilder.safeAppend(link, "date2", Long.toString(eventData.getDate2().getTime() / 1000L));
        }
        if (eventData.getDeviceForm() != null) {
            TuneUrlBuilder.safeAppend(link, "device_form", eventData.getDeviceForm());
        }
        if (eventData.getLevel() != 0) {
            TuneUrlBuilder.safeAppend(link, "level", Integer.toString(eventData.getLevel()));
        }
        if (eventData.getQuantity() != 0) {
            TuneUrlBuilder.safeAppend(link, "quantity", Integer.toString(eventData.getQuantity()));
        }
        if (eventData.getRating() != 0.0) {
            TuneUrlBuilder.safeAppend(link, "rating", Double.toString(eventData.getRating()));
        }
        TuneUrlBuilder.safeAppend(link, "advertiser_ref_id", eventData.getRefId());
        TuneUrlBuilder.safeAppend(link, "revenue", Double.toString(eventData.getRevenue()));
        TuneUrlBuilder.safeAppend(link, "search_string", eventData.getSearchString());
        TuneUrlBuilder.safeAppend(link, "age", params.getAge());
        TuneUrlBuilder.safeAppend(link, "existing_user", params.getExistingUser());
        TuneUrlBuilder.safeAppend(link, "facebook_user_id", params.getFacebookUserId());
        TuneUrlBuilder.safeAppend(link, "gender", params.getGender());
        TuneUrlBuilder.safeAppend(link, "google_user_id", params.getGoogleUserId());
        TuneUrlBuilder.safeAppend(link, "is_paying_user", params.getIsPayingUser());
        TuneUrlBuilder.safeAppend(link, "twitter_user_id", params.getTwitterUserId());
        TuneUrlBuilder.safeAppend(link, "user_email_md5", params.getUserEmailMd5());
        TuneUrlBuilder.safeAppend(link, "user_email_sha1", params.getUserEmailSha1());
        TuneUrlBuilder.safeAppend(link, "user_email_sha256", params.getUserEmailSha256());
        TuneUrlBuilder.safeAppend(link, "user_id", params.getUserId());
        TuneUrlBuilder.safeAppend(link, "user_name_md5", params.getUserNameMd5());
        TuneUrlBuilder.safeAppend(link, "user_name_sha1", params.getUserNameSha1());
        TuneUrlBuilder.safeAppend(link, "user_name_sha256", params.getUserNameSha256());
        TuneUrlBuilder.safeAppend(link, "user_phone_md5", params.getPhoneNumberMd5());
        TuneUrlBuilder.safeAppend(link, "user_phone_sha1", params.getPhoneNumberSha1());
        TuneUrlBuilder.safeAppend(link, "user_phone_sha256", params.getPhoneNumberSha256());
        return link.toString();
    }

    public static synchronized String updateAndEncryptData(String data, TuneEncryption encryption) {
        if (data == null) {
            data = "";
        }
        StringBuilder updatedData = new StringBuilder(data);
        params = TuneParameters.getInstance();
        if (params != null) {
            TuneLocation location;
            String fbUserId;
            String userAgent;
            String referralUrl;
            String referralSource;
            String referrer;
            String androidId;
            String fireAid;
            String gaid = params.getGoogleAdvertisingId();
            if (gaid != null && !data.contains("&google_aid=")) {
                TuneUrlBuilder.safeAppend(updatedData, "google_aid", gaid);
                TuneUrlBuilder.safeAppend(updatedData, "google_ad_tracking_disabled", params.getGoogleAdTrackingLimited());
            }
            if ((fireAid = params.getFireAdvertisingId()) != null && !data.contains("&fire_aid=")) {
                TuneUrlBuilder.safeAppend(updatedData, "fire_aid", fireAid);
                TuneUrlBuilder.safeAppend(updatedData, "fire_ad_tracking_disabled", params.getFireAdTrackingLimited());
            }
            if ((androidId = params.getAndroidId()) != null && !data.contains("&android_id=")) {
                TuneUrlBuilder.safeAppend(updatedData, "android_id", androidId);
            }
            if ((referrer = params.getInstallReferrer()) != null && !data.contains("&install_referrer=")) {
                TuneUrlBuilder.safeAppend(updatedData, "install_referrer", referrer);
            }
            if ((referralSource = params.getReferralSource()) != null && !data.contains("&referral_source=")) {
                TuneUrlBuilder.safeAppend(updatedData, "referral_source", referralSource);
            }
            if ((referralUrl = params.getReferralUrl()) != null && !data.contains("&referral_url=")) {
                TuneUrlBuilder.safeAppend(updatedData, "referral_url", referralUrl);
            }
            if ((userAgent = params.getUserAgent()) != null && !data.contains("&conversion_user_agent=")) {
                TuneUrlBuilder.safeAppend(updatedData, "conversion_user_agent", userAgent);
            }
            if ((fbUserId = params.getFacebookUserId()) != null && !data.contains("&facebook_user_id=")) {
                TuneUrlBuilder.safeAppend(updatedData, "facebook_user_id", fbUserId);
            }
            if ((location = params.getLocation()) != null) {
                if (!data.contains("&altitude=")) {
                    TuneUrlBuilder.safeAppend(updatedData, "altitude", Double.toString(location.getAltitude()));
                }
                if (!data.contains("&latitude=")) {
                    TuneUrlBuilder.safeAppend(updatedData, "latitude", Double.toString(location.getLatitude()));
                }
                if (!data.contains("&longitude=")) {
                    TuneUrlBuilder.safeAppend(updatedData, "longitude", Double.toString(location.getLongitude()));
                }
            }
        }
        if (!data.contains("&system_date=")) {
            long now = new Date().getTime() / 1000L;
            TuneUrlBuilder.safeAppend(updatedData, "system_date", Long.toString(now));
        }
        String updatedDataStr = updatedData.toString();
        try {
            updatedDataStr = TuneUtils.bytesToHex(encryption.encrypt(updatedDataStr));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return updatedDataStr;
    }

    public static synchronized JSONObject buildBody(JSONArray eventItems, String iapData, String iapSignature, JSONArray emails) {
        JSONObject postData = new JSONObject();
        try {
            if (eventItems != null) {
                postData.put("data", (Object)eventItems);
            }
            if (iapData != null) {
                postData.put("store_iap_data", (Object)iapData);
            }
            if (iapSignature != null) {
                postData.put("store_iap_signature", (Object)iapSignature);
            }
            if (emails != null) {
                postData.put("user_emails", (Object)emails);
            }
        }
        catch (JSONException e) {
            TuneUtils.log("Could not build JSON body of request");
            e.printStackTrace();
        }
        return postData;
    }

    private static synchronized void safeAppend(StringBuilder link, String key, String value) {
        if (value != null && !value.equals("")) {
            try {
                link.append("&" + key + "=" + URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Log.w((String)"TUNE", (String)("failed encoding value " + value + " for key " + key));
                e.printStackTrace();
            }
        }
    }
}

