/*
 * Decompiled with CFR 0.152.
 */
package com.tune;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.tune.Tune;
import com.tune.TuneGender;
import com.tune.TuneLocation;
import com.tune.TuneUtils;
import com.tune.ma.analytics.model.TuneAnalyticsVariable;
import com.tune.ma.analytics.model.TuneHashType;
import com.tune.ma.analytics.model.TuneVariableType;
import com.tune.ma.eventbus.TuneEventBus;
import com.tune.ma.eventbus.event.TuneGetAdvertisingIdCompleted;
import com.tune.ma.eventbus.event.userprofile.TuneUpdateUserProfile;
import com.tune.ma.utils.TuneSharedPrefsDelegate;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;

public class TuneParameters {
    private Context mContext;
    private Tune mTune;
    public static final String ACTION_SESSION = "session";
    public static final String ACTION_CLICK = "click";
    public static final String ACTION_CONVERSION = "conversion";
    private static TuneParameters INSTANCE = null;
    private TuneSharedPrefsDelegate mPrefs;
    private String mAction = null;
    private String mAdvertiserId = null;
    private String mAge = null;
    private String mAltitude = null;
    private String mAndroidId = null;
    private String mAndroidIdMd5 = null;
    private String mAndroidIdSha1 = null;
    private String mAndroidIdSha256 = null;
    private String mAppAdTracking = null;
    private String mAppName = null;
    private String mAppVersion = null;
    private String mAppVersionName = null;
    private String mConnectionType = null;
    private String mConversionKey = null;
    private String mCountryCode = null;
    private String mCurrencyCode = null;
    private String mDeviceBrand = null;
    private String mDeviceBuild = null;
    private String mDeviceCarrier = null;
    private String mDeviceCpuType = null;
    private String mDeviceCpuSubtype = null;
    private String mDeviceId = null;
    private String mDeviceModel = null;
    private boolean mDebugMode = false;
    private String mExistingUser = null;
    private String mFbUserId = null;
    private String mFireAdvertisingId = null;
    private String mFireAdTrackingLimited = null;
    private String mGender = null;
    private String mGaid = null;
    private String mGaidLimited = null;
    private String mGgUserId = null;
    private String mInstallDate = null;
    private String mInstallerPackage = null;
    private String mLanguage = null;
    private String mLatitude = null;
    private String mLocale = null;
    private TuneLocation mLocation = null;
    private String mLongitude = null;
    private String mMacAddress = null;
    private String mMCC = null;
    private String mMNC = null;
    private String mOsVersion = null;
    private String mPackageName = null;
    private String mPhoneNumberMd5;
    private String mPhoneNumberSha1;
    private String mPhoneNumberSha256;
    private String mPluginName = null;
    private String mPurchaseStatus = null;
    private String mReferralSource = null;
    private String mReferralUrl = null;
    private String mReferrerDelay = null;
    private String mScreenDensity = null;
    private String mScreenHeight = null;
    private String mScreenWidth = null;
    private String mTimeZone = null;
    private String mTrackingId = null;
    private String mTrusteId = null;
    private String mTwUserId = null;
    private String mUserAgent = null;
    private String mUserEmailMd5;
    private String mUserEmailSha1;
    private String mUserEmailSha256;
    private JSONArray mUserEmails = null;
    private String mUserNameMd5;
    private String mUserNameSha1;
    private String mUserNameSha256;

    public static TuneParameters init(Tune tune, Context context, String advertiserId, String conversionKey) {
        if (INSTANCE == null) {
            INSTANCE = new TuneParameters();
            TuneParameters.INSTANCE.mTune = tune;
            TuneParameters.INSTANCE.mContext = context;
            TuneParameters.INSTANCE.mPrefs = new TuneSharedPrefsDelegate(context, "com.mobileapptracking");
            INSTANCE.populateParams(context, advertiserId, conversionKey);
        }
        return INSTANCE;
    }

    public static TuneParameters getInstance() {
        return INSTANCE;
    }

    public void clear() {
        INSTANCE = null;
    }

    @SuppressLint(value={"NewApi"})
    private synchronized boolean populateParams(Context context, String advertiserId, String conversionKey) {
        try {
            int height;
            int width;
            this.setAdvertiserId(advertiserId.trim());
            this.setConversionKey(conversionKey.trim());
            this.setCurrencyCode("USD");
            new Thread(new GetAdvertisingId(context)).start();
            this.calculateUserAgent();
            String matId = this.getMatId();
            if (matId == null || matId.length() == 0) {
                matId = UUID.randomUUID().toString();
                this.setMatId(matId);
            }
            TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("mat_id", matId)));
            String packageName = context.getPackageName();
            this.setPackageName(packageName);
            PackageManager pm = context.getPackageManager();
            try {
                ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
                this.setAppName(pm.getApplicationLabel(ai).toString());
            }
            catch (PackageManager.NameNotFoundException ai) {
                // empty catch block
            }
            try {
                PackageInfo pi = pm.getPackageInfo(packageName, 0);
                this.setAppVersion(Integer.toString(pi.versionCode));
                this.setAppVersionName(pi.versionName);
                this.setInstallDate(Long.toString(pi.firstInstallTime / 1000L));
            }
            catch (PackageManager.NameNotFoundException e) {
                this.setAppVersion("0");
            }
            this.setInstaller(pm.getInstallerPackageName(packageName));
            this.setDeviceModel(Build.MODEL);
            this.setDeviceBrand(Build.MANUFACTURER);
            this.setDeviceBuild(Build.DISPLAY);
            this.setDeviceCpuType(System.getProperty("os.arch"));
            this.setOsVersion(Build.VERSION.RELEASE);
            float density = context.getResources().getDisplayMetrics().density;
            this.setScreenDensity(Float.toString(density));
            Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            Point size = new Point();
            if (Build.VERSION.SDK_INT >= 17) {
                display.getRealSize(size);
                width = size.x;
                height = size.y;
            } else if (Build.VERSION.SDK_INT >= 13) {
                display.getSize(size);
                width = size.x;
                height = size.y;
            } else {
                width = display.getWidth();
                height = display.getHeight();
            }
            this.setScreenWidth(Integer.toString(width));
            this.setScreenHeight(Integer.toString(height));
            ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo mWifi = connManager.getNetworkInfo(1);
            if (mWifi.isConnected()) {
                this.setConnectionType("wifi");
            } else {
                this.setConnectionType("mobile");
            }
            this.setLocale(Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry());
            this.setLanguage(Locale.getDefault().getLanguage());
            this.setCountryCode(Locale.getDefault().getCountry());
            this.setTimeZone(TimeZone.getDefault().getDisplayName(false, 0, Locale.US));
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm != null) {
                if (tm.getNetworkCountryIso() != null) {
                    this.setCountryCode(tm.getNetworkCountryIso());
                }
                this.setDeviceCarrier(tm.getNetworkOperatorName());
                String networkOperator = tm.getNetworkOperator();
                if (networkOperator != null) {
                    try {
                        String mcc = networkOperator.substring(0, 3);
                        String mnc = networkOperator.substring(3);
                        this.setMCC(mcc);
                        this.setMNC(mnc);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                }
            } else {
                this.setCountryCode(Locale.getDefault().getCountry());
            }
            return true;
        }
        catch (Exception e) {
            TuneUtils.log("MobileAppTracking params initialization failed");
            e.printStackTrace();
            return false;
        }
    }

    private void calculateUserAgent() {
        String userAgent = System.getProperty("http.agent", "");
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            this.setUserAgent(userAgent);
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post((Runnable)new GetWebViewUserAgent(this.mContext));
        }
    }

    public synchronized String getAction() {
        return this.mAction;
    }

    public synchronized void setAction(String action) {
        this.mAction = action;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("action", action)));
    }

    public synchronized String getAdvertiserId() {
        return this.mAdvertiserId;
    }

    public synchronized void setAdvertiserId(String advertiserId) {
        this.mAdvertiserId = advertiserId;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("advertiser_id", advertiserId)));
        new TuneSharedPrefsDelegate(this.mContext, "com.tune.ma.profile").saveToSharedPreferences("advertiser_id", advertiserId);
    }

    public synchronized String getAge() {
        return this.mAge;
    }

    public synchronized void setAge(String age) {
        this.mAge = age;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("age", Integer.parseInt(age))));
    }

    public synchronized String getAltitude() {
        return this.mAltitude;
    }

    public synchronized void setAltitude(String altitude) {
        this.mAltitude = altitude;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("altitude", altitude)));
    }

    public synchronized String getAndroidId() {
        return this.mAndroidId;
    }

    public synchronized void setAndroidId(String androidId) {
        this.mAndroidId = androidId;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("android_id", androidId)));
    }

    public synchronized String getAndroidIdMd5() {
        return this.mAndroidIdMd5;
    }

    public synchronized void setAndroidIdMd5(String androidIdMd5) {
        this.mAndroidIdMd5 = androidIdMd5;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("android_id_md5", androidIdMd5)));
    }

    public synchronized String getAndroidIdSha1() {
        return this.mAndroidIdSha1;
    }

    public synchronized void setAndroidIdSha1(String androidIdSha1) {
        this.mAndroidIdSha1 = androidIdSha1;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("android_id_sha1", androidIdSha1)));
    }

    public synchronized String getAndroidIdSha256() {
        return this.mAndroidIdSha256;
    }

    public synchronized void setAndroidIdSha256(String androidIdSha256) {
        this.mAndroidIdSha256 = androidIdSha256;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("android_id_sha256", androidIdSha256)));
    }

    public synchronized String getAppAdTrackingEnabled() {
        return this.mAppAdTracking;
    }

    public synchronized void setAppAdTrackingEnabled(String adTrackingEnabled) {
        this.mAppAdTracking = adTrackingEnabled;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("app_ad_tracking", adTrackingEnabled)));
    }

    public synchronized String getAppName() {
        return this.mAppName;
    }

    public synchronized void setAppName(String app_name) {
        this.mAppName = app_name;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("app_name", app_name)));
    }

    public synchronized String getAppVersion() {
        return this.mAppVersion;
    }

    public synchronized void setAppVersion(String appVersion) {
        this.mAppVersion = appVersion;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("app_version", appVersion, TuneVariableType.VERSION)));
    }

    public synchronized String getAppVersionName() {
        return this.mAppVersionName;
    }

    public synchronized void setAppVersionName(String appVersionName) {
        this.mAppVersionName = appVersionName;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("app_version_name", appVersionName)));
    }

    public synchronized String getConnectionType() {
        return this.mConnectionType;
    }

    public synchronized void setConnectionType(String connection_type) {
        this.mConnectionType = connection_type;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("connection_type", connection_type)));
    }

    public synchronized String getConversionKey() {
        return this.mConversionKey;
    }

    public synchronized void setConversionKey(String conversionKey) {
        this.mConversionKey = conversionKey;
    }

    public synchronized String getCountryCode() {
        return this.mCountryCode;
    }

    public synchronized void setCountryCode(String countryCode) {
        this.mCountryCode = countryCode;
        if (countryCode != null) {
            TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("country_code", countryCode.toUpperCase(Locale.ENGLISH))));
        }
    }

    public synchronized String getCurrencyCode() {
        return this.mCurrencyCode;
    }

    public synchronized void setCurrencyCode(String currencyCode) {
        this.mCurrencyCode = currencyCode;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("currency_code", currencyCode)));
    }

    public synchronized String getDeviceBrand() {
        return this.mDeviceBrand;
    }

    public synchronized void setDeviceBrand(String deviceBrand) {
        this.mDeviceBrand = deviceBrand;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("device_brand", deviceBrand)));
    }

    public synchronized String getDeviceBuild() {
        return this.mDeviceBuild;
    }

    public synchronized void setDeviceBuild(String deviceBuild) {
        this.mDeviceBuild = deviceBuild;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("build", deviceBuild)));
    }

    public synchronized String getDeviceCarrier() {
        return this.mDeviceCarrier;
    }

    public synchronized void setDeviceCarrier(String carrier) {
        this.mDeviceCarrier = carrier;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("device_carrier", carrier)));
    }

    public synchronized String getDeviceCpuType() {
        return this.mDeviceCpuType;
    }

    public synchronized void setDeviceCpuType(String cpuType) {
        this.mDeviceCpuType = cpuType;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("device_cpu_type", cpuType)));
    }

    public synchronized String getDeviceCpuSubtype() {
        return this.mDeviceCpuSubtype;
    }

    public synchronized void setDeviceCpuSubtype(String cpuType) {
        this.mDeviceCpuSubtype = cpuType;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("device_cpu_subtype", cpuType)));
    }

    public synchronized String getDeviceId() {
        return this.mDeviceId;
    }

    public synchronized void setDeviceId(String deviceId) {
        this.mDeviceId = deviceId;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("device_id", deviceId)));
    }

    public synchronized String getDeviceModel() {
        return this.mDeviceModel;
    }

    public synchronized void setDeviceModel(String model) {
        this.mDeviceModel = model;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("device_model", model)));
    }

    public synchronized boolean getDebugMode() {
        return this.mDebugMode;
    }

    public synchronized void setDebugMode(boolean debug) {
        this.mDebugMode = debug;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("debug", debug)));
    }

    public synchronized String getExistingUser() {
        return this.mExistingUser;
    }

    public synchronized void setExistingUser(String existingUser) {
        this.mExistingUser = existingUser;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("existing_user", TuneUtils.convertToBoolean(existingUser))));
    }

    public synchronized String getFacebookUserId() {
        return this.mFbUserId;
    }

    public synchronized void setFacebookUserId(String fb_user_id) {
        this.mFbUserId = fb_user_id;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("facebook_user_id", fb_user_id)));
    }

    public synchronized String getFireAdvertisingId() {
        return this.mFireAdvertisingId;
    }

    public synchronized void setFireAdvertisingId(String adId) {
        this.mFireAdvertisingId = adId;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("fire_aid", adId)));
    }

    public synchronized String getFireAdTrackingLimited() {
        return this.mFireAdTrackingLimited;
    }

    public synchronized void setFireAdTrackingLimited(String limited) {
        this.mFireAdTrackingLimited = limited;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("fire_ad_tracking_disabled", limited)));
    }

    public synchronized String getGender() {
        return this.mGender;
    }

    public synchronized void setGender(TuneGender gender) {
        if (gender == TuneGender.MALE) {
            this.mGender = "0";
            TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("gender", "0", TuneVariableType.FLOAT)));
        } else if (gender == TuneGender.FEMALE) {
            this.mGender = "1";
            TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("gender", "1", TuneVariableType.FLOAT)));
        } else {
            this.mGender = "";
            TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("gender", "2", TuneVariableType.FLOAT)));
        }
    }

    public synchronized String getGoogleAdvertisingId() {
        return this.mGaid;
    }

    public synchronized void setGoogleAdvertisingId(String adId) {
        this.mGaid = adId;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("google_aid", adId)));
    }

    public synchronized String getGoogleAdTrackingLimited() {
        return this.mGaidLimited;
    }

    public synchronized void setGoogleAdTrackingLimited(String limited) {
        this.mGaidLimited = limited;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("google_ad_tracking_disabled", limited)));
    }

    public synchronized String getGoogleUserId() {
        return this.mGgUserId;
    }

    public synchronized void setGoogleUserId(String google_user_id) {
        this.mGgUserId = google_user_id;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("google_user_id", google_user_id)));
    }

    public synchronized String getInstallDate() {
        return this.mInstallDate;
    }

    public synchronized void setInstallDate(String installDate) {
        this.mInstallDate = installDate;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("insdate", new Date(Long.parseLong(installDate) * 1000L))));
    }

    public synchronized String getInstaller() {
        return this.mInstallerPackage;
    }

    public synchronized void setInstaller(String installer) {
        this.mInstallerPackage = installer;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("installer", installer)));
    }

    public synchronized String getInstallReferrer() {
        return this.mPrefs.getStringFromSharedPreferences("mat_referrer");
    }

    public synchronized void setInstallReferrer(String installReferrer) {
        this.mPrefs.saveToSharedPreferences("mat_referrer", installReferrer);
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("install_referrer", installReferrer)));
    }

    public synchronized boolean hasInstallFlagBeenSet() {
        return this.mPrefs.getBooleanFromSharedPreferences("mat_installed", false);
    }

    public synchronized void setInstallFlag() {
        this.mPrefs.saveBooleanToSharedPreferences("mat_installed", true);
    }

    public synchronized String getIsPayingUser() {
        return this.mPrefs.getStringFromSharedPreferences("mat_is_paying_user");
    }

    public synchronized void setIsPayingUser(String isPayingUser) {
        this.mPrefs.saveToSharedPreferences("mat_is_paying_user", isPayingUser);
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("is_paying_user", TuneUtils.convertToBoolean(isPayingUser))));
    }

    public synchronized String getLanguage() {
        return this.mLanguage;
    }

    public synchronized void setLanguage(String language) {
        this.mLanguage = language;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("language", language)));
    }

    public synchronized String getLastOpenLogId() {
        return this.mPrefs.getStringFromSharedPreferences("mat_log_id_last_open");
    }

    public synchronized void setLastOpenLogId(String logId) {
        this.mPrefs.saveToSharedPreferences("mat_log_id_last_open", logId);
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("last_open_log_id", logId)));
    }

    public synchronized String getLatitude() {
        return this.mLatitude;
    }

    public synchronized void setLatitude(String latitude) {
        this.mLatitude = latitude;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("latitude", latitude)));
        if (this.mLongitude != null) {
            TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("geo_coordinate", new TuneLocation(Double.valueOf(this.mLongitude), Double.valueOf(this.mLatitude)))));
        }
    }

    public synchronized String getLocale() {
        return this.mLocale;
    }

    public synchronized void setLocale(String locale) {
        this.mLocale = locale;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("locale", locale)));
    }

    public synchronized TuneLocation getLocation() {
        return this.mLocation;
    }

    public synchronized void setLocation(TuneLocation location) {
        this.mLocation = location;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("geo_coordinate", location)));
    }

    public synchronized String getLongitude() {
        return this.mLongitude;
    }

    public synchronized void setLongitude(String longitude) {
        this.mLongitude = longitude;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("longitude", longitude)));
        if (this.mLatitude != null) {
            TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("geo_coordinate", new TuneLocation(Double.valueOf(this.mLongitude), Double.valueOf(this.mLatitude)))));
        }
    }

    public synchronized String getMacAddress() {
        return this.mMacAddress;
    }

    public synchronized void setMacAddress(String mac_address) {
        this.mMacAddress = mac_address;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("mac_address", mac_address)));
    }

    public synchronized String getMatId() {
        if (this.mPrefs.contains("mat_id")) {
            return this.mPrefs.getStringFromSharedPreferences("mat_id");
        }
        return this.mPrefs.getStringFromSharedPreferences("mat_id");
    }

    public synchronized void setMatId(String matId) {
        this.mPrefs.saveToSharedPreferences("mat_id", matId);
    }

    public synchronized String getMCC() {
        return this.mMCC;
    }

    public synchronized void setMCC(String mcc) {
        this.mMCC = mcc;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("mobile_country_code", mcc)));
    }

    public synchronized String getMNC() {
        return this.mMNC;
    }

    public synchronized void setMNC(String mnc) {
        this.mMNC = mnc;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("mobile_network_code", mnc)));
    }

    public synchronized String getOpenLogId() {
        return this.mPrefs.getStringFromSharedPreferences("mat_log_id_open");
    }

    public synchronized void setOpenLogId(String logId) {
        this.mPrefs.saveToSharedPreferences("mat_log_id_open", logId);
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("open_log_id", logId)));
    }

    public synchronized String getOsVersion() {
        return this.mOsVersion;
    }

    public synchronized void setOsVersion(String osVersion) {
        this.mOsVersion = osVersion;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("os_version", osVersion, TuneVariableType.VERSION)));
    }

    public synchronized String getPackageName() {
        return this.mPackageName;
    }

    public synchronized void setPackageName(String packageName) {
        this.mPackageName = packageName;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("package_name", packageName)));
        new TuneSharedPrefsDelegate(this.mContext, "com.tune.ma.profile").saveToSharedPreferences("package_name", packageName);
    }

    public synchronized String getPhoneNumber() {
        return this.mPrefs.getStringFromSharedPreferences("mat_phone_number");
    }

    public synchronized void setPhoneNumber(String phoneNumber) {
        this.mPrefs.saveToSharedPreferences("mat_phone_number", phoneNumber);
        this.setPhoneNumberMd5(TuneUtils.md5(phoneNumber));
        this.setPhoneNumberSha1(TuneUtils.sha1(phoneNumber));
        this.setPhoneNumberSha256(TuneUtils.sha256(phoneNumber));
    }

    public synchronized String getPhoneNumberMd5() {
        return this.mPhoneNumberMd5;
    }

    public synchronized void setPhoneNumberMd5(String phoneNumberMd5) {
        this.mPhoneNumberMd5 = phoneNumberMd5;
        TuneEventBus.post(new TuneUpdateUserProfile(TuneAnalyticsVariable.Builder("user_phone_md5").withValue(phoneNumberMd5).withHash(TuneHashType.MD5).build()));
    }

    public synchronized String getPhoneNumberSha1() {
        return this.mPhoneNumberSha1;
    }

    public synchronized void setPhoneNumberSha1(String phoneNumberSha1) {
        this.mPhoneNumberSha1 = phoneNumberSha1;
        TuneEventBus.post(new TuneUpdateUserProfile(TuneAnalyticsVariable.Builder("user_phone_sha1").withValue(phoneNumberSha1).withHash(TuneHashType.SHA1).build()));
    }

    public synchronized String getPhoneNumberSha256() {
        return this.mPhoneNumberSha256;
    }

    public synchronized void setPhoneNumberSha256(String phoneNumberSha256) {
        this.mPhoneNumberSha256 = phoneNumberSha256;
        TuneEventBus.post(new TuneUpdateUserProfile(TuneAnalyticsVariable.Builder("user_phone_sha256").withValue(phoneNumberSha256).withHash(TuneHashType.SHA256).build()));
    }

    public synchronized String getPluginName() {
        return this.mPluginName;
    }

    public synchronized void setPluginName(String pluginName) {
        this.mPluginName = pluginName;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("sdk_plugin", pluginName)));
    }

    public synchronized String getPurchaseStatus() {
        return this.mPurchaseStatus;
    }

    public synchronized void setPurchaseStatus(String purchaseStatus) {
        this.mPurchaseStatus = purchaseStatus;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("android_purchase_status", purchaseStatus)));
    }

    public synchronized String getReferralSource() {
        return this.mReferralSource;
    }

    public synchronized void setReferralSource(String referralPackage) {
        this.mReferralSource = referralPackage;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("referral_source", referralPackage)));
    }

    public synchronized String getReferralUrl() {
        return this.mReferralUrl;
    }

    public synchronized void setReferralUrl(String referralUrl) {
        this.mReferralUrl = referralUrl;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("referral_url", referralUrl)));
    }

    public synchronized String getReferrerDelay() {
        return this.mReferrerDelay;
    }

    public synchronized void setReferrerDelay(long referrerDelay) {
        this.mReferrerDelay = Long.toString(referrerDelay);
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("referrer_delay", referrerDelay)));
    }

    public synchronized String getScreenDensity() {
        return this.mScreenDensity;
    }

    public synchronized void setScreenDensity(String density) {
        this.mScreenDensity = density;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("screen_density", Float.parseFloat(density))));
    }

    public synchronized String getScreenHeight() {
        return this.mScreenHeight;
    }

    public synchronized void setScreenHeight(String screenheight) {
        this.mScreenHeight = screenheight;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("screen_height", Integer.parseInt(screenheight))));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("screen_layout_size", this.getScreenWidth() + "x" + this.getScreenHeight())));
    }

    public synchronized String getScreenWidth() {
        return this.mScreenWidth;
    }

    public synchronized void setScreenWidth(String screenwidth) {
        this.mScreenWidth = screenwidth;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("screen_width", Integer.parseInt(screenwidth))));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("screen_layout_size", this.getScreenWidth() + "x" + this.getScreenHeight())));
    }

    public synchronized String getSdkVersion() {
        return "4.9.0";
    }

    public synchronized String getTimeZone() {
        return this.mTimeZone;
    }

    public synchronized void setTimeZone(String timeZone) {
        this.mTimeZone = timeZone;
    }

    public synchronized String getTrackingId() {
        return this.mTrackingId;
    }

    public synchronized void setTrackingId(String trackingId) {
        this.mTrackingId = trackingId;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("tracking_id", trackingId)));
    }

    public synchronized String getTRUSTeId() {
        return this.mTrusteId;
    }

    public synchronized void setTRUSTeId(String tpid) {
        this.mTrusteId = tpid;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("truste_tpid", tpid)));
    }

    public synchronized String getTwitterUserId() {
        return this.mTwUserId;
    }

    public synchronized void setTwitterUserId(String twitter_user_id) {
        this.mTwUserId = twitter_user_id;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("twitter_user_id", twitter_user_id)));
    }

    public synchronized String getUserAgent() {
        return this.mUserAgent;
    }

    private synchronized void setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("conversion_user_agent", userAgent)));
    }

    public synchronized String getUserEmail() {
        return this.mPrefs.getStringFromSharedPreferences("mat_user_email");
    }

    public synchronized void setUserEmail(String userEmail) {
        this.mPrefs.saveToSharedPreferences("mat_user_email", userEmail);
        this.setUserEmailMd5(TuneUtils.md5(userEmail));
        this.setUserEmailSha1(TuneUtils.sha1(userEmail));
        this.setUserEmailSha256(TuneUtils.sha256(userEmail));
    }

    public synchronized String getUserEmailMd5() {
        return this.mUserEmailMd5;
    }

    public synchronized void setUserEmailMd5(String userEmailMd5) {
        this.mUserEmailMd5 = userEmailMd5;
        TuneEventBus.post(new TuneUpdateUserProfile(TuneAnalyticsVariable.Builder("user_email_md5").withValue(userEmailMd5).withHash(TuneHashType.MD5).build()));
    }

    public synchronized String getUserEmailSha1() {
        return this.mUserEmailSha1;
    }

    public synchronized void setUserEmailSha1(String userEmailSha1) {
        this.mUserEmailSha1 = userEmailSha1;
        TuneEventBus.post(new TuneUpdateUserProfile(TuneAnalyticsVariable.Builder("user_email_sha1").withValue(userEmailSha1).withHash(TuneHashType.SHA1).build()));
    }

    public synchronized String getUserEmailSha256() {
        return this.mUserEmailSha256;
    }

    public synchronized void setUserEmailSha256(String userEmailSha256) {
        this.mUserEmailSha256 = userEmailSha256;
        TuneEventBus.post(new TuneUpdateUserProfile(TuneAnalyticsVariable.Builder("user_email_sha256").withValue(userEmailSha256).withHash(TuneHashType.SHA256).build()));
    }

    public synchronized JSONArray getUserEmails() {
        return this.mUserEmails;
    }

    public synchronized void setUserEmails(String[] emails) {
        this.mUserEmails = new JSONArray();
        for (int i = 0; i < emails.length; ++i) {
            this.mUserEmails.put((Object)emails[i]);
        }
        try {
            TuneEventBus.post(new TuneUpdateUserProfile(TuneAnalyticsVariable.Builder("user_emails").withValue(this.mUserEmails.join(",")).build()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public synchronized String getUserId() {
        return this.mPrefs.getStringFromSharedPreferences("mat_user_id");
    }

    public synchronized void setUserId(String user_id) {
        this.mPrefs.saveToSharedPreferences("mat_user_id", user_id);
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("user_id", user_id)));
    }

    public synchronized String getUserName() {
        return this.mPrefs.getStringFromSharedPreferences("mat_user_name");
    }

    public synchronized void setUserName(String userName) {
        this.mPrefs.saveToSharedPreferences("mat_user_name", userName);
        this.setUserNameMd5(TuneUtils.md5(userName));
        this.setUserNameSha1(TuneUtils.sha1(userName));
        this.setUserNameSha256(TuneUtils.sha256(userName));
    }

    public synchronized String getUserNameMd5() {
        return this.mUserNameMd5;
    }

    public synchronized void setUserNameMd5(String userNameMd5) {
        this.mUserNameMd5 = userNameMd5;
        TuneEventBus.post(new TuneUpdateUserProfile(TuneAnalyticsVariable.Builder("user_name_md5").withValue(userNameMd5).withHash(TuneHashType.MD5).build()));
    }

    public synchronized String getUserNameSha1() {
        return this.mUserNameSha1;
    }

    public synchronized void setUserNameSha1(String userNameSha1) {
        this.mUserNameSha1 = userNameSha1;
        TuneEventBus.post(new TuneUpdateUserProfile(TuneAnalyticsVariable.Builder("user_name_sha1").withValue(userNameSha1).withHash(TuneHashType.SHA1).build()));
    }

    public synchronized String getUserNameSha256() {
        return this.mUserNameSha256;
    }

    public synchronized void setUserNameSha256(String userNameSha256) {
        this.mUserNameSha256 = userNameSha256;
        TuneEventBus.post(new TuneUpdateUserProfile(TuneAnalyticsVariable.Builder("user_name_sha256").withValue(userNameSha256).withHash(TuneHashType.SHA256).build()));
    }

    @SuppressLint(value={"NewApi"})
    private class GetWebViewUserAgent
    implements Runnable {
        private final WeakReference<Context> weakContext;

        public GetWebViewUserAgent(Context context) {
            this.weakContext = new WeakReference<Context>(context);
        }

        @Override
        public void run() {
            try {
                Class.forName("android.os.AsyncTask");
                if (Build.VERSION.SDK_INT >= 17) {
                    TuneParameters.this.setUserAgent(WebSettings.getDefaultUserAgent((Context)((Context)this.weakContext.get())));
                } else {
                    WebView wv = new WebView((Context)this.weakContext.get());
                    TuneParameters.this.setUserAgent(wv.getSettings().getUserAgentString());
                    wv.destroy();
                }
            }
            catch (Exception exception) {
            }
            catch (VerifyError verifyError) {
                // empty catch block
            }
        }
    }

    private class GetAdvertisingId
    implements Runnable {
        private final WeakReference<Context> weakContext;
        private String deviceId;
        private boolean isLAT = false;

        public GetAdvertisingId(Context context) {
            this.weakContext = new WeakReference<Context>(context);
        }

        @Override
        public void run() {
            try {
                Class[] adIdMethodParams = new Class[]{Context.class};
                Method adIdMethod = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient").getDeclaredMethod("getAdvertisingIdInfo", Context.class);
                Object adInfo = adIdMethod.invoke(null, this.weakContext.get());
                Method getIdMethod = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient$Info").getDeclaredMethod("getId", new Class[0]);
                this.deviceId = (String)getIdMethod.invoke(adInfo, new Object[0]);
                if (this.deviceId.equals("00000000-0000-0000-0000-000000000000")) {
                    this.deviceId = null;
                }
                Method getLATMethod = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient$Info").getDeclaredMethod("isLimitAdTrackingEnabled", new Class[0]);
                this.isLAT = (Boolean)getLATMethod.invoke(adInfo, new Object[0]);
                if (((TuneParameters)TuneParameters.this).mTune.params == null) {
                    TuneParameters.this.setGoogleAdvertisingId(this.deviceId);
                    int intLimit = this.isLAT ? 1 : 0;
                    TuneParameters.this.setGoogleAdTrackingLimited(Integer.toString(intLimit));
                }
                TuneParameters.this.mTune.setGoogleAdvertisingId(this.deviceId, this.isLAT);
                TuneEventBus.post(new TuneGetAdvertisingIdCompleted(TuneGetAdvertisingIdCompleted.Type.GOOGLE_AID, this.deviceId, this.isLAT));
            }
            catch (Exception e) {
                ContentResolver contentResolver = ((Context)this.weakContext.get()).getContentResolver();
                try {
                    this.deviceId = Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id");
                    if (this.deviceId.equals("00000000-0000-0000-0000-000000000000")) {
                        this.deviceId = null;
                    }
                    boolean bl = this.isLAT = Settings.Secure.getInt((ContentResolver)contentResolver, (String)"limit_ad_tracking") != 0;
                    if (((TuneParameters)TuneParameters.this).mTune.params == null) {
                        TuneParameters.this.setFireAdvertisingId(this.deviceId);
                        int intLimit = this.isLAT ? 1 : 0;
                        TuneParameters.this.setFireAdTrackingLimited(Integer.toString(intLimit));
                    }
                    TuneParameters.this.mTune.setFireAdvertisingId(this.deviceId, this.isLAT);
                    TuneEventBus.post(new TuneGetAdvertisingIdCompleted(TuneGetAdvertisingIdCompleted.Type.FIRE_AID, this.deviceId, this.isLAT));
                }
                catch (Exception e1) {
                    TuneUtils.log("TUNE SDK failed to get Advertising Id, collecting ANDROID_ID instead");
                    this.deviceId = Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
                    if (((TuneParameters)TuneParameters.this).mTune.params == null) {
                        TuneParameters.this.setAndroidId(this.deviceId);
                    }
                    TuneParameters.this.mTune.setAndroidId(this.deviceId);
                    TuneEventBus.post(new TuneGetAdvertisingIdCompleted(TuneGetAdvertisingIdCompleted.Type.ANDROID_ID, this.deviceId, this.isLAT));
                }
            }
        }
    }
}

