/*
 * Decompiled with CFR 0.152.
 */
package com.tune;

import android.content.Context;
import android.os.Bundle;
import com.tune.TuneEvent;
import com.tune.TuneParameters;
import java.lang.reflect.Method;
import java.util.Locale;

class TuneFBBridge {
    public static final String EVENT_NAME_ACTIVATED_APP = "fb_mobile_activate_app";
    public static final String EVENT_NAME_COMPLETED_REGISTRATION = "fb_mobile_complete_registration";
    public static final String EVENT_NAME_VIEWED_CONTENT = "fb_mobile_content_view";
    public static final String EVENT_NAME_SEARCHED = "fb_mobile_search";
    public static final String EVENT_NAME_RATED = "fb_mobile_rate";
    public static final String EVENT_NAME_COMPLETED_TUTORIAL = "fb_mobile_tutorial_completion";
    public static final String EVENT_NAME_ADDED_TO_CART = "fb_mobile_add_to_cart";
    public static final String EVENT_NAME_ADDED_TO_WISHLIST = "fb_mobile_add_to_wishlist";
    public static final String EVENT_NAME_INITIATED_CHECKOUT = "fb_mobile_initiated_checkout";
    public static final String EVENT_NAME_ADDED_PAYMENT_INFO = "fb_mobile_add_payment_info";
    public static final String EVENT_NAME_PURCHASED = "fb_mobile_purchase";
    public static final String EVENT_NAME_ACHIEVED_LEVEL = "fb_mobile_level_achieved";
    public static final String EVENT_NAME_UNLOCKED_ACHIEVEMENT = "fb_mobile_achievement_unlocked";
    public static final String EVENT_NAME_SPENT_CREDITS = "fb_mobile_spent_credits";
    public static final String EVENT_PARAM_CURRENCY = "fb_currency";
    public static final String EVENT_PARAM_CONTENT_TYPE = "fb_content_type";
    public static final String EVENT_PARAM_CONTENT_ID = "fb_content_id";
    public static final String EVENT_PARAM_SEARCH_STRING = "fb_search_string";
    public static final String EVENT_PARAM_NUM_ITEMS = "fb_num_items";
    public static final String EVENT_PARAM_LEVEL = "fb_level";
    public static final String EVENT_PARAM_SOURCE_APPLICATION = "fb_mobile_launch_source";
    private static Object logger;
    private static boolean justActivated;

    TuneFBBridge() {
    }

    public static void startLogger(Context context, boolean limitEventAndDataUsage) {
        String sdkVersion = TuneFBBridge.getFbSdkVersion();
        TuneFBBridge.startLoggerForVersion(sdkVersion, context, limitEventAndDataUsage);
    }

    private static String getFbSdkVersion() {
        try {
            Method sdkVersionMethod = Class.forName("com.facebook.FacebookSdk").getMethod("getSdkVersion", new Class[0]);
            return (String)sdkVersionMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                Method sdkVersionMethod = Class.forName("com.facebook.Settings").getMethod("getSdkVersion", new Class[0]);
                return (String)sdkVersionMethod.invoke(null, new Object[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return "";
            }
        }
    }

    private static void startLoggerForVersion(String sdkVersion, Context context, boolean limitEventAndDataUsage) {
        if (!sdkVersion.isEmpty()) {
            String appEventsLoggerClassName = "";
            String setLimitEventAndDataUsageClassName = "";
            if (sdkVersion.startsWith("4.")) {
                appEventsLoggerClassName = "com.facebook.appevents.AppEventsLogger";
                setLimitEventAndDataUsageClassName = "com.facebook.FacebookSdk";
            } else if (sdkVersion.startsWith("3.")) {
                appEventsLoggerClassName = "com.facebook.AppEventsLogger";
                setLimitEventAndDataUsageClassName = "com.facebook.Settings";
            }
            try {
                Class[] activateMethodParams = new Class[]{Context.class};
                Method activateMethod = Class.forName(appEventsLoggerClassName).getMethod("activateApp", activateMethodParams);
                Object[] activateArgs = new Object[]{context};
                activateMethod.invoke(null, activateArgs);
                justActivated = true;
                Class[] limitMethodParams = new Class[]{Context.class, Boolean.TYPE};
                Method limitMethod = Class.forName(setLimitEventAndDataUsageClassName).getMethod("setLimitEventAndDataUsage", limitMethodParams);
                Object[] limitArgs = new Object[]{context, limitEventAndDataUsage};
                limitMethod.invoke(null, limitArgs);
                Method loggerMethod = Class.forName(appEventsLoggerClassName).getMethod("newLogger", activateMethodParams);
                logger = loggerMethod.invoke(null, activateArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void logEvent(TuneEvent event) {
        if (logger != null) {
            try {
                Class[] methodParams = new Class[]{String.class, Double.TYPE, Bundle.class};
                Method method = logger.getClass().getMethod("logEvent", methodParams);
                String fbEventName = event.getEventName();
                double valueToSum = event.getRevenue();
                TuneParameters tuneParams = TuneParameters.getInstance();
                String eventNameLower = event.getEventName().toLowerCase(Locale.US);
                if (eventNameLower.contains("session")) {
                    if (justActivated) {
                        return;
                    }
                    fbEventName = EVENT_NAME_ACTIVATED_APP;
                } else if (eventNameLower.contains("registration")) {
                    fbEventName = EVENT_NAME_COMPLETED_REGISTRATION;
                } else if (eventNameLower.contains("content_view")) {
                    fbEventName = EVENT_NAME_VIEWED_CONTENT;
                } else if (eventNameLower.contains("search")) {
                    fbEventName = EVENT_NAME_SEARCHED;
                } else if (eventNameLower.contains("rated")) {
                    fbEventName = EVENT_NAME_RATED;
                    try {
                        valueToSum = event.getRating();
                    }
                    catch (Exception exception) {}
                } else if (eventNameLower.contains("tutorial_complete")) {
                    fbEventName = EVENT_NAME_COMPLETED_TUTORIAL;
                } else if (eventNameLower.contains("add_to_cart")) {
                    fbEventName = EVENT_NAME_ADDED_TO_CART;
                } else if (eventNameLower.contains("add_to_wishlist")) {
                    fbEventName = EVENT_NAME_ADDED_TO_WISHLIST;
                } else if (eventNameLower.contains("checkout_initiated")) {
                    fbEventName = EVENT_NAME_INITIATED_CHECKOUT;
                } else if (eventNameLower.contains("added_payment_info")) {
                    fbEventName = EVENT_NAME_ADDED_PAYMENT_INFO;
                } else if (eventNameLower.contains("purchase")) {
                    fbEventName = EVENT_NAME_PURCHASED;
                } else if (eventNameLower.contains("level_achieved")) {
                    fbEventName = EVENT_NAME_ACHIEVED_LEVEL;
                } else if (eventNameLower.contains("achievement_unlocked")) {
                    fbEventName = EVENT_NAME_UNLOCKED_ACHIEVEMENT;
                } else if (eventNameLower.contains("spent_credits")) {
                    fbEventName = EVENT_NAME_SPENT_CREDITS;
                    try {
                        valueToSum = event.getQuantity();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Bundle bundle = new Bundle();
                TuneFBBridge.addBundleValue(bundle, EVENT_PARAM_CURRENCY, event.getCurrencyCode());
                TuneFBBridge.addBundleValue(bundle, EVENT_PARAM_CONTENT_ID, event.getContentId());
                TuneFBBridge.addBundleValue(bundle, EVENT_PARAM_CONTENT_TYPE, event.getContentType());
                TuneFBBridge.addBundleValue(bundle, EVENT_PARAM_SEARCH_STRING, event.getSearchString());
                TuneFBBridge.addBundleValue(bundle, EVENT_PARAM_NUM_ITEMS, Integer.toString(event.getQuantity()));
                TuneFBBridge.addBundleValue(bundle, EVENT_PARAM_LEVEL, Integer.toString(event.getLevel()));
                TuneFBBridge.addBundleValue(bundle, "tune_referral_source", tuneParams.getReferralSource());
                TuneFBBridge.addBundleValue(bundle, "tune_source_sdk", "TUNE-MAT");
                Object[] args = new Object[]{fbEventName, valueToSum, bundle};
                method.invoke(logger, args);
                justActivated = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void addBundleValue(Bundle bundle, String key, String value) {
        if (value != null) {
            bundle.putString(key, value);
        }
    }

    static {
        justActivated = false;
    }
}

