/*
 * Decompiled with CFR 0.152.
 */
package com.tune;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.tune.Tune;
import com.tune.TuneUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneEventQueue {
    private SharedPreferences eventQueue;
    private Semaphore queueAvailable;
    private Tune tune;
    private static long retryTimeout = 0L;

    public TuneEventQueue(Context context, Tune tune) {
        this.eventQueue = context.getSharedPreferences("mat_queue", 0);
        this.queueAvailable = new Semaphore(1, true);
        this.tune = tune;
    }

    protected synchronized void setQueueSize(int size) {
        if (size < 0) {
            size = 0;
        }
        this.eventQueue.edit().putInt("queuesize", size).apply();
    }

    protected synchronized int getQueueSize() {
        return this.eventQueue.getInt("queuesize", 0);
    }

    protected synchronized void removeKeyFromQueue(String key) {
        this.setQueueSize(this.getQueueSize() - 1);
        this.eventQueue.edit().remove(key).apply();
    }

    protected synchronized String getKeyFromQueue(String key) {
        return this.eventQueue.getString(key, null);
    }

    protected synchronized void setQueueItemForKey(JSONObject item, String key) {
        this.eventQueue.edit().putString(key, item.toString()).apply();
    }

    protected class Dump
    implements Runnable {
        protected Dump() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int size = TuneEventQueue.this.getQueueSize();
            if (size == 0) {
                return;
            }
            try {
                TuneEventQueue.this.queueAvailable.acquire();
                int index = 1;
                if (size > 50) {
                    index = 1 + (size - 50);
                }
                while (index <= size) {
                    String key = Integer.toString(index);
                    String eventJson = TuneEventQueue.this.getKeyFromQueue(key);
                    if (eventJson != null) {
                        String link = null;
                        String data = null;
                        JSONObject postBody = null;
                        boolean firstSession = false;
                        try {
                            JSONObject event = new JSONObject(eventJson);
                            link = event.getString("link");
                            data = event.getString("data");
                            postBody = event.getJSONObject("post_body");
                            firstSession = event.getBoolean("first_session");
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            TuneEventQueue.this.removeKeyFromQueue(key);
                            TuneEventQueue.this.queueAvailable.release();
                            return;
                        }
                        if (firstSession) {
                            ExecutorService e = ((TuneEventQueue)TuneEventQueue.this).tune.pool;
                            synchronized (e) {
                                ((TuneEventQueue)TuneEventQueue.this).tune.pool.wait(60000L);
                            }
                        }
                        if (TuneEventQueue.this.tune != null) {
                            boolean success = TuneEventQueue.this.tune.makeRequest(link, data, postBody);
                            if (success) {
                                TuneEventQueue.this.removeKeyFromQueue(key);
                                retryTimeout = 0L;
                            } else {
                                --index;
                                String paramString = "&sdk_retry_attempt=";
                                int retryStart = link.indexOf("&sdk_retry_attempt=");
                                if (retryStart > 0) {
                                    int attempt = -1;
                                    int parseStart = retryStart + "&sdk_retry_attempt=".length();
                                    int parseEnd = parseStart + 1;
                                    while (true) {
                                        String attemptString = null;
                                        try {
                                            attemptString = link.substring(parseStart, parseEnd);
                                        }
                                        catch (StringIndexOutOfBoundsException e) {
                                            break;
                                        }
                                        try {
                                            attempt = Integer.parseInt(attemptString);
                                            ++parseEnd;
                                        }
                                        catch (NumberFormatException e) {
                                            break;
                                        }
                                    }
                                    link = link.replaceFirst("&sdk_retry_attempt=\\d+", "&sdk_retry_attempt=" + ++attempt);
                                    try {
                                        JSONObject event = new JSONObject(eventJson);
                                        event.put("link", (Object)link);
                                        TuneEventQueue.this.setQueueItemForKey(event, key);
                                    }
                                    catch (JSONException e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (retryTimeout == 0L) {
                                    retryTimeout = 30L;
                                } else if (retryTimeout <= 30L) {
                                    retryTimeout = 90L;
                                } else if (retryTimeout <= 90L) {
                                    retryTimeout = 600L;
                                } else if (retryTimeout <= 600L) {
                                    retryTimeout = 3600L;
                                } else if (retryTimeout <= 3600L) {
                                    retryTimeout = 21600L;
                                } else {
                                    retryTimeout = 86400L;
                                }
                                double timeoutMs = (1.0 + 0.1 * Math.random()) * (double)retryTimeout * 1000.0;
                                try {
                                    Thread.sleep((long)timeoutMs);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        } else {
                            TuneUtils.log("Dropping queued request because no TUNE object was found");
                            TuneEventQueue.this.removeKeyFromQueue(key);
                        }
                    } else {
                        TuneUtils.log("Null request skipped from queue");
                        TuneEventQueue.this.removeKeyFromQueue(key);
                    }
                    ++index;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                TuneEventQueue.this.queueAvailable.release();
            }
        }
    }

    protected class Add
    implements Runnable {
        private String link = null;
        private String data = null;
        private JSONObject postBody = null;
        private boolean firstSession = false;

        protected Add(String link, String data, JSONObject postBody, boolean firstSession) {
            this.link = link;
            this.data = data;
            this.postBody = postBody;
            this.firstSession = firstSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                TuneEventQueue.this.queueAvailable.acquire();
                JSONObject jsonEvent = new JSONObject();
                try {
                    jsonEvent.put("link", (Object)this.link);
                    jsonEvent.put("data", (Object)this.data);
                    jsonEvent.put("post_body", (Object)this.postBody);
                    jsonEvent.put("first_session", this.firstSession);
                }
                catch (JSONException e) {
                    Log.w((String)"TUNE", (String)"Failed creating event for queueing");
                    e.printStackTrace();
                    TuneEventQueue.this.queueAvailable.release();
                    return;
                }
                int count = TuneEventQueue.this.getQueueSize() + 1;
                TuneEventQueue.this.setQueueSize(count);
                String eventIndex = Integer.toString(count);
                TuneEventQueue.this.setQueueItemForKey(jsonEvent, eventIndex);
            }
            catch (InterruptedException e) {
                Log.w((String)"TUNE", (String)"Interrupted adding event to queue");
                e.printStackTrace();
            }
            finally {
                TuneEventQueue.this.queueAvailable.release();
            }
        }
    }
}

