/*
 * Decompiled with CFR 0.152.
 */
package com.tune;

import com.tune.TuneEventItem;
import com.tune.ma.TuneManager;
import com.tune.ma.analytics.model.TuneAnalyticsVariable;
import com.tune.ma.utils.TuneDebugLog;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TuneEvent
implements Serializable {
    private static final long serialVersionUID = -7616393848331704848L;
    public static final String DEVICE_FORM_WEARABLE = "wearable";
    public static final String REGISTRATION = "registration";
    public static final String LOGIN = "login";
    public static final String ADD_TO_WISHLIST = "add_to_wishlist";
    public static final String ADD_TO_CART = "add_to_cart";
    public static final String ADDED_PAYMENT_INFO = "added_payment_info";
    public static final String RESERVATION = "reservation";
    public static final String CHECKOUT_INITIATED = "checkout_initiated";
    public static final String PURCHASE = "purchase";
    public static final String SEARCH = "search";
    public static final String CONTENT_VIEW = "content_view";
    public static final String TUTORIAL_COMPLETE = "tutorial_complete";
    public static final String LEVEL_ACHIEVED = "level_achieved";
    public static final String ACHIEVEMENT_UNLOCKED = "achievement_unlocked";
    public static final String SPENT_CREDITS = "spent_credits";
    public static final String INVITE = "invite";
    public static final String RATED = "rated";
    public static final String SHARE = "share";
    public static final String NAME_SESSION = "session";
    public static final String NAME_INSTALL = "install";
    public static final String NAME_OPEN = "open";
    public static final String NAME_CLOSE = "close";
    public static final String NAME_UPDATE = "update";
    private String eventName;
    @Deprecated
    private int eventId;
    private double revenue;
    private String currencyCode;
    private String refId;
    private List<TuneEventItem> eventItems;
    private String receiptData;
    private String receiptSignature;
    private String contentType;
    private String contentId;
    private int level;
    private int quantity;
    private String searchString;
    private double rating;
    private Date date1;
    private Date date2;
    private String attribute1;
    private String attribute2;
    private String attribute3;
    private String attribute4;
    private String attribute5;
    private String deviceForm;
    private Set<TuneAnalyticsVariable> tags = new HashSet<TuneAnalyticsVariable>();
    private Set<String> addedTags = new HashSet<String>();
    private static final List<String> invalidTags = Arrays.asList("site_event_id", "revenue", "currency_code", "advertiser_ref_id", "data", "store_iap_data", "store_iap_signature", "content_type", "content_id", "level", "quantity", "search_string", "rating", "date1", "date2", "attribute_sub1", "attribute_sub2", "attribute_sub3", "attribute_sub4", "attribute_sub5");

    public TuneEvent(String eventName) {
        this.eventName = eventName;
    }

    @Deprecated
    public TuneEvent(int eventId) {
        this.eventId = eventId;
    }

    public TuneEvent withRevenue(double revenue) {
        this.revenue = revenue;
        return this;
    }

    public TuneEvent withCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    public TuneEvent withAdvertiserRefId(String refId) {
        this.refId = refId;
        return this;
    }

    public TuneEvent withEventItems(List<TuneEventItem> items) {
        this.eventItems = items;
        return this;
    }

    public TuneEvent withReceipt(String receiptData, String receiptSignature) {
        this.receiptData = receiptData;
        this.receiptSignature = receiptSignature;
        return this;
    }

    public TuneEvent withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public TuneEvent withContentId(String contentId) {
        this.contentId = contentId;
        return this;
    }

    public TuneEvent withLevel(int level) {
        this.level = level;
        return this;
    }

    public TuneEvent withQuantity(int quantity) {
        this.quantity = quantity;
        return this;
    }

    public TuneEvent withSearchString(String searchString) {
        this.searchString = searchString;
        return this;
    }

    public TuneEvent withRating(double rating) {
        this.rating = rating;
        return this;
    }

    public TuneEvent withDate1(Date date1) {
        this.date1 = date1;
        return this;
    }

    public TuneEvent withDate2(Date date2) {
        this.date2 = date2;
        return this;
    }

    public TuneEvent withAttribute1(String attribute1) {
        this.attribute1 = attribute1;
        return this;
    }

    public TuneEvent withAttribute2(String attribute2) {
        this.attribute2 = attribute2;
        return this;
    }

    public TuneEvent withAttribute3(String attribute3) {
        this.attribute3 = attribute3;
        return this;
    }

    public TuneEvent withAttribute4(String attribute4) {
        this.attribute4 = attribute4;
        return this;
    }

    public TuneEvent withAttribute5(String attribute5) {
        this.attribute5 = attribute5;
        return this;
    }

    public TuneEvent withDeviceForm(String deviceForm) {
        this.deviceForm = deviceForm;
        return this;
    }

    public TuneEvent withTagAsString(String name, String value) {
        if (TuneManager.getProfileForUser("withTagAsString") == null) {
            return this;
        }
        return this.addTag(new TuneAnalyticsVariable(name, value));
    }

    public TuneEvent withTagAsNumber(String name, int value) {
        if (TuneManager.getProfileForUser("withTagAsNumber") == null) {
            return this;
        }
        return this.addTag(new TuneAnalyticsVariable(name, value));
    }

    public TuneEvent withTagAsNumber(String name, double value) {
        if (TuneManager.getProfileForUser("withTagAsNumber") == null) {
            return this;
        }
        return this.addTag(new TuneAnalyticsVariable(name, value));
    }

    public TuneEvent withTagAsNumber(String name, float value) {
        if (TuneManager.getProfileForUser("withTagAsNumber") == null) {
            return this;
        }
        return this.addTag(new TuneAnalyticsVariable(name, value));
    }

    public TuneEvent withTagAsDate(String name, Date value) {
        if (TuneManager.getProfileForUser("withTagAsDate") == null) {
            return this;
        }
        return this.addTag(new TuneAnalyticsVariable(name, value));
    }

    private TuneEvent addTag(TuneAnalyticsVariable tag) {
        if (TuneAnalyticsVariable.validateName(tag.getName())) {
            String prettyName = TuneAnalyticsVariable.cleanVariableName(tag.getName());
            if (invalidTags.contains(prettyName)) {
                TuneDebugLog.IAMConfigError(prettyName + " is a property, please use the appropriate setter instead.");
                return this;
            }
            if (prettyName.startsWith("TUNE_")) {
                TuneDebugLog.IAMConfigError("Tags starting with 'TUNE_' are reserved, not registering " + prettyName);
                return this;
            }
            if (this.addedTags.contains(prettyName)) {
                TuneDebugLog.IAMConfigError("The tag " + prettyName + " has already been added to this event, not adding duplicate tag");
                return this;
            }
            this.addedTags.add(prettyName);
            this.tags.add(TuneAnalyticsVariable.Builder(prettyName).withValue(tag.getValue()).withType(tag.getType()).withHash(tag.getHashType()).withShouldAutoHash(tag.getShouldAutoHash()).build());
        }
        return this;
    }

    public String getEventName() {
        return this.eventName;
    }

    @Deprecated
    public int getEventId() {
        return this.eventId;
    }

    public double getRevenue() {
        return this.revenue;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getRefId() {
        return this.refId;
    }

    public List<TuneEventItem> getEventItems() {
        return this.eventItems;
    }

    public String getReceiptData() {
        return this.receiptData;
    }

    public String getReceiptSignature() {
        return this.receiptSignature;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentId() {
        return this.contentId;
    }

    public int getLevel() {
        return this.level;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public double getRating() {
        return this.rating;
    }

    public Date getDate1() {
        return this.date1;
    }

    public Date getDate2() {
        return this.date2;
    }

    public String getAttribute1() {
        return this.attribute1;
    }

    public String getAttribute2() {
        return this.attribute2;
    }

    public String getAttribute3() {
        return this.attribute3;
    }

    public String getAttribute4() {
        return this.attribute4;
    }

    public String getAttribute5() {
        return this.attribute5;
    }

    public String getDeviceForm() {
        return this.deviceForm;
    }

    public Set<TuneAnalyticsVariable> getTags() {
        return this.tags;
    }
}

