/*
 * Decompiled with CFR 0.152.
 */
package com.tune;

import com.tune.TuneUtils;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class TuneEncryption {
    private IvParameterSpec ivspec;
    private SecretKeySpec keyspec;
    private Cipher cipher;

    public TuneEncryption(String SecretKey2, String iv) {
        this.ivspec = new IvParameterSpec(iv.getBytes());
        this.keyspec = new SecretKeySpec(SecretKey2.getBytes(), "AES");
        try {
            this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
    }

    public byte[] encrypt(String text) throws Exception {
        if (text == null || text.length() == 0) {
            throw new Exception("Empty string");
        }
        byte[] encrypted = null;
        try {
            this.cipher.init(1, (Key)this.keyspec, this.ivspec);
            encrypted = this.cipher.doFinal(TuneEncryption.padString(text).getBytes());
        }
        catch (Exception e) {
            throw new Exception("[encrypt] " + e.getMessage());
        }
        return encrypted;
    }

    public byte[] decrypt(String code) throws Exception {
        if (code == null || code.length() == 0) {
            throw new Exception("Empty string");
        }
        byte[] decrypted = null;
        try {
            this.cipher.init(2, (Key)this.keyspec, this.ivspec);
            decrypted = this.cipher.doFinal(TuneUtils.hexToBytes(code));
        }
        catch (Exception e) {
            throw new Exception("[decrypt] " + e.getMessage());
        }
        return decrypted;
    }

    private static String padString(String source) {
        char paddingChar = ' ';
        int size = 16;
        int x = source.length() % size;
        int padLength = size - x;
        for (int i = 0; i < padLength; ++i) {
            source = source + paddingChar;
        }
        return source;
    }
}

