/*
 * Decompiled with CFR 0.152.
 */
package com.tune;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.tune.TuneDeeplinkListener;
import com.tune.http.UrlRequester;
import java.util.HashSet;
import java.util.Set;

public class TuneDeeplinker {
    public static final String TLNK_IO = "tlnk.io";
    private final Set<String> registeredTuneLinkDomains;
    private final String advertiserId;
    private final String conversionKey;
    private String packageName;
    private String googleAdvertisingId;
    private int isGoogleLimitAdTrackingEnabled;
    private String fireAdvertisingId;
    private int isFireLimitAdTrackingEnabled;
    private String androidId;
    private String userAgent;
    private TuneDeeplinkListener listener;
    private boolean haveRequestedDeferredDeeplink;

    public TuneDeeplinker(String advertiserId, String conversionKey, String packageName) {
        this.advertiserId = advertiserId;
        this.conversionKey = conversionKey;
        this.packageName = packageName;
        this.registeredTuneLinkDomains = new HashSet<String>();
        this.registeredTuneLinkDomains.add(TLNK_IO);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setFireAdvertisingId(String fireAdvertisingId, int isLATEnabled) {
        this.fireAdvertisingId = fireAdvertisingId;
        this.isFireLimitAdTrackingEnabled = isLATEnabled;
    }

    public void setGoogleAdvertisingId(String googleAdvertisingId, int isLATEnabled) {
        this.googleAdvertisingId = googleAdvertisingId;
        this.isGoogleLimitAdTrackingEnabled = isLATEnabled;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }

    public void setListener(TuneDeeplinkListener listener) {
        this.listener = listener;
    }

    public void requestDeferredDeeplink(String userAgent, Context context, UrlRequester urlRequester) {
        this.setUserAgent(userAgent);
        this.checkForDeferredDeeplink(context, urlRequester);
    }

    public String buildDeferredDeepLinkRequestURL() {
        String advertisingId = this.androidId;
        if (this.googleAdvertisingId != null) {
            advertisingId = this.googleAdvertisingId;
        } else if (this.fireAdvertisingId != null) {
            advertisingId = this.fireAdvertisingId;
        }
        Uri.Builder uri = new Uri.Builder();
        uri.scheme("https").authority(this.advertiserId + "." + "deeplink.mobileapptracking.com").appendPath("v1").appendPath("link.txt").appendQueryParameter("platform", "android").appendQueryParameter("advertiser_id", this.advertiserId).appendQueryParameter("ver", "4.9.0").appendQueryParameter("package_name", this.packageName).appendQueryParameter("ad_id", advertisingId).appendQueryParameter("user_agent", this.getUserAgent());
        if (this.googleAdvertisingId != null) {
            uri.appendQueryParameter("google_ad_tracking_disabled", Integer.toString(this.isGoogleLimitAdTrackingEnabled));
        }
        if (this.fireAdvertisingId != null) {
            uri.appendQueryParameter("fire_ad_tracking_disabled", Integer.toString(this.isFireLimitAdTrackingEnabled));
        }
        return uri.build().toString();
    }

    private void checkForDeferredDeeplink(Context context, final UrlRequester urlRequester) {
        if (this.listener == null) {
            return;
        }
        if (this.haveRequestedDeferredDeeplink) {
            return;
        }
        if (this.advertiserId == null || this.conversionKey == null || this.packageName == null) {
            this.listener.didFailDeeplink("Advertiser ID, conversion key, or package name not set");
            return;
        }
        if (this.googleAdvertisingId == null && this.fireAdvertisingId == null && this.androidId == null) {
            this.listener.didFailDeeplink("No device identifiers collected");
            return;
        }
        this.haveRequestedDeferredDeeplink = true;
        final TuneDeeplinkListener listenerRefForNewThread = this.listener;
        new Thread(new Runnable(){

            @Override
            public void run() {
                urlRequester.requestDeeplink(TuneDeeplinker.this.buildDeferredDeepLinkRequestURL(), TuneDeeplinker.this.conversionKey, listenerRefForNewThread);
            }
        }).start();
    }

    public void handleFailedExpandedTuneLink(String errorMessage) {
        if (this.listener != null) {
            this.listener.didFailDeeplink(errorMessage);
        }
    }

    public void handleExpandedTuneLink(String invokeUrl) {
        if (this.listener != null) {
            this.listener.didReceiveDeeplink(invokeUrl);
        }
    }

    public void registerCustomTuneLinkDomain(String domain) {
        if (domain != null) {
            this.registeredTuneLinkDomains.add(domain);
        }
    }

    public boolean isTuneLink(@NonNull String appLinkUrl) {
        boolean isTuneLink = false;
        try {
            Uri appLink = Uri.parse((String)appLinkUrl);
            String scheme = appLink.getScheme();
            if (!"https".equals(scheme) && !"http".equals(scheme)) {
                return false;
            }
            String host = appLink.getHost();
            for (String registeredTuneDomain : this.registeredTuneLinkDomains) {
                if (!host.endsWith(registeredTuneDomain)) continue;
                isTuneLink = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isTuneLink;
    }
}

