/*
 * Decompiled with CFR 0.152.
 */
package com.tune;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import android.widget.Toast;
import com.tune.TuneConstants;
import com.tune.TuneDeeplinkListener;
import com.tune.TuneDeeplinker;
import com.tune.TuneEncryption;
import com.tune.TuneEvent;
import com.tune.TuneEventQueue;
import com.tune.TuneFBBridge;
import com.tune.TuneGender;
import com.tune.TuneListener;
import com.tune.TuneLocation;
import com.tune.TuneParameters;
import com.tune.TunePreloadData;
import com.tune.TuneTestRequest;
import com.tune.TuneUrlBuilder;
import com.tune.TuneUtils;
import com.tune.http.TuneUrlRequester;
import com.tune.http.UrlRequester;
import com.tune.location.TuneLocationListener;
import com.tune.ma.TuneManager;
import com.tune.ma.analytics.model.TuneAnalyticsVariable;
import com.tune.ma.analytics.model.TuneVariableType;
import com.tune.ma.configuration.TuneConfiguration;
import com.tune.ma.eventbus.TuneEventBus;
import com.tune.ma.eventbus.event.TuneEventOccurred;
import com.tune.ma.eventbus.event.userprofile.TuneUpdateUserProfile;
import com.tune.ma.experiments.model.TuneInAppMessageExperimentDetails;
import com.tune.ma.experiments.model.TunePowerHookExperimentDetails;
import com.tune.ma.model.TuneCallback;
import com.tune.ma.model.TuneDeepActionCallback;
import com.tune.ma.push.TunePushInfo;
import com.tune.ma.push.settings.TuneNotificationBuilder;
import com.tune.ma.utils.TuneDebugLog;
import com.tune.ma.utils.TuneOptional;
import com.tune.smartwhere.TuneSmartWhere;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Tune {
    private final String IV = "heF9BATUfWuISyO8";
    protected BroadcastReceiver networkStateReceiver;
    protected Context mContext;
    protected ExecutorService pubQueue;
    protected TuneEventQueue eventQueue;
    protected TuneLocationListener locationListener;
    protected TuneParameters params;
    protected TuneTestRequest tuneRequest;
    protected boolean initialized;
    protected boolean isRegistered;
    protected boolean collectLocation;
    private TuneDeeplinker dplinkr;
    private TunePreloadData mPreloadData;
    private UrlRequester urlRequester;
    private TuneEncryption encryption;
    private TuneListener tuneListener;
    private boolean debugMode;
    private boolean firstSession;
    protected boolean isFirstInstall;
    private boolean fbLogging;
    private long initTime;
    private long referrerTime;
    protected long timeLastMeasuredSession;
    boolean gotAdvertisingId;
    boolean gotReferrer;
    boolean notifiedPool;
    ExecutorService pool;
    private static volatile Tune tune = null;

    protected Tune() {
    }

    public static synchronized Tune getInstance() {
        return tune;
    }

    public static synchronized Tune init(Context context, String advertiserId, String conversionKey) {
        return Tune.init(context, advertiserId, conversionKey, false);
    }

    public static synchronized Tune init(Context context, String advertiserId, String conversionKey, boolean turnOnIAM) {
        return Tune.init(context, advertiserId, conversionKey, turnOnIAM, new TuneConfiguration());
    }

    public static synchronized Tune init(Context context, String advertiserId, String conversionKey, boolean turnOnIAM, TuneConfiguration configuration) {
        if (tune == null) {
            tune = new Tune();
            Tune.tune.mContext = context.getApplicationContext();
            Tune.tune.pubQueue = Executors.newSingleThreadExecutor();
            if (turnOnIAM && TuneUtils.hasPermission(context, "android.permission.INTERNET")) {
                TuneEventBus.enable();
                TuneManager.init(context.getApplicationContext(), configuration);
            } else {
                TuneEventBus.disable();
            }
            tune.initAll(advertiserId, conversionKey);
            Tune.tune.locationListener = new TuneLocationListener(context);
            if (configuration != null) {
                Tune.tune.collectLocation = configuration.shouldAutoCollectDeviceLocation();
                if (Tune.tune.collectLocation) {
                    Tune.tune.locationListener.startListening();
                    tune.startSmartWhereLocationMonitoring();
                }
            }
        }
        return tune;
    }

    static void setInstance(Tune newTune) {
        tune = newTune;
    }

    static synchronized void clear() {
        tune = null;
    }

    protected void initAll(String advertiserId, String conversionKey) {
        this.dplinkr = new TuneDeeplinker(advertiserId, conversionKey, this.mContext.getPackageName());
        this.params = TuneParameters.init(this, this.mContext, advertiserId, conversionKey);
        this.initLocalVariables(conversionKey);
        this.eventQueue = new TuneEventQueue(this.mContext, this);
        this.dumpQueue();
        this.networkStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (Tune.this.isRegistered) {
                    Tune.this.dumpQueue();
                }
            }
        };
        if (this.isRegistered) {
            try {
                this.mContext.unregisterReceiver(this.networkStateReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.isRegistered = false;
        }
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiver(this.networkStateReceiver, filter);
        this.isRegistered = true;
        if (!this.params.hasInstallFlagBeenSet()) {
            this.isFirstInstall = true;
            this.params.setInstallFlag();
        }
        this.initialized = true;
    }

    private void initLocalVariables(String key) {
        this.pool = Executors.newSingleThreadExecutor();
        this.urlRequester = new TuneUrlRequester();
        this.encryption = new TuneEncryption(key.trim(), "heF9BATUfWuISyO8");
        this.initTime = System.currentTimeMillis();
        this.gotReferrer = !this.mContext.getSharedPreferences("com.mobileapptracking", 0).getString("mat_referrer", "").equals("");
        this.firstSession = true;
        this.initialized = false;
        this.isRegistered = false;
        this.debugMode = false;
        this.fbLogging = false;
        this.collectLocation = true;
    }

    public static synchronized boolean isOnline(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    protected void addEventToQueue(String link, String data, JSONObject postBody, boolean firstSession) {
        if (this.pool.isShutdown()) {
            return;
        }
        TuneEventQueue tuneEventQueue = this.eventQueue;
        tuneEventQueue.getClass();
        this.pool.execute(new TuneEventQueue.Add(tuneEventQueue, link, data, postBody, firstSession));
    }

    protected void dumpQueue() {
        if (!Tune.isOnline(this.mContext)) {
            return;
        }
        if (this.pool.isShutdown()) {
            return;
        }
        this.pool.execute(new TuneEventQueue.Dump(this.eventQueue));
    }

    @Deprecated
    public void measureSession() {
        TuneDebugLog.w("Call to DEPRECATED method tune.measureSession() As of Tune Android SDK v4.8.0 you do not need to call this method directly. This method will be removed in Tune Android SDK v5.0.0");
        this.measureSessionInternal();
    }

    public void measureSessionInternal() {
        this.timeLastMeasuredSession = System.currentTimeMillis();
        this.notifiedPool = false;
        this.measureEvent(new TuneEvent("session"));
        if (this.debugMode) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)Tune.this.mContext, (CharSequence)"TUNE measureSession called", (int)1).show();
                }
            });
        }
    }

    public long getTimeLastMeasuredSession() {
        return this.timeLastMeasuredSession;
    }

    public void measureEvent(String eventName) {
        this.measureEvent(new TuneEvent(eventName));
    }

    @Deprecated
    public void measureEvent(int eventId) {
        TuneUtils.log("Call to DEPRECATED method tune.measureEvent(int) Tune does not support measuring events using event IDs. Please use tune.measureEvent(String) instead. This method will be removed in Tune Android SDK v5.0.0");
        this.measureEvent(new TuneEvent(eventId));
    }

    public void measureEvent(final TuneEvent eventData) {
        if (TextUtils.isEmpty((CharSequence)eventData.getEventName()) && eventData.getEventId() == 0) {
            Log.w((String)"TUNE", (String)"Event name or ID cannot be null, empty, or zero");
            return;
        }
        TuneEventBus.post(new TuneEventOccurred(eventData));
        this.updateLocation();
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.measure(eventData);
            }
        });
    }

    private void measureTuneLinkClick(String clickedTuneLinkUrl) {
        if (!this.initialized) {
            return;
        }
        this.dumpQueue();
        String link = TuneUrlBuilder.appendTuneLinkParameters(clickedTuneLinkUrl);
        String data = "";
        JSONObject postBody = new JSONObject();
        if (this.tuneRequest != null) {
            this.tuneRequest.constructedRequest(link, data, postBody);
        }
        this.addEventToQueue(link, data, postBody, this.firstSession);
        this.dumpQueue();
        if (this.tuneListener != null) {
            this.tuneListener.enqueuedActionWithRefId(null);
        }
    }

    private synchronized void measure(TuneEvent eventData) {
        if (!this.initialized) {
            return;
        }
        this.dumpQueue();
        this.params.setAction("conversion");
        if (eventData.getEventName() != null) {
            String eventName = eventData.getEventName();
            if (this.fbLogging) {
                TuneFBBridge.logEvent(eventData);
            }
            if ("close".equals(eventName)) {
                return;
            }
            if ("open".equals(eventName) || "install".equals(eventName) || "update".equals(eventName) || "session".equals(eventName)) {
                this.params.setAction("session");
            }
        }
        if (eventData.getRevenue() > 0.0) {
            this.params.setIsPayingUser("1");
        }
        String link = TuneUrlBuilder.buildLink(eventData, this.mPreloadData, this.debugMode);
        String data = TuneUrlBuilder.buildDataUnencrypted(eventData);
        JSONArray eventItemsJson = new JSONArray();
        if (eventData.getEventItems() != null) {
            for (int i = 0; i < eventData.getEventItems().size(); ++i) {
                eventItemsJson.put((Object)eventData.getEventItems().get(i).toJson());
            }
        }
        JSONObject postBody = TuneUrlBuilder.buildBody(eventItemsJson, eventData.getReceiptData(), eventData.getReceiptSignature(), this.params.getUserEmails());
        if (this.tuneRequest != null) {
            this.tuneRequest.constructedRequest(link, data, postBody);
        }
        this.addEventToQueue(link, data, postBody, this.firstSession);
        this.firstSession = false;
        this.dumpQueue();
        if (this.tuneListener != null) {
            this.tuneListener.enqueuedActionWithRefId(eventData.getRefId());
        }
    }

    protected boolean makeRequest(String link, String data, JSONObject postBody) {
        JSONObject response;
        TuneDebugLog.d("Sending event to server...");
        boolean removeRequestFromQueue = true;
        boolean retryRequest = false;
        if (link == null) {
            TuneDebugLog.e("TUNE", "CRITICAL internal Tune request link is null");
            this.safeReportFailureToTuneListener("Internal Tune request link is null");
            return true;
        }
        this.updateLocation();
        String encData = TuneUrlBuilder.updateAndEncryptData(data, this.encryption);
        String fullLink = link + "&data=" + encData;
        if (this.tuneListener != null) {
            this.tuneListener.enqueuedRequest(fullLink, postBody);
        }
        if ((response = this.urlRequester.requestUrl(fullLink, postBody, this.debugMode)) == null) {
            this.safeReportFailureToTuneListener("Error 400 response from Tune");
            return true;
        }
        if (!response.has("success")) {
            TuneDebugLog.e("Request failed, event will remain in queue");
            this.safeReportFailureToTuneListener(response);
            return false;
        }
        this.checkForExpandedTuneLinks(link, response);
        boolean success = false;
        try {
            success = response.getString("success").equals("true");
        }
        catch (JSONException e) {
            TuneDebugLog.e("Error parsing response " + response + " to check for success", e);
            this.safeReportFailureToTuneListener(response);
            return false;
        }
        this.safeReportSuccessOrFailureToTuneListener(response, success);
        this.saveOpenLogId(response);
        return true;
    }

    private void safeReportSuccessOrFailureToTuneListener(JSONObject response, boolean success) {
        if (success) {
            this.safeReportSuccessToTuneListener(response);
        } else {
            this.safeReportFailureToTuneListener(response);
        }
    }

    private void safeReportSuccessToTuneListener(JSONObject response) {
        if (this.tuneListener != null) {
            this.tuneListener.didSucceedWithData(response);
        }
    }

    private void safeReportFailureToTuneListener(JSONObject response) {
        if (this.tuneListener != null) {
            this.tuneListener.didFailWithError(response);
        }
    }

    private void safeReportFailureToTuneListener(String errorMessage) {
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put("error", errorMessage);
        this.safeReportFailureToTuneListener(new JSONObject(errors));
    }

    private void saveOpenLogId(JSONObject response) {
        try {
            String eventType = response.optString("site_event_type");
            if ("open".equals(eventType)) {
                String logId = response.getString("log_id");
                if ("".equals(this.getOpenLogId())) {
                    this.params.setOpenLogId(logId);
                }
                this.params.setLastOpenLogId(logId);
            }
        }
        catch (JSONException e) {
            TuneDebugLog.e("Error parsing response " + response + " to save open log id", e);
        }
    }

    private void checkForExpandedTuneLinks(String link, JSONObject response) {
        try {
            if (this.isTuneLinkMeasurementRequest(link) && !this.isInvokeUrlParameterInReferralUrl()) {
                if (response.has("invoke_url")) {
                    this.dplinkr.handleExpandedTuneLink(response.getString("invoke_url"));
                } else {
                    this.dplinkr.handleFailedExpandedTuneLink("There is no invoke url for this Tune Link");
                }
            }
        }
        catch (JSONException e) {
            TuneDebugLog.e("Error parsing response " + response + " to check for invoke url", e);
        }
    }

    private boolean isInvokeUrlParameterInReferralUrl() {
        return this.invokeUrlFromReferralUrl(this.params.getReferralUrl()).isPresent();
    }

    private boolean isTuneLinkMeasurementRequest(String link) {
        return link.contains("action=click");
    }

    protected TuneOptional<String> invokeUrlFromReferralUrl(String referralUrl) {
        String invokeUrl = null;
        try {
            Uri clickedLink = Uri.parse((String)referralUrl);
            invokeUrl = clickedLink.getQueryParameter("invoke_url");
        }
        catch (Exception e) {
            TuneDebugLog.e("Error looking for invoke_url in referral url: " + referralUrl, e);
        }
        return TuneOptional.ofNullable(invokeUrl);
    }

    protected void updateLocation() {
        Location lastLocation;
        if (this.collectLocation && this.params.getLocation() == null && this.locationListener != null && (lastLocation = this.locationListener.getLastLocation()) != null) {
            this.params.setLocation(new TuneLocation(lastLocation));
        }
    }

    public String getAction() {
        return this.params.getAction();
    }

    public String getAdvertiserId() {
        return this.params.getAdvertiserId();
    }

    public int getAge() {
        String ageString = this.params.getAge();
        int age = 0;
        if (ageString != null) {
            try {
                age = Integer.parseInt(ageString);
            }
            catch (NumberFormatException e) {
                TuneDebugLog.e("TUNE", "Error parsing age value " + ageString, e);
            }
        }
        return age;
    }

    public double getAltitude() {
        String altitudeString = this.params.getAltitude();
        double altitude = 0.0;
        if (altitudeString != null) {
            try {
                altitude = Double.parseDouble(altitudeString);
            }
            catch (NumberFormatException e) {
                TuneDebugLog.e("TUNE", "Error parsing altitude value " + altitudeString, e);
            }
        }
        return altitude;
    }

    public String getAndroidId() {
        return this.params.getAndroidId();
    }

    public boolean getAppAdTrackingEnabled() {
        String appAdTrackingEnabledString = this.params.getAppAdTrackingEnabled();
        int adTrackingEnabled = 0;
        if (appAdTrackingEnabledString != null) {
            try {
                adTrackingEnabled = Integer.parseInt(appAdTrackingEnabledString);
            }
            catch (NumberFormatException e) {
                TuneDebugLog.e("TUNE", "Error parsing adTrackingEnabled value " + appAdTrackingEnabledString, e);
            }
        }
        return adTrackingEnabled == 1;
    }

    public String getAppName() {
        return this.params.getAppName();
    }

    public int getAppVersion() {
        String appVersionString = this.params.getAppVersion();
        int appVersion = 0;
        if (appVersionString != null) {
            try {
                appVersion = Integer.parseInt(appVersionString);
            }
            catch (NumberFormatException e) {
                TuneDebugLog.e("TUNE", "Error parsing appVersion value " + appVersionString, e);
            }
        }
        return appVersion;
    }

    public String getConnectionType() {
        return this.params.getConnectionType();
    }

    public String getCountryCode() {
        return this.params.getCountryCode();
    }

    public String getCurrencyCode() {
        return this.params.getCurrencyCode();
    }

    public String getDeviceBrand() {
        return this.params.getDeviceBrand();
    }

    public String getDeviceBuild() {
        return this.params.getDeviceBuild();
    }

    public String getDeviceCarrier() {
        return this.params.getDeviceCarrier();
    }

    public String getDeviceId() {
        return this.params.getDeviceId();
    }

    public String getDeviceModel() {
        return this.params.getDeviceModel();
    }

    public boolean getExistingUser() {
        int intExisting = Integer.parseInt(this.params.getExistingUser());
        return intExisting == 1;
    }

    public String getFacebookUserId() {
        return this.params.getFacebookUserId();
    }

    public String getFireAdvertisingId() {
        return this.params.getFireAdvertisingId();
    }

    public boolean getFireAdTrackingLimited() {
        String fireAdTrackingLimitedString = this.params.getFireAdTrackingLimited();
        int fireAdTrackingLimited = 0;
        try {
            fireAdTrackingLimited = Integer.parseInt(fireAdTrackingLimitedString);
        }
        catch (NumberFormatException e) {
            TuneDebugLog.e("TUNE", "Error parsing fireAdTrackingLimited value " + fireAdTrackingLimitedString, e);
        }
        return fireAdTrackingLimited != 0;
    }

    public TuneGender getGender() {
        String gender = this.params.getGender();
        if ("0".equals(gender)) {
            return TuneGender.MALE;
        }
        if ("1".equals(gender)) {
            return TuneGender.FEMALE;
        }
        return TuneGender.UNKNOWN;
    }

    public String getGoogleAdvertisingId() {
        return this.params.getGoogleAdvertisingId();
    }

    public boolean getGoogleAdTrackingLimited() {
        String googleAdTrackingLimitedString = this.params.getGoogleAdTrackingLimited();
        int googleAdTrackingLimited = 0;
        try {
            googleAdTrackingLimited = Integer.parseInt(googleAdTrackingLimitedString);
        }
        catch (NumberFormatException e) {
            TuneDebugLog.e("TUNE", "Error parsing googleAdTrackingLimited value " + googleAdTrackingLimitedString, e);
        }
        return googleAdTrackingLimited != 0;
    }

    public String getGoogleUserId() {
        return this.params.getGoogleUserId();
    }

    public long getInstallDate() {
        String installDateString = this.params.getInstallDate();
        long installDate = 0L;
        if (installDateString != null) {
            try {
                installDate = Long.parseLong(installDateString);
            }
            catch (NumberFormatException e) {
                TuneDebugLog.e("TUNE", "Error parsing installDate value " + installDateString, e);
            }
        }
        return installDate;
    }

    public String getInstallReferrer() {
        return this.params.getInstallReferrer();
    }

    public boolean getIsPayingUser() {
        String isPayingUser = this.params.getIsPayingUser();
        return "1".equals(isPayingUser);
    }

    public String getLanguage() {
        return this.params.getLanguage();
    }

    public String getLastOpenLogId() {
        return this.params.getLastOpenLogId();
    }

    public double getLatitude() {
        String latitudeString = this.params.getLatitude();
        double latitude = 0.0;
        if (latitudeString != null) {
            try {
                latitude = Double.parseDouble(latitudeString);
            }
            catch (NumberFormatException e) {
                TuneDebugLog.e("TUNE", "Error parsing latitude value " + latitudeString, e);
            }
        }
        return latitude;
    }

    public String getLocale() {
        return this.params.getLocale();
    }

    public double getLongitude() {
        String longitudeString = this.params.getLongitude();
        double longitude = 0.0;
        if (longitudeString != null) {
            try {
                longitude = Double.parseDouble(longitudeString);
            }
            catch (NumberFormatException e) {
                TuneDebugLog.e("TUNE", "Error parsing longitude value " + longitudeString, e);
            }
        }
        return longitude;
    }

    public String getMacAddress() {
        return this.params.getMacAddress();
    }

    public String getMatId() {
        return this.params.getMatId();
    }

    public String getMCC() {
        return this.params.getMCC();
    }

    public String getMNC() {
        return this.params.getMNC();
    }

    public String getOpenLogId() {
        return this.params.getOpenLogId();
    }

    public String getOsVersion() {
        return this.params.getOsVersion();
    }

    public String getPackageName() {
        return this.params.getPackageName();
    }

    public String getPluginName() {
        return this.params.getPluginName();
    }

    public String getReferralSource() {
        return this.params.getReferralSource();
    }

    public String getReferralUrl() {
        return this.params.getReferralUrl();
    }

    public String getScreenDensity() {
        return this.params.getScreenDensity();
    }

    public String getScreenHeight() {
        return this.params.getScreenHeight();
    }

    public String getScreenWidth() {
        return this.params.getScreenWidth();
    }

    public String getSDKVersion() {
        return this.params.getSdkVersion();
    }

    public String getTRUSTeId() {
        return this.params.getTRUSTeId();
    }

    public String getTwitterUserId() {
        return this.params.getTwitterUserId();
    }

    public String getUserAgent() {
        return this.params.getUserAgent();
    }

    public String getUserEmail() {
        return this.params.getUserEmail();
    }

    public String getUserId() {
        return this.params.getUserId();
    }

    public String getUserName() {
        return this.params.getUserName();
    }

    public void setAdvertiserId(final String advertiserId) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setAdvertiserId(advertiserId);
            }
        });
    }

    public void setAge(final int age) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setAge(Integer.toString(age));
            }
        });
    }

    public void setAltitude(final double altitude) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setAltitude(Double.toString(altitude));
            }
        });
    }

    public void setAndroidId(String androidId) {
        if (this.params != null) {
            this.params.setAndroidId(androidId);
            if (this.dplinkr != null) {
                this.dplinkr.setAndroidId(androidId);
                this.requestDeferredDeeplink();
            }
        }
    }

    public void setAndroidIdMd5(final String androidIdMd5) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setAndroidIdMd5(androidIdMd5);
            }
        });
    }

    public void setAndroidIdSha1(final String androidIdSha1) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setAndroidIdSha1(androidIdSha1);
            }
        });
    }

    public void setAndroidIdSha256(final String androidIdSha256) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setAndroidIdSha256(androidIdSha256);
            }
        });
    }

    public void setAppAdTrackingEnabled(final boolean adTrackingEnabled) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                if (adTrackingEnabled) {
                    Tune.this.params.setAppAdTrackingEnabled(Integer.toString(1));
                } else {
                    Tune.this.params.setAppAdTrackingEnabled(Integer.toString(0));
                }
            }
        });
    }

    public void setConversionKey(final String conversionKey) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setConversionKey(conversionKey);
            }
        });
    }

    public void setCurrencyCode(final String currencyCode) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                if (currencyCode == null || currencyCode.equals("")) {
                    Tune.this.params.setCurrencyCode("USD");
                } else {
                    Tune.this.params.setCurrencyCode(currencyCode);
                }
            }
        });
    }

    public void setDeviceBrand(final String deviceBrand) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setDeviceBrand(deviceBrand);
            }
        });
    }

    public void setDeviceBuild(final String deviceBuild) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setDeviceBuild(deviceBuild);
            }
        });
    }

    public void setDeviceId(final String deviceId) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setDeviceId(deviceId);
            }
        });
    }

    public void setDeviceModel(final String deviceModel) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setDeviceModel(deviceModel);
            }
        });
    }

    public void setExistingUser(final boolean existing) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                if (existing) {
                    Tune.this.params.setExistingUser(Integer.toString(1));
                } else {
                    Tune.this.params.setExistingUser(Integer.toString(0));
                }
            }
        });
    }

    public void setFacebookUserId(final String userId) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setFacebookUserId(userId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFireAdvertisingId(String adId, boolean isLATEnabled) {
        int intLimit;
        int n = intLimit = isLATEnabled ? 1 : 0;
        if (this.params != null) {
            this.params.setFireAdvertisingId(adId);
            this.params.setFireAdTrackingLimited(Integer.toString(intLimit));
            if (this.dplinkr != null) {
                this.dplinkr.setFireAdvertisingId(adId, intLimit);
                this.requestDeferredDeeplink();
            }
        }
        this.gotAdvertisingId = true;
        if (this.gotReferrer && !this.notifiedPool) {
            ExecutorService executorService = this.pool;
            synchronized (executorService) {
                this.pool.notifyAll();
                this.notifiedPool = true;
            }
        }
    }

    public void setGender(final TuneGender gender) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setGender(gender);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGoogleAdvertisingId(String adId, boolean isLATEnabled) {
        int intLimit;
        int n = intLimit = isLATEnabled ? 1 : 0;
        if (this.params != null) {
            this.params.setGoogleAdvertisingId(adId);
            this.params.setGoogleAdTrackingLimited(Integer.toString(intLimit));
            if (this.dplinkr != null) {
                this.dplinkr.setGoogleAdvertisingId(adId, intLimit);
                this.requestDeferredDeeplink();
            }
        }
        this.gotAdvertisingId = true;
        if (this.gotReferrer && !this.notifiedPool) {
            ExecutorService executorService = this.pool;
            synchronized (executorService) {
                this.pool.notifyAll();
                this.notifiedPool = true;
            }
        }
    }

    public void setGoogleUserId(final String userId) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setGoogleUserId(userId);
            }
        });
    }

    public void setInstallReferrer(final String referrer) {
        this.gotReferrer = true;
        this.referrerTime = System.currentTimeMillis();
        if (this.params != null) {
            this.params.setReferrerDelay(this.referrerTime - this.initTime);
        }
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setInstallReferrer(referrer);
            }
        });
    }

    public void setIsPayingUser(final boolean isPayingUser) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                if (isPayingUser) {
                    Tune.this.params.setIsPayingUser(Integer.toString(1));
                } else {
                    Tune.this.params.setIsPayingUser(Integer.toString(0));
                }
            }
        });
    }

    public void setLocale(final String locale) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setLocale(locale);
            }
        });
    }

    public void setLocation(Location location) {
        TuneLocation loc = null == location ? null : new TuneLocation(location);
        this.setLocation(loc);
    }

    public void setLocation(final TuneLocation location) {
        if (location == null) {
            TuneDebugLog.e("TUNE", "Location may not be null");
            return;
        }
        this.setShouldAutoCollectDeviceLocation(false);
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setLocation(location);
            }
        });
    }

    public void setLatitude(final double latitude) {
        this.setShouldAutoCollectDeviceLocation(false);
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setLatitude(Double.toString(latitude));
            }
        });
    }

    public void setLongitude(final double longitude) {
        this.setShouldAutoCollectDeviceLocation(false);
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setLongitude(Double.toString(longitude));
            }
        });
    }

    public void setListener(TuneListener listener) {
        this.tuneListener = listener;
    }

    public void setMacAddress(final String macAddress) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setMacAddress(macAddress);
            }
        });
    }

    public void setOsVersion(final String osVersion) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setOsVersion(osVersion);
            }
        });
    }

    public void setPackageName(final String packageName) {
        this.dplinkr.setPackageName(packageName);
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                String pkg = TextUtils.isEmpty((CharSequence)packageName) ? Tune.this.mContext.getPackageName() : packageName;
                Tune.this.params.setPackageName(pkg);
                if (TuneSmartWhere.getInstance().isSmartWhereAvailable()) {
                    TuneSmartWhere.getInstance().setPackageName(Tune.this.mContext, pkg);
                }
            }
        });
    }

    public void setPhoneNumber(final String phoneNumber) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                if (TextUtils.isEmpty((CharSequence)phoneNumber)) {
                    Tune.this.params.setPhoneNumber(phoneNumber);
                } else {
                    String phoneNumberDigits = phoneNumber.replaceAll("\\D+", "");
                    StringBuilder digitsBuilder = new StringBuilder();
                    for (int i = 0; i < phoneNumberDigits.length(); ++i) {
                        int numberParsed = Integer.parseInt(String.valueOf(phoneNumberDigits.charAt(i)));
                        digitsBuilder.append(numberParsed);
                    }
                    Tune.this.params.setPhoneNumber(digitsBuilder.toString());
                }
            }
        });
    }

    public void setPreloadedApp(TunePreloadData preloadData) {
        this.mPreloadData = preloadData;
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_id", preloadData.publisherId)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("offer_id", preloadData.offerId)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("agency_id", preloadData.agencyId)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_ref_id", preloadData.publisherReferenceId)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_sub_publisher", preloadData.publisherSubPublisher)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_sub_site", preloadData.publisherSubSite)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_sub_campaign", preloadData.publisherSubCampaign)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_sub_adgroup", preloadData.publisherSubAdgroup)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_sub_ad", preloadData.publisherSubAd)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_sub_keyword", preloadData.publisherSubKeyword)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_sub1", preloadData.publisherSub1)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_sub2", preloadData.publisherSub2)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_sub3", preloadData.publisherSub3)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_sub4", preloadData.publisherSub4)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("publisher_sub5", preloadData.publisherSub5)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("advertiser_sub_publisher", preloadData.advertiserSubPublisher)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("advertiser_sub_site", preloadData.advertiserSubSite)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("advertiser_sub_campaign", preloadData.advertiserSubCampaign)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("advertiser_sub_adgroup", preloadData.advertiserSubAdgroup)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("advertiser_sub_ad", preloadData.advertiserSubAd)));
        TuneEventBus.post(new TuneUpdateUserProfile(new TuneAnalyticsVariable("advertiser_sub_keyword", preloadData.advertiserSubKeyword)));
    }

    @Deprecated
    public void setReferralSources(Activity act) {
        Uri uri;
        TuneDebugLog.w("Call to DEPRECATED method tune.setReferralSources() As of Tune Android SDK v4.8.0 you do not need to call this method directly. This method will be removed in Tune Android SDK v5.0.0");
        this.setReferralCallingPackage(act.getCallingPackage());
        Intent intent = act.getIntent();
        if (intent != null && (uri = intent.getData()) != null) {
            this.setReferralUrl(uri.toString());
        }
    }

    public void setReferralCallingPackage(final @Nullable String referralCallingPackage) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setReferralSource(referralCallingPackage);
            }
        });
    }

    public void setReferralUrl(final String url) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setReferralUrl(url);
            }
        });
        if (url != null && this.isTuneLink(url)) {
            block5: {
                try {
                    TuneOptional<String> invokeUrl = this.invokeUrlFromReferralUrl(url);
                    if (!invokeUrl.isPresent()) break block5;
                    this.dplinkr.handleExpandedTuneLink(invokeUrl.get());
                }
                catch (Exception e) {
                    try {
                        this.dplinkr.handleFailedExpandedTuneLink("Error accessing invoke_url from clicked Tune Link");
                    }
                    catch (Throwable throwable) {
                        this.pubQueue.execute(new Runnable(url){
                            final /* synthetic */ String val$url;
                            {
                                this.val$url = string;
                            }

                            @Override
                            public void run() {
                                Tune.this.measureTuneLinkClick(this.val$url);
                            }
                        });
                        throw throwable;
                    }
                    this.pubQueue.execute(new /* invalid duplicate definition of identical inner class */);
                }
            }
            this.pubQueue.execute(new /* invalid duplicate definition of identical inner class */);
        }
    }

    public void setTRUSTeId(final String tpid) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setTRUSTeId(tpid);
            }
        });
    }

    public void setTwitterUserId(final String userId) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setTwitterUserId(userId);
            }
        });
    }

    public void setUserEmail(final String userEmail) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setUserEmail(userEmail);
            }
        });
    }

    public void setUserId(final String userId) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setUserId(userId);
            }
        });
    }

    public void setUserName(final String userName) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setUserName(userName);
            }
        });
    }

    public void setPluginName(final String pluginName) {
        if (Arrays.asList(TuneConstants.PLUGIN_NAMES).contains(pluginName)) {
            this.pubQueue.execute(new Runnable(){

                @Override
                public void run() {
                    Tune.this.params.setPluginName(pluginName);
                }
            });
        } else if (this.debugMode) {
            throw new IllegalArgumentException("Plugin name not acceptable");
        }
    }

    public void setDebugMode(final boolean debug) {
        this.debugMode = debug;
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                Tune.this.params.setDebugMode(debug);
                if (TuneSmartWhere.getInstance().isSmartWhereAvailable()) {
                    TuneSmartWhere.getInstance().setDebugMode(Tune.this.mContext, debug);
                }
            }
        });
        if (debug) {
            TuneDebugLog.enableLog();
            TuneDebugLog.setLogLevel(3);
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)Tune.this.mContext, (CharSequence)"TUNE Debug Mode Enabled, do not release with this enabled!!", (int)1).show();
                }
            });
        } else {
            TuneDebugLog.setLogLevel(6);
        }
    }

    public boolean isInDebugMode() {
        return this.debugMode;
    }

    public void setEmailCollection(final boolean collectEmail) {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                boolean accountPermission = TuneUtils.hasPermission(Tune.this.mContext, "android.permission.GET_ACCOUNTS");
                if (collectEmail && accountPermission) {
                    Account[] accounts = AccountManager.get((Context)Tune.this.mContext).getAccountsByType("com.google");
                    if (accounts.length > 0) {
                        Tune.this.params.setUserEmail(accounts[0].name);
                    }
                    HashMap<String, String> emailMap = new HashMap<String, String>();
                    for (Account account : accounts = AccountManager.get((Context)Tune.this.mContext).getAccounts()) {
                        if (Patterns.EMAIL_ADDRESS.matcher(account.name).matches()) {
                            emailMap.put(account.name, account.type);
                        }
                        Set emailKeys = emailMap.keySet();
                        String[] emailArr = emailKeys.toArray(new String[emailKeys.size()]);
                        Tune.this.params.setUserEmails(emailArr);
                    }
                }
            }
        });
    }

    public void setFacebookEventLogging(boolean logging, Context context, boolean limitEventAndDataUsage) {
        this.fbLogging = logging;
        if (logging && context != null) {
            TuneFBBridge.startLogger(context, limitEventAndDataUsage);
        }
    }

    public void setShouldAutoCollectDeviceLocation(boolean autoCollect) {
        this.collectLocation = autoCollect;
        if (this.collectLocation) {
            this.locationListener.startListening();
            this.startSmartWhereLocationMonitoring();
        } else {
            this.locationListener.stopListening();
            this.stopSmartWhereLocationMonitoring();
        }
    }

    public void registerPowerHook(String hookId, String friendlyName, String defaultValue) {
        if (TuneManager.getPowerHookManagerForUser("registerPowerHook") == null) {
            return;
        }
        TuneManager.getInstance().getPowerHookManager().registerPowerHook(hookId, friendlyName, defaultValue, null, null);
    }

    private void registerPowerHook(String hookId, String friendlyName, String defaultValue, String description, List<String> approvedValues) {
        if (TuneManager.getPowerHookManagerForUser("registerPowerHook") == null) {
            return;
        }
        TuneManager.getInstance().getPowerHookManager().registerPowerHook(hookId, friendlyName, defaultValue, description, approvedValues);
    }

    public String getValueForHookById(String hookId) {
        if (TuneManager.getPowerHookManagerForUser("getValueForHookById") == null) {
            return null;
        }
        return TuneManager.getInstance().getPowerHookManager().getValueForHookById(hookId);
    }

    public void setValueForHookById(String hookId, String value) {
        if (TuneManager.getPowerHookManagerForUser("setValueForHookById") == null) {
            return;
        }
        TuneManager.getInstance().getPowerHookManager().setValueForHookById(hookId, value);
    }

    public void onPowerHooksChanged(TuneCallback callback) {
        if (TuneManager.getPowerHookManagerForUser("onPowerHooksChanged") == null) {
            return;
        }
        TuneManager.getInstance().getPowerHookManager().onPowerHooksChanged(callback);
    }

    public void registerDeepAction(String actionId, String friendlyName, Map<String, String> defaultData, TuneDeepActionCallback action) {
        if (TuneManager.getDeepActionManagerForUser("registerDeepAction") == null) {
            return;
        }
        TuneManager.getInstance().getDeepActionManager().registerDeepAction(actionId, friendlyName, null, defaultData, null, action);
    }

    public void executeDeepAction(Activity activity, String actionId, Map<String, String> data) {
        if (TuneManager.getDeepActionManagerForUser("executeDeepAction") == null) {
            return;
        }
        TuneManager.getInstance().getDeepActionManager().executeDeepAction(activity, actionId, data);
    }

    private void registerDeepAction(String actionId, String friendlyName, String description, Map<String, String> defaultData, TuneDeepActionCallback action) {
        if (TuneManager.getDeepActionManagerForUser("registerDeepAction") == null) {
            return;
        }
        TuneManager.getInstance().getDeepActionManager().registerDeepAction(actionId, friendlyName, description, defaultData, null, action);
    }

    private void registerDeepAction(String actionId, String friendlyName, String description, Map<String, String> defaultData, Map<String, List<String>> approvedValues, TuneDeepActionCallback action) {
        if (TuneManager.getDeepActionManagerForUser("registerDeepAction") == null) {
            return;
        }
        TuneManager.getInstance().getDeepActionManager().registerDeepAction(actionId, friendlyName, description, defaultData, approvedValues, action);
    }

    public Map<String, TunePowerHookExperimentDetails> getPowerHookExperimentDetails() {
        if (TuneManager.getExperimentManagerForUser("getPowerHookExperimentDetails") == null) {
            return null;
        }
        return TuneManager.getInstance().getExperimentManager().getPhookExperimentDetails();
    }

    public Map<String, TuneInAppMessageExperimentDetails> getInAppMessageExperimentDetails() {
        if (TuneManager.getExperimentManagerForUser("getInAppMessageExperimentDetails") == null) {
            return null;
        }
        return TuneManager.getInstance().getExperimentManager().getInAppExperimentDetails();
    }

    public void onFirstPlaylistDownloaded(TuneCallback callback) {
        if (TuneManager.getPlaylistManagerForUser("onFirstPlaylistDownloaded") == null) {
            return;
        }
        TuneManager.getInstance().getPlaylistManager().onFirstPlaylistDownloaded(callback, TuneConstants.DEFAULT_FIRST_PLAYLIST_DOWNLOADED_TIMEOUT);
    }

    public void onFirstPlaylistDownloaded(TuneCallback callback, long timeout) {
        if (TuneManager.getPlaylistManagerForUser("onFirstPlaylistDownloaded") == null) {
            return;
        }
        TuneManager.getInstance().getPlaylistManager().onFirstPlaylistDownloaded(callback, timeout);
    }

    public void setPushNotificationSenderId(String pushSenderId) {
        if (TuneManager.getPushManagerForUser("setPushNotificationSenderId") == null) {
            return;
        }
        TuneManager.getInstance().getPushManager().setPushNotificationSenderId(pushSenderId);
    }

    public void setPushNotificationRegistrationId(String registrationId) {
        if (TuneManager.getPushManagerForUser("setPushNotificationRegistrationId") == null) {
            return;
        }
        TuneManager.getInstance().getPushManager().setPushNotificationRegistrationId(registrationId);
    }

    public void setPushNotificationBuilder(TuneNotificationBuilder builder) {
        if (TuneManager.getPushManagerForUser("setPushNotificationBuilder") == null) {
            return;
        }
        TuneManager.getInstance().getPushManager().setTuneNotificationBuilder(builder);
    }

    public void setOptedOutOfPush(boolean optedOutOfPush) {
        if (TuneManager.getPushManagerForUser("setOptedOutOfPush") == null) {
            return;
        }
        TuneManager.getInstance().getPushManager().setOptedOutOfPush(optedOutOfPush);
    }

    public String getDeviceToken() {
        if (TuneManager.getPushManagerForUser("getDeviceToken") == null) {
            return null;
        }
        return TuneManager.getInstance().getPushManager().getDeviceToken();
    }

    public boolean didUserManuallyDisablePush() {
        if (TuneManager.getPushManagerForUser("didUserManuallyDisablePush") == null) {
            return false;
        }
        return TuneManager.getInstance().getPushManager().didUserManuallyDisablePush();
    }

    public boolean didSessionStartFromTunePush() {
        if (TuneManager.getPushManagerForUser("didSessionStartFromTunePush") == null) {
            return false;
        }
        return TuneManager.getInstance().getPushManager().didOpenFromTunePushThisSession();
    }

    public TunePushInfo getTunePushInfoForSession() {
        if (TuneManager.getPushManagerForUser("getTunePushInfoForSession") == null) {
            return null;
        }
        return TuneManager.getInstance().getPushManager().getLastOpenedPushInfo();
    }

    public boolean isUserInSegmentId(String segmentId) {
        if (TuneManager.getPlaylistManagerForUser("isUserInSegmentId") == null) {
            return false;
        }
        return TuneManager.getInstance().getPlaylistManager().isUserInSegmentId(segmentId);
    }

    public boolean isUserInAnySegmentIds(List<String> segmentIds) {
        if (TuneManager.getPlaylistManagerForUser("isUserInAnySegmentIds") == null) {
            return false;
        }
        return TuneManager.getInstance().getPlaylistManager().isUserInAnySegmentIds(segmentIds);
    }

    @Deprecated
    public void checkForDeferredDeeplink(TuneDeeplinkListener listener) {
        TuneDebugLog.w("Call to DEPRECATED method tune.checkForDeferredDeeplink(TuneDeeplinkListener) instead call tune.registerDeeplinkListener(TuneDeeplinkListener). This method will be removed in Tune Android SDK v5.0.0");
        this.registerDeeplinkListener(listener);
    }

    @Deprecated
    public void setDeeplinkListener(TuneDeeplinkListener listener) {
        TuneDebugLog.w("Call to DEPRECATED method tune.setDeeplinkListener(TuneDeeplinkListener) instead call tune.registerDeeplinkListener(TuneDeeplinkListener). This method will be removed in Tune Android SDK v5.0.0");
        this.registerDeeplinkListener(listener);
    }

    public void unregisterDeeplinkListener() {
        this.dplinkr.setListener(null);
    }

    public void registerDeeplinkListener(@Nullable TuneDeeplinkListener listener) {
        this.dplinkr.setListener(listener);
        this.requestDeferredDeeplink();
    }

    private void requestDeferredDeeplink() {
        boolean shouldRequestDeferredDeeplink;
        boolean bl = shouldRequestDeferredDeeplink = this.isFirstInstall && this.dplinkr != null && this.params != null;
        if (shouldRequestDeferredDeeplink) {
            this.dplinkr.requestDeferredDeeplink(this.params.getUserAgent(), this.mContext, this.urlRequester);
        }
    }

    public void registerCustomTuneLinkDomain(@NonNull String domainSuffix) {
        this.dplinkr.registerCustomTuneLinkDomain(domainSuffix);
    }

    public boolean isTuneLink(@NonNull String appLinkUrl) {
        return this.dplinkr.isTuneLink(appLinkUrl);
    }

    protected void setUrlRequester(UrlRequester urlRequester) {
        this.urlRequester = urlRequester;
    }

    public void registerCustomProfileString(String variableName) {
        if (TuneManager.getProfileForUser("registerCustomProfileString") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().registerCustomProfileVariable(TuneAnalyticsVariable.Builder(variableName).withType(TuneVariableType.STRING).build());
    }

    public void registerCustomProfileDate(String variableName) {
        if (TuneManager.getProfileForUser("registerCustomProfileDate") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().registerCustomProfileVariable(TuneAnalyticsVariable.Builder(variableName).withType(TuneVariableType.DATETIME).build());
    }

    public void registerCustomProfileNumber(String variableName) {
        if (TuneManager.getProfileForUser("registerCustomProfileNumber") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().registerCustomProfileVariable(TuneAnalyticsVariable.Builder(variableName).withType(TuneVariableType.FLOAT).build());
    }

    public void registerCustomProfileGeolocation(String variableName) {
        if (TuneManager.getProfileForUser("registerCustomProfileGeolocation") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().registerCustomProfileVariable(TuneAnalyticsVariable.Builder(variableName).withType(TuneVariableType.GEOLOCATION).build());
    }

    public void registerCustomProfileString(String variableName, String defaultValue) {
        if (TuneManager.getProfileForUser("registerCustomProfileString") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().registerCustomProfileVariable(new TuneAnalyticsVariable(variableName, defaultValue));
    }

    public void registerCustomProfileDate(String variableName, Date defaultValue) {
        if (TuneManager.getProfileForUser("registerCustomProfileDate") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().registerCustomProfileVariable(new TuneAnalyticsVariable(variableName, defaultValue));
    }

    public void registerCustomProfileNumber(String variableName, int defaultValue) {
        if (TuneManager.getProfileForUser("registerCustomProfileNumber") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().registerCustomProfileVariable(new TuneAnalyticsVariable(variableName, defaultValue));
    }

    public void registerCustomProfileNumber(String variableName, double defaultValue) {
        if (TuneManager.getProfileForUser("registerCustomProfileNumber") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().registerCustomProfileVariable(new TuneAnalyticsVariable(variableName, defaultValue));
    }

    public void registerCustomProfileNumber(String variableName, float defaultValue) {
        if (TuneManager.getProfileForUser("registerCustomProfileNumber") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().registerCustomProfileVariable(new TuneAnalyticsVariable(variableName, defaultValue));
    }

    public void registerCustomProfileGeolocation(String variableName, TuneLocation defaultValue) {
        if (TuneManager.getProfileForUser("registerCustomProfileGeolocation") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().registerCustomProfileVariable(new TuneAnalyticsVariable(variableName, defaultValue));
    }

    public void setCustomProfileStringValue(String variableName, String value) {
        if (TuneManager.getProfileForUser("setCustomProfileStringValue") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().setCustomProfileVariable(new TuneAnalyticsVariable(variableName, value));
    }

    public void setCustomProfileDate(String variableName, Date value) {
        if (TuneManager.getProfileForUser("setCustomProfileDate") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().setCustomProfileVariable(new TuneAnalyticsVariable(variableName, value));
    }

    public void setCustomProfileNumber(String variableName, int value) {
        if (TuneManager.getProfileForUser("setCustomProfileNumber") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().setCustomProfileVariable(new TuneAnalyticsVariable(variableName, value));
    }

    public void setCustomProfileNumber(String variableName, double value) {
        if (TuneManager.getProfileForUser("setCustomProfileNumber") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().setCustomProfileVariable(new TuneAnalyticsVariable(variableName, value));
    }

    public void setCustomProfileNumber(String variableName, float value) {
        if (TuneManager.getProfileForUser("setCustomProfileNumber") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().setCustomProfileVariable(new TuneAnalyticsVariable(variableName, value));
    }

    public void setCustomProfileGeolocation(String variableName, TuneLocation value) {
        if (TuneManager.getProfileForUser("setCustomProfileGeolocation") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().setCustomProfileVariable(new TuneAnalyticsVariable(variableName, value));
    }

    public String getCustomProfileString(String variableName) {
        if (TuneManager.getProfileForUser("getCustomProfileString") == null) {
            return null;
        }
        TuneAnalyticsVariable var = TuneManager.getInstance().getProfileManager().getCustomProfileVariable(variableName);
        if (var == null) {
            return null;
        }
        return var.getValue();
    }

    public Date getCustomProfileDate(String variableName) {
        if (TuneManager.getProfileForUser("getCustomProfileDate") == null) {
            return null;
        }
        TuneAnalyticsVariable var = TuneManager.getInstance().getProfileManager().getCustomProfileVariable(variableName);
        if (var == null) {
            return null;
        }
        return TuneAnalyticsVariable.stringToDate(var.getValue());
    }

    public Number getCustomProfileNumber(String variableName) {
        if (TuneManager.getProfileForUser("getCustomProfileNumber") == null) {
            return null;
        }
        TuneAnalyticsVariable var = TuneManager.getInstance().getProfileManager().getCustomProfileVariable(variableName);
        if (var == null || var.getValue() == null) {
            return null;
        }
        return new BigDecimal(var.getValue());
    }

    public TuneLocation getCustomProfileGeolocation(String variableName) {
        if (TuneManager.getProfileForUser("getCustomProfileGeolocation") == null) {
            return null;
        }
        TuneAnalyticsVariable var = TuneManager.getInstance().getProfileManager().getCustomProfileVariable(variableName);
        if (var == null) {
            return null;
        }
        return TuneAnalyticsVariable.stringToGeolocation(var.getValue());
    }

    public String getAppId() {
        if (TuneManager.getProfileForUser("getAppId") == null) {
            return null;
        }
        return TuneManager.getInstance().getProfileManager().getAppId();
    }

    public void clearCustomProfileVariable(String variableName) {
        if (TuneManager.getProfileForUser("clearCustomProfileVariable") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().clearCertainCustomProfileVariable(variableName);
    }

    public void clearAllCustomProfileVariables() {
        if (TuneManager.getProfileForUser("clearAllCustomProfileVariables") == null) {
            return;
        }
        TuneManager.getInstance().getProfileManager().clearAllCustomProfileVariables();
    }

    private void startSmartWhereLocationMonitoring() {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                if (TuneSmartWhere.getInstance().isSmartWhereAvailable()) {
                    TuneSmartWhere.getInstance().startMonitoring(Tune.this.mContext, Tune.this.params.getAdvertiserId(), Tune.this.params.getConversionKey(), Tune.this.isInDebugMode());
                }
            }
        });
    }

    private void stopSmartWhereLocationMonitoring() {
        this.pubQueue.execute(new Runnable(){

            @Override
            public void run() {
                if (TuneSmartWhere.getInstance().isSmartWhereAvailable()) {
                    TuneSmartWhere.getInstance().stopMonitoring(Tune.this.mContext);
                }
            }
        });
    }
}

