package com.tune.ma.analytics.model;

public enum TuneEventType {
    EVENT, // General app events whether generated by Artisan SDK based on user actions or tracked by customers manually
    SESSION, // App foreground/background events
    PAGEVIEW, // Page view events, automatically generated by the Artisan SDK
    TRACER, // Tracer events, automatically generated by the Artisan SDK
    PUSH_NOTIFICATION, // For push notification (remote notification) that come across GCM
    LOCAL_NOTIFICATION, // This isn't used on android yet. For local notification, notifications initiated from the app instead of coming across GCM
    SOCIAL_SHARING, // This isn't used on android yet. For social shares, like share on facebook, twitter
    TRANSACTION, // This isn't used on android yet. Used for commerce analytics for when a transaction is completed/cancelled/failed
    PRODUCT, // This isn't used on android yet. Used for commerce analytics for when a product is added/removed/purchased
    APP_OPENED_BY_URL, // This isn't used on android yet
    CLEAR_PROFILE, // User profile cleared
    CLEAR_VARIABLE; // User profile variable cleared
}
