/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal.convert;

import com.tngtech.java.junit.dataprovider.internal.convert.AbstractObjectConverter;
import java.lang.reflect.Array;

public class ObjectArrayConverter
extends AbstractObjectConverter<Object[]> {
    @Override
    public Object[] convert(Object[] data, boolean isVarArgs, Class<?>[] parameterTypes) {
        Object[] result = new Object[parameterTypes.length];
        int lastArgIdx = parameterTypes.length - 1;
        for (int idx = 0; idx < lastArgIdx; ++idx) {
            result[idx] = data[idx];
        }
        result[lastArgIdx] = isVarArgs ? this.convertVarArgArgument(data, parameterTypes[lastArgIdx].getComponentType(), lastArgIdx) : data[data.length - 1];
        this.checkIfArgumentsMatchParameterTypes(result, parameterTypes);
        return result;
    }

    private Object convertVarArgArgument(Object[] data, Class<?> varArgComponentType, int nonVarArgParameters) {
        if (data.length > 0) {
            Class<?> lastArgType;
            Object date = data[data.length - 1];
            Class<?> clazz = lastArgType = date != null ? date.getClass() : null;
            if (lastArgType != null && lastArgType.isArray() && lastArgType.getComponentType() == varArgComponentType) {
                return date;
            }
        }
        Object varArgArray = Array.newInstance(varArgComponentType, data.length - nonVarArgParameters);
        for (int idx = nonVarArgParameters; idx < data.length; ++idx) {
            Array.set(varArgArray, idx - nonVarArgParameters, data[idx]);
        }
        return varArgArray;
    }
}

