/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.Type;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Annotation
implements Serializable {
    private final Type type;
    private final int lineNumber;
    private Map namedParameters;
    private AbstractJavaEntity context;

    public Annotation(Type type, AbstractJavaEntity context, Map namedParameters, int lineNumber) {
        this.type = type;
        this.context = context;
        this.namedParameters = namedParameters == null ? new HashMap(0) : namedParameters;
        this.lineNumber = lineNumber;
    }

    public Type getType() {
        return this.type;
    }

    public Object getNamedParameter(String key) {
        return this.namedParameters.get(key);
    }

    public Map getNamedParameterMap() {
        return this.namedParameters;
    }

    public final AbstractJavaEntity getContext() {
        return this.context;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('@');
        result.append(this.type.getValue());
        result.append('(');
        if (!this.namedParameters.isEmpty()) {
            Iterator i = this.namedParameters.entrySet().iterator();
            while (i.hasNext()) {
                result.append(i.next() + ",");
            }
            result.deleteCharAt(result.length() - 1);
        }
        result.append(')');
        return result.toString();
    }
}

