/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtbot.expandablerecyclerview.models;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public class ExpandableGroup<T extends Parcelable>
implements Parcelable {
    private String title;
    private List<T> items;
    public static final Parcelable.Creator<ExpandableGroup> CREATOR = new Parcelable.Creator<ExpandableGroup>(){

        public ExpandableGroup createFromParcel(Parcel in) {
            return new ExpandableGroup(in);
        }

        public ExpandableGroup[] newArray(int size) {
            return new ExpandableGroup[size];
        }
    };

    public ExpandableGroup(String title, List<T> items) {
        this.title = title;
        this.items = items;
    }

    public String getTitle() {
        return this.title;
    }

    public List<T> getItems() {
        return this.items;
    }

    public int getItemCount() {
        return this.items == null ? 0 : this.items.size();
    }

    public String toString() {
        return "ExpandableGroup{title='" + this.title + '\'' + ", items=" + this.items + '}';
    }

    protected ExpandableGroup(Parcel in) {
        this.title = in.readString();
        byte hasItems = in.readByte();
        int size = in.readInt();
        if (hasItems == 1) {
            this.items = new ArrayList<T>(size);
            Class type = (Class)in.readSerializable();
            in.readList(this.items, type.getClassLoader());
        } else {
            this.items = null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.title);
        if (this.items == null) {
            dest.writeByte((byte)0);
            dest.writeInt(0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.items.size());
            Class<?> objectsType = ((Parcelable)this.items.get(0)).getClass();
            dest.writeSerializable(objectsType);
            dest.writeList(this.items);
        }
    }
}

