/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtbot.expandablerecyclerview;

import android.os.Bundle;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.thoughtbot.expandablerecyclerview.ExpandCollapseController;
import com.thoughtbot.expandablerecyclerview.listeners.ExpandCollapseListener;
import com.thoughtbot.expandablerecyclerview.listeners.GroupExpandCollapseListener;
import com.thoughtbot.expandablerecyclerview.listeners.OnGroupClickListener;
import com.thoughtbot.expandablerecyclerview.models.ExpandableGroup;
import com.thoughtbot.expandablerecyclerview.models.ExpandableList;
import com.thoughtbot.expandablerecyclerview.models.ExpandableListPosition;
import com.thoughtbot.expandablerecyclerview.viewholders.ChildViewHolder;
import com.thoughtbot.expandablerecyclerview.viewholders.GroupViewHolder;
import java.util.List;

public abstract class ExpandableRecyclerViewAdapter<GVH extends GroupViewHolder, CVH extends ChildViewHolder>
extends RecyclerView.Adapter
implements ExpandCollapseListener,
OnGroupClickListener {
    private static final String EXPAND_STATE_MAP = "expandable_recyclerview_adapter_expand_state_map";
    protected ExpandableList expandableList;
    private ExpandCollapseController expandCollapseController;
    private OnGroupClickListener groupClickListener;
    private GroupExpandCollapseListener expandCollapseListener;

    public ExpandableRecyclerViewAdapter(List<? extends ExpandableGroup> groups) {
        this.expandableList = new ExpandableList(groups);
        this.expandCollapseController = new ExpandCollapseController(this.expandableList, this);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 2: {
                GVH gvh = this.onCreateGroupViewHolder(parent, viewType);
                ((GroupViewHolder)((Object)gvh)).setOnGroupClickListener(this);
                return gvh;
            }
            case 1: {
                CVH cvh = this.onCreateChildViewHolder(parent, viewType);
                return cvh;
            }
        }
        throw new IllegalArgumentException("viewType is not valid");
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        ExpandableListPosition listPos = this.expandableList.getUnflattenedPosition(position);
        ExpandableGroup group = this.expandableList.getExpandableGroup(listPos);
        switch (listPos.type) {
            case 2: {
                this.onBindGroupViewHolder((GroupViewHolder)holder, position, group);
                if (this.isGroupExpanded(group)) {
                    ((GroupViewHolder)holder).expand();
                    break;
                }
                ((GroupViewHolder)holder).collapse();
                break;
            }
            case 1: {
                this.onBindChildViewHolder((ChildViewHolder)holder, position, group, listPos.childPos);
            }
        }
    }

    public int getItemCount() {
        return this.expandableList.getVisibleItemCount();
    }

    public int getItemViewType(int position) {
        return this.expandableList.getUnflattenedPosition((int)position).type;
    }

    @Override
    public void onGroupExpanded(int positionStart, int itemCount) {
        int headerPosition = positionStart - 1;
        this.notifyItemChanged(headerPosition);
        if (itemCount > 0) {
            this.notifyItemRangeInserted(positionStart, itemCount);
            if (this.expandCollapseListener != null) {
                int groupIndex = this.expandableList.getUnflattenedPosition((int)positionStart).groupPos;
                this.expandCollapseListener.onGroupExpanded(this.getGroups().get(groupIndex));
            }
        }
    }

    @Override
    public void onGroupCollapsed(int positionStart, int itemCount) {
        int headerPosition = positionStart - 1;
        this.notifyItemChanged(headerPosition);
        if (itemCount > 0) {
            this.notifyItemRangeRemoved(positionStart, itemCount);
            if (this.expandCollapseListener != null) {
                int groupIndex = this.expandableList.getUnflattenedPosition((int)(positionStart - 1)).groupPos;
                this.expandCollapseListener.onGroupCollapsed(this.getGroups().get(groupIndex));
            }
        }
    }

    @Override
    public boolean onGroupClick(int flatPos) {
        if (this.groupClickListener != null) {
            this.groupClickListener.onGroupClick(flatPos);
        }
        return this.expandCollapseController.toggleGroup(flatPos);
    }

    public boolean toggleGroup(int flatPos) {
        return this.expandCollapseController.toggleGroup(flatPos);
    }

    public boolean toggleGroup(ExpandableGroup group) {
        return this.expandCollapseController.toggleGroup(group);
    }

    public boolean isGroupExpanded(int flatPos) {
        return this.expandCollapseController.isGroupExpanded(flatPos);
    }

    public boolean isGroupExpanded(ExpandableGroup group) {
        return this.expandCollapseController.isGroupExpanded(group);
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putBooleanArray(EXPAND_STATE_MAP, this.expandableList.expandedGroupIndexes);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null || !savedInstanceState.containsKey(EXPAND_STATE_MAP)) {
            return;
        }
        this.expandableList.expandedGroupIndexes = savedInstanceState.getBooleanArray(EXPAND_STATE_MAP);
        this.notifyDataSetChanged();
    }

    public void setOnGroupClickListener(OnGroupClickListener listener) {
        this.groupClickListener = listener;
    }

    public void setOnGroupExpandCollapseListener(GroupExpandCollapseListener listener) {
        this.expandCollapseListener = listener;
    }

    public List<? extends ExpandableGroup> getGroups() {
        return this.expandableList.groups;
    }

    public abstract GVH onCreateGroupViewHolder(ViewGroup var1, int var2);

    public abstract CVH onCreateChildViewHolder(ViewGroup var1, int var2);

    public abstract void onBindChildViewHolder(CVH var1, int var2, ExpandableGroup var3, int var4);

    public abstract void onBindGroupViewHolder(GVH var1, int var2, ExpandableGroup var3);
}

